/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.lang;

import com.intellij.util.lang.ClassPath;
import com.intellij.util.lang.MultiParentClassLoaderSupport;
import com.intellij.util.lang.Resource;
import com.intellij.util.lang.UrlClassLoader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URL;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

@ApiStatus.Internal
public final class MultiParentClassLoaderHelper {
    private static final ClassLoader[] EMPTY_CLASS_LOADER_ARRAY = new ClassLoader[0];
    private static final AtomicInteger parentListCacheIdCounter = new AtomicInteger();
    @NotNull
    private final @NotNull Supplier<@NotNull @Unmodifiable List<@NotNull ClassLoader>> directParentsSupplier;
    @NotNull
    private final ClassLoader coreLoader;
    private volatile ClassLoader @Nullable [] allParents;
    private volatile int allParentsLastCacheId;

    public MultiParentClassLoaderHelper(@NotNull @NotNull Supplier<@NotNull @Unmodifiable List<@NotNull ClassLoader>> directParentsSupplier, @NotNull ClassLoader coreLoader) {
        if (directParentsSupplier == null) {
            MultiParentClassLoaderHelper.$$$reportNull$$$0(0);
        }
        if (coreLoader == null) {
            MultiParentClassLoaderHelper.$$$reportNull$$$0(1);
        }
        this.allParentsLastCacheId = 0;
        this.directParentsSupplier = directParentsSupplier;
        this.coreLoader = coreLoader;
    }

    @ApiStatus.Internal
    public ClassLoader @NotNull [] getAllParents() {
        ClassLoader classLoader;
        ClassLoader[] result = this.allParents;
        if (result != null && this.allParentsLastCacheId == parentListCacheIdCounter.get()) {
            if (result == null) {
                MultiParentClassLoaderHelper.$$$reportNull$$$0(2);
            }
            return result;
        }
        List<ClassLoader> directParents = this.directParentsSupplier.get();
        if (directParents.isEmpty()) {
            result = new ClassLoader[]{this.coreLoader};
            this.allParents = result;
            if (result == null) {
                MultiParentClassLoaderHelper.$$$reportNull$$$0(3);
            }
            return result;
        }
        LinkedHashSet<ClassLoader> parentSet = new LinkedHashSet<ClassLoader>();
        ArrayDeque<ClassLoader> queue = new ArrayDeque<ClassLoader>(directParents);
        while ((classLoader = (ClassLoader)queue.pollFirst()) != null) {
            if (!parentSet.add(classLoader) || !(classLoader instanceof MultiParentClassLoaderSupport)) continue;
            ((MultiParentClassLoaderSupport)((Object)classLoader)).collectDirectParents(queue);
        }
        parentSet.add(this.coreLoader);
        result = parentSet.toArray(EMPTY_CLASS_LOADER_ARRAY);
        this.allParents = result;
        this.allParentsLastCacheId = parentListCacheIdCounter.get();
        if (result == null) {
            MultiParentClassLoaderHelper.$$$reportNull$$$0(4);
        }
        return result;
    }

    public void collectClassLoaders(@NotNull Deque<ClassLoader> queue) {
        if (queue == null) {
            MultiParentClassLoaderHelper.$$$reportNull$$$0(5);
        }
        queue.addAll((Collection<ClassLoader>)this.directParentsSupplier.get());
    }

    public void clearCache() {
        this.allParents = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte @Nullable [] getResourceAsBytes(@NotNull ClassPath ownerClassPath, @NotNull String name, boolean checkParents) {
        if (ownerClassPath == null) {
            MultiParentClassLoaderHelper.$$$reportNull$$$0(6);
        }
        if (name == null) {
            MultiParentClassLoaderHelper.$$$reportNull$$$0(7);
        }
        try {
            Resource resource = ownerClassPath.findResource(name);
            if (resource != null) {
                return resource.getBytes();
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        if (!checkParents) {
            return null;
        }
        ClassLoader[] classLoaderArray = this.getAllParents();
        int n = classLoaderArray.length;
        int n2 = 0;
        while (n2 < n) {
            ClassLoader classloader = classLoaderArray[n2];
            if (classloader instanceof UrlClassLoader) {
                Resource resource = ((UrlClassLoader)classloader).getClassPath().findResource(name);
                if (resource != null) {
                    try {
                        return resource.getBytes();
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
            } else {
                try (InputStream input = classloader.getResourceAsStream(name);){
                    if (input != null) {
                        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                        byte[] data = new byte[8192];
                        while (true) {
                            int nRead;
                            if ((nRead = input.read(data, 0, data.length)) == -1) {
                                byte[] byArray = buffer.toByteArray();
                                return byArray;
                            }
                            buffer.write(data, 0, nRead);
                        }
                    }
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            ++n2;
        }
        return null;
    }

    @Nullable
    public URL findResource(@NotNull ClassPath ownerClassPath, @NotNull String name) {
        Resource resource;
        if (ownerClassPath == null) {
            MultiParentClassLoaderHelper.$$$reportNull$$$0(8);
        }
        if (name == null) {
            MultiParentClassLoaderHelper.$$$reportNull$$$0(9);
        }
        if ((resource = ownerClassPath.findResource(name)) != null) {
            return resource.getURL();
        }
        for (ClassLoader classloader : this.getAllParents()) {
            if (classloader instanceof UrlClassLoader) {
                resource = ((UrlClassLoader)classloader).getClassPath().findResource(name);
                if (resource == null) continue;
                return resource.getURL();
            }
            URL url = classloader.getResource(name);
            if (url == null) continue;
            return url;
        }
        return null;
    }

    @Nullable
    public InputStream getResourceAsStream(@NotNull ClassPath ownerClassPath, @NotNull String name) {
        Resource resource;
        if (ownerClassPath == null) {
            MultiParentClassLoaderHelper.$$$reportNull$$$0(10);
        }
        if (name == null) {
            MultiParentClassLoaderHelper.$$$reportNull$$$0(11);
        }
        if ((resource = ownerClassPath.findResource(name)) != null) {
            try {
                return resource.getInputStream();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        for (ClassLoader classloader : this.getAllParents()) {
            if (classloader instanceof UrlClassLoader) {
                resource = ((UrlClassLoader)classloader).getClassPath().findResource(name);
                if (resource == null) continue;
                try {
                    return resource.getInputStream();
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            InputStream stream = classloader.getResourceAsStream(name);
            if (stream == null) continue;
            return stream;
        }
        return null;
    }

    @NotNull
    public Enumeration<URL> findResources(@NotNull ClassPath ownerClassPath, @NotNull String name) {
        if (ownerClassPath == null) {
            MultiParentClassLoaderHelper.$$$reportNull$$$0(12);
        }
        if (name == null) {
            MultiParentClassLoaderHelper.$$$reportNull$$$0(13);
        }
        ArrayList<Enumeration<URL>> resources = new ArrayList<Enumeration<URL>>();
        resources.add(ownerClassPath.getResources(name));
        for (ClassLoader classloader : this.getAllParents()) {
            if (classloader instanceof UrlClassLoader) {
                resources.add(((UrlClassLoader)classloader).getClassPath().getResources(name));
                continue;
            }
            try {
                resources.add(classloader.getResources(name));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return new DeepEnumeration(resources);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directParentsSupplier";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coreLoader";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/lang/MultiParentClassLoaderHelper";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queue";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ownerClassPath";
                break;
            }
            case 7: 
            case 9: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/lang/MultiParentClassLoaderHelper";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllParents";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "collectClassLoaders";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getResourceAsBytes";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findResource";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getResourceAsStream";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findResources";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class DeepEnumeration
    implements Enumeration<URL> {
        private final List<Enumeration<URL>> list;
        private int index = 0;

        DeepEnumeration(List<Enumeration<URL>> list) {
            this.list = list;
        }

        @Override
        public boolean hasMoreElements() {
            while (this.index < this.list.size()) {
                Enumeration<URL> e = this.list.get(this.index);
                if (e.hasMoreElements()) {
                    return true;
                }
                ++this.index;
            }
            return false;
        }

        @Override
        public URL nextElement() {
            if (!this.hasMoreElements()) {
                throw new NoSuchElementException();
            }
            return this.list.get(this.index).nextElement();
        }
    }
}

