/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.coverage.report.impl.html;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import jetbrains.coverage.report.CoverageStatistics;
import jetbrains.coverage.report.Entry;
import jetbrains.coverage.report.StatisticsCalculator;
import jetbrains.coverage.report.impl.html.LocalGeneratorPaths;
import jetbrains.coverage.report.impl.html.SortOption;
import jetbrains.coverage.report.impl.html.TemplateProcessor;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseGenerator {
    protected final TemplateProcessor myTemplateFactory;
    protected final LocalGeneratorPaths myPaths;

    public BaseGenerator(@NotNull TemplateProcessor templateFactory, @NotNull LocalGeneratorPaths paths) {
        this.myPaths = paths;
        this.myTemplateFactory = templateFactory;
    }

    private boolean isCovered(CoverageStatistics stat) {
        return !this.isEmpty(stat.getLineStats()) || !this.isEmpty(stat.getStatementStats());
    }

    private boolean isEmpty(Entry entry) {
        return entry == null || entry.getTotal() <= 0 || entry.getCovered() < 0;
    }

    @NotNull
    protected Collection<SortOption> getGenerateSortOptions(@NotNull StatisticsCalculator covStatsCalculator) {
        ArrayList<SortOption> sortOptions = new ArrayList<SortOption>(Arrays.asList(SortOption.values()));
        sortOptions.remove((Object)SortOption.NONE);
        if (this.isEmpty(covStatsCalculator.getOverallStats().getLineStats())) {
            sortOptions.remove((Object)SortOption.SORT_BY_LINE);
            sortOptions.remove((Object)SortOption.SORT_BY_LINE_DESC);
        }
        if (this.isEmpty(covStatsCalculator.getOverallStats().getStatementStats())) {
            sortOptions.remove((Object)SortOption.SORT_BY_STATEMENT);
            sortOptions.remove((Object)SortOption.SORT_BY_STATEMENT_DESC);
        }
        return sortOptions;
    }

    @NotNull
    protected <T> List<T> filterCovered(@NotNull Collection<T> collection, @NotNull Converter<T> conv) {
        ArrayList<T> list = new ArrayList<T>(collection.size());
        for (T t : collection) {
            if (!this.isCovered(conv.convert(t))) continue;
            list.add(t);
        }
        return list;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static interface Converter<T> {
        @NotNull
        public CoverageStatistics convert(T var1);
    }
}

