/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.teamcity;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.intellij.TestCaseLoader;
import com.intellij.nastradamus.model.ChangeEntity;
import com.intellij.openapi.application.PathManager;
import com.intellij.tool.ErrorThresholdKt;
import com.intellij.tool.HttpClient;
import com.intellij.tool.NastradamusCache;
import com.intellij.tool.RetryKt;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Stream;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.io.path.PathsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.apache.http.HttpMessage;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.auth.BasicScheme;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0014\n\u0002\u0010\u000b\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u001b\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001c\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u0005H\u0002J\u001a\u0010#\u001a\u00020\u00112\u0006\u0010$\u001a\u00020\u00112\b\b\u0002\u0010%\u001a\u00020&H\u0002J\u001b\u00109\u001a\u0002H:\"\b\b\u0000\u0010:*\u00020;*\u0002H:H\u0002\u00a2\u0006\u0002\u0010<J\u000e\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020\u0003J\u0014\u0010B\u001a\b\u0012\u0004\u0012\u00020@0C2\u0006\u0010'\u001a\u00020\u0011J\f\u0010B\u001a\b\u0012\u0004\u0012\u00020@0CJ\u0014\u0010D\u001a\b\u0012\u0004\u0012\u00020E0C2\u0006\u0010F\u001a\u00020\u0011J\u0016\u0010G\u001a\b\u0012\u0004\u0012\u00020@0C2\u0006\u0010'\u001a\u00020\u0011H\u0002J\f\u0010G\u001a\b\u0012\u0004\u0012\u00020@0CJ\u0010\u0010H\u001a\u00020@2\u0006\u0010'\u001a\u00020\u0011H\u0002J\u0006\u0010H\u001a\u00020@J\u0010\u0010I\u001a\u00020@2\u0006\u0010'\u001a\u00020\u0011H\u0002J\u0006\u0010I\u001a\u00020@J*\u0010J\u001a\u00020K2\u0006\u0010L\u001a\u00020\u00052\u0006\u0010M\u001a\u00020\u00112\b\b\u0002\u0010N\u001a\u00020\u00112\b\b\u0002\u0010O\u001a\u00020&R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\n\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR'\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110\u00108BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u000e\u001a\u0004\b\u0014\u0010\u0015R\u0016\u0010\u0017\u001a\n \u0018*\u0004\u0018\u00010\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0019\u001a\u00020\u00118FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001c\u0010\u000e\u001a\u0004\b\u001a\u0010\u001bR\u001d\u0010\u001d\u001a\u0004\u0018\u00010\u00118FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001f\u0010\u000e\u001a\u0004\b\u001e\u0010\u001bR'\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110\u00108BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\"\u0010\u000e\u001a\u0004\b!\u0010\u0015R\u001b\u0010'\u001a\u00020\u00118FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b)\u0010\u000e\u001a\u0004\b(\u0010\u001bR\u001b\u0010*\u001a\u00020\u00118FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b,\u0010\u000e\u001a\u0004\b+\u0010\u001bR\u001b\u0010-\u001a\u00020\u00118FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b/\u0010\u000e\u001a\u0004\b.\u0010\u001bR\u001b\u00100\u001a\u00020\u00118FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b2\u0010\u000e\u001a\u0004\b1\u0010\u001bR\u001b\u00103\u001a\u00020\u00118BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b5\u0010\u000e\u001a\u0004\b4\u0010\u001bR\u001b\u00106\u001a\u00020\u00118BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b8\u0010\u000e\u001a\u0004\b7\u0010\u001bR\u000e\u0010=\u001a\u00020>X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006P"}, d2={"Lcom/intellij/teamcity/TeamCityClient;", "", "baseUri", "Ljava/net/URI;", "systemPropertiesFilePath", "Ljava/nio/file/Path;", "<init>", "(Ljava/net/URI;Ljava/nio/file/Path;)V", "getBaseUri", "()Ljava/net/URI;", "artifactForPublishingDir", "getArtifactForPublishingDir", "()Ljava/nio/file/Path;", "artifactForPublishingDir$delegate", "Lkotlin/Lazy;", "loadProperties", "", "", "propertiesPath", "systemProperties", "getSystemProperties", "()Ljava/util/Map;", "systemProperties$delegate", "restUri", "kotlin.jvm.PlatformType", "buildNumber", "getBuildNumber", "()Ljava/lang/String;", "buildNumber$delegate", "configurationName", "getConfigurationName", "configurationName$delegate", "buildParams", "getBuildParams", "buildParams$delegate", "getExistingParameter", "name", "impreciseNameMatch", "", "buildId", "getBuildId", "buildId$delegate", "buildTypeId", "getBuildTypeId", "buildTypeId$delegate", "os", "getOs", "os$delegate", "branchName", "getBranchName", "branchName$delegate", "userName", "getUserName", "userName$delegate", "password", "getPassword", "password$delegate", "withAuth", "T", "Lorg/apache/http/HttpRequest;", "(Lorg/apache/http/HttpRequest;)Lorg/apache/http/HttpRequest;", "jacksonMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "get", "Lcom/fasterxml/jackson/databind/JsonNode;", "fullUrl", "getChanges", "", "getChangeDetails", "Lcom/intellij/nastradamus/model/ChangeEntity;", "changeId", "getTestRunInfo", "getBuildInfo", "getTriggeredByInfo", "publishTeamCityArtifacts", "", "source", "artifactPath", "artifactName", "zipContent", "intellij.platform.testFramework.core"})
@SourceDebugExtension(value={"SMAP\nTeamCityClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TeamCityClient.kt\ncom/intellij/teamcity/TeamCityClient\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,289:1\n216#2,2:290\n126#2:300\n153#2,3:301\n536#3:292\n521#3,6:293\n1#4:299\n1563#5:304\n1634#5,3:305\n*S KotlinDebug\n*F\n+ 1 TeamCityClient.kt\ncom/intellij/teamcity/TeamCityClient\n*L\n41#1:290,2\n55#1:300\n55#1:301,3\n75#1:292\n75#1:293,6\n158#1:304\n158#1:305,3\n*E\n"})
public final class TeamCityClient {
    @NotNull
    private final URI baseUri;
    @NotNull
    private final Path systemPropertiesFilePath;
    @NotNull
    private final Lazy artifactForPublishingDir$delegate;
    @NotNull
    private final Lazy systemProperties$delegate;
    private final URI restUri;
    @NotNull
    private final Lazy buildNumber$delegate;
    @NotNull
    private final Lazy configurationName$delegate;
    @NotNull
    private final Lazy buildParams$delegate;
    @NotNull
    private final Lazy buildId$delegate;
    @NotNull
    private final Lazy buildTypeId$delegate;
    @NotNull
    private final Lazy os$delegate;
    @NotNull
    private final Lazy branchName$delegate;
    @NotNull
    private final Lazy userName$delegate;
    @NotNull
    private final Lazy password$delegate;
    @NotNull
    private final ObjectMapper jacksonMapper;

    public TeamCityClient(@NotNull URI baseUri, @NotNull Path systemPropertiesFilePath) {
        Intrinsics.checkNotNullParameter((Object)baseUri, (String)"baseUri");
        Intrinsics.checkNotNullParameter((Object)systemPropertiesFilePath, (String)"systemPropertiesFilePath");
        this.baseUri = baseUri;
        this.systemPropertiesFilePath = systemPropertiesFilePath;
        this.artifactForPublishingDir$delegate = LazyKt.lazy(TeamCityClient::artifactForPublishingDir_delegate$lambda$0);
        this.systemProperties$delegate = LazyKt.lazy(() -> TeamCityClient.systemProperties_delegate$lambda$0(this));
        this.restUri = this.baseUri.resolve("/app/rest/");
        this.buildNumber$delegate = LazyKt.lazy(TeamCityClient::buildNumber_delegate$lambda$0);
        this.configurationName$delegate = LazyKt.lazy(() -> TeamCityClient.configurationName_delegate$lambda$0(this));
        this.buildParams$delegate = LazyKt.lazy(() -> TeamCityClient.buildParams_delegate$lambda$0(this));
        this.buildId$delegate = LazyKt.lazy(() -> TeamCityClient.buildId_delegate$lambda$0(this));
        this.buildTypeId$delegate = LazyKt.lazy(() -> TeamCityClient.buildTypeId_delegate$lambda$0(this));
        this.os$delegate = LazyKt.lazy(() -> TeamCityClient.os_delegate$lambda$0(this));
        this.branchName$delegate = LazyKt.lazy(() -> TeamCityClient.branchName_delegate$lambda$0(this));
        this.userName$delegate = LazyKt.lazy(() -> TeamCityClient.userName_delegate$lambda$0(this));
        this.password$delegate = LazyKt.lazy(() -> TeamCityClient.password_delegate$lambda$0(this));
        this.jacksonMapper = ExtensionsKt.jacksonObjectMapper();
    }

    public /* synthetic */ TeamCityClient(URI uRI, Path path, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            URI uRI2 = new URI("https://buildserver.labs.intellij.net").normalize();
            Intrinsics.checkNotNullExpressionValue((Object)uRI2, (String)"normalize(...)");
            uRI = uRI2;
        }
        if ((n & 2) != 0) {
            String string = System.getenv("TEAMCITY_BUILD_PROPERTIES_FILE");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getenv(...)");
            Path path2 = Paths.get(string, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
            path = path2;
        }
        this(uRI, path);
    }

    @NotNull
    public final URI getBaseUri() {
        return this.baseUri;
    }

    @NotNull
    public final Path getArtifactForPublishingDir() {
        Lazy lazy = this.artifactForPublishingDir$delegate;
        return (Path)lazy.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Map<String, String> loadProperties(Path propertiesPath) {
        Object object;
        try {
            Map map;
            object = propertiesPath;
            OpenOption[] openOptionArray = new OpenOption[]{};
            Object object2 = Charsets.UTF_8;
            int n = 8192;
            object = new BufferedReader(new InputStreamReader(Files.newInputStream((Path)object, Arrays.copyOf(openOptionArray, openOptionArray.length)), (Charset)object2), n);
            object2 = null;
            try {
                BufferedReader it = (BufferedReader)object;
                boolean bl = false;
                Map map2 = new LinkedHashMap();
                Properties ps = new Properties();
                ps.load(it);
                Map $this$forEach$iv = ps;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry element$iv;
                    Map.Entry entry = element$iv = iterator.next();
                    boolean bl2 = false;
                    Object k = entry.getKey();
                    Object v = entry.getValue();
                    if (k == null || v == null) continue;
                    map2.put(k.toString(), v.toString());
                }
                map = map2;
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
            }
            object = map;
        }
        catch (Throwable throwable) {
            object = MapsKt.emptyMap();
        }
        return object;
    }

    private final Map<String, String> getSystemProperties() {
        Lazy lazy = this.systemProperties$delegate;
        return (Map)lazy.getValue();
    }

    @NotNull
    public final String getBuildNumber() {
        Lazy lazy = this.buildNumber$delegate;
        return (String)lazy.getValue();
    }

    @Nullable
    public final String getConfigurationName() {
        Lazy lazy = this.configurationName$delegate;
        return (String)lazy.getValue();
    }

    private final Map<String, String> getBuildParams() {
        Lazy lazy = this.buildParams$delegate;
        return (Map)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    private final String getExistingParameter(String name, boolean impreciseNameMatch) {
        String paramValue;
        String string;
        Map totalParams = MapsKt.plus(this.getSystemProperties(), this.getBuildParams());
        if (impreciseNameMatch) {
            void $this$filterTo$iv$iv;
            Map $this$filter$iv = totalParams;
            boolean $i$f$filter = false;
            Map map = $this$filter$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$filterTo = false;
            Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv$iv;
                Map.Entry it = element$iv$iv = iterator.next();
                boolean bl = false;
                if (!StringsKt.contains$default((CharSequence)((CharSequence)it.getKey()), (CharSequence)name, (boolean)false, (int)2, null)) continue;
                destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            Map paramCandidates = destination$iv$iv;
            if (paramCandidates.size() > 1) {
                System.err.println("Found many parameters matching " + name + ". Candidates: " + paramCandidates);
            }
            string = (String)paramCandidates.get(MapsKt.toSortedMap((Map)paramCandidates).firstKey());
        } else {
            string = (String)totalParams.get(name);
        }
        String string2 = paramValue = string;
        if (string2 == null) {
            throw new IllegalStateException(("Parameter " + name + " is not specified in the build!").toString());
        }
        return string2;
    }

    static /* synthetic */ String getExistingParameter$default(TeamCityClient teamCityClient, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return teamCityClient.getExistingParameter(string, bl);
    }

    @NotNull
    public final String getBuildId() {
        Lazy lazy = this.buildId$delegate;
        return (String)lazy.getValue();
    }

    @NotNull
    public final String getBuildTypeId() {
        Lazy lazy = this.buildTypeId$delegate;
        return (String)lazy.getValue();
    }

    @NotNull
    public final String getOs() {
        Lazy lazy = this.os$delegate;
        return (String)lazy.getValue();
    }

    @NotNull
    public final String getBranchName() {
        Lazy lazy = this.branchName$delegate;
        return (String)lazy.getValue();
    }

    private final String getUserName() {
        Lazy lazy = this.userName$delegate;
        return (String)lazy.getValue();
    }

    private final String getPassword() {
        Lazy lazy = this.password$delegate;
        return (String)lazy.getValue();
    }

    private final <T extends HttpRequest> T withAuth(T $this$withAuth) {
        T t;
        T $this$withAuth_u24lambda_u240 = t = $this$withAuth;
        boolean bl = false;
        ((HttpMessage)$this$withAuth_u24lambda_u240).addHeader(new BasicScheme().authenticate((Credentials)new UsernamePasswordCredentials(this.getUserName(), this.getPassword()), $this$withAuth_u24lambda_u240, null));
        return t;
    }

    @NotNull
    public final JsonNode get(@NotNull URI fullUrl) {
        JsonNode result;
        HttpGet httpGet;
        Intrinsics.checkNotNullParameter((Object)fullUrl, (String)"fullUrl");
        HttpGet $this$get_u24lambda_u240 = httpGet = new HttpGet(fullUrl);
        boolean bl = false;
        $this$get_u24lambda_u240.addHeader("Content-Type", "application/json");
        $this$get_u24lambda_u240.addHeader("Accept", "application/json");
        this.withAuth((HttpRequest)$this$get_u24lambda_u240);
        HttpGet request = httpGet;
        if (TestCaseLoader.IS_VERBOSE_LOG_ENABLED) {
            System.out.println((Object)("Request to TeamCity: " + fullUrl));
        }
        JsonNode jsonNode = result = (JsonNode)ErrorThresholdKt.withErrorThreshold$default("TeamCityClient-get", 0, () -> TeamCityClient.get$lambda$1(request, this), () -> TeamCityClient.get$lambda$2(fullUrl), 2, null);
        if (jsonNode == null) {
            boolean bl2 = false;
            String string = "Request " + request.getURI() + " failed";
            throw new IllegalArgumentException(string.toString());
        }
        return jsonNode;
    }

    @NotNull
    public final List<JsonNode> getChanges(@NotNull String buildId) {
        Intrinsics.checkNotNullParameter((Object)buildId, (String)"buildId");
        URI fullUrl = this.restUri.resolve("changes?locator=build:(id:" + buildId + ")");
        String rawData = NastradamusCache.INSTANCE.get(fullUrl, (Function0<String>)((Function0)() -> TeamCityClient.getChanges$lambda$0(this, fullUrl)));
        Set set = this.jacksonMapper.readTree(rawData).properties();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"properties(...)");
        return SequencesKt.toList((Sequence)SequencesKt.flatMapIterable((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)set), TeamCityClient::getChanges$lambda$1), TeamCityClient::getChanges$lambda$2));
    }

    @NotNull
    public final List<JsonNode> getChanges() {
        return this.getChanges(this.getBuildId());
    }

    @NotNull
    public final List<ChangeEntity> getChangeDetails(@NotNull String changeId) {
        Intrinsics.checkNotNullParameter((Object)changeId, (String)"changeId");
        URI fullUrl = this.restUri.resolve("changes/id:" + changeId);
        String rawChange = NastradamusCache.INSTANCE.get(fullUrl, (Function0<String>)((Function0)() -> TeamCityClient.getChangeDetails$lambda$1(this, fullUrl)));
        JsonNode jsonNode = this.jacksonMapper.readTree(rawChange);
        Intrinsics.checkNotNullExpressionValue((Object)jsonNode, (String)"readTree(...)");
        return TeamCityClient.getChangeDetails$processData(jsonNode);
    }

    private final List<JsonNode> getTestRunInfo(String buildId) {
        int countOfTestsOnPage = 200;
        int startPosition = 0;
        List accumulatedTests = new ArrayList();
        List currentTests = null;
        System.out.println((Object)"Getting test run info from TC ...");
        do {
            URI fullUrl = this.restUri.resolve("testOccurrences?locator=build:(id:" + buildId + "),ignored:any,muted:any,count:" + countOfTestsOnPage + ",start:" + startPosition + ",includePersonal:true&fields=nextHref,testOccurrence(id,name,status,duration,currentlyInvestigated,currentlyMuted,muted,test(id,parsedTestName),newFailure,metadata(count),nextFixed(id),runOrder)");
            String rawData = NastradamusCache.INSTANCE.get(fullUrl, (Function0<String>)((Function0)() -> TeamCityClient.getTestRunInfo$lambda$0(this, fullUrl)));
            Set set = this.jacksonMapper.readTree(rawData).properties();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"properties(...)");
            currentTests = SequencesKt.toList((Sequence)SequencesKt.flatMapIterable((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)set), TeamCityClient::getTestRunInfo$lambda$1), TeamCityClient::getTestRunInfo$lambda$2));
            accumulatedTests.addAll(currentTests);
            startPosition += countOfTestsOnPage;
        } while (!((Collection)currentTests).isEmpty());
        System.out.println((Object)("Test run info acquired. Count of tests " + accumulatedTests.size()));
        return accumulatedTests;
    }

    @NotNull
    public final List<JsonNode> getTestRunInfo() {
        return this.getTestRunInfo(this.getBuildId());
    }

    private final JsonNode getBuildInfo(String buildId) {
        URI fullUrl = this.restUri.resolve("builds/" + buildId);
        String rawData = NastradamusCache.INSTANCE.get(fullUrl, (Function0<String>)((Function0)() -> TeamCityClient.getBuildInfo$lambda$0(this, fullUrl)));
        JsonNode jsonNode = this.jacksonMapper.readTree(rawData);
        Intrinsics.checkNotNullExpressionValue((Object)jsonNode, (String)"readTree(...)");
        return jsonNode;
    }

    @NotNull
    public final JsonNode getBuildInfo() {
        return this.getBuildInfo(this.getBuildId());
    }

    private final JsonNode getTriggeredByInfo(String buildId) {
        JsonNode jsonNode = this.getBuildInfo(buildId).findValue("triggered");
        Intrinsics.checkNotNullExpressionValue((Object)jsonNode, (String)"findValue(...)");
        return jsonNode;
    }

    @NotNull
    public final JsonNode getTriggeredByInfo() {
        return this.getTriggeredByInfo(this.getBuildId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void publishTeamCityArtifacts(@NotNull Path source, @NotNull String artifactPath, @NotNull String artifactName, boolean zipContent) {
        Object object;
        Object object2;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)artifactPath, (String)"artifactPath");
        Intrinsics.checkNotNullParameter((Object)artifactName, (String)"artifactName");
        Path path = source;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(path, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            System.err.println("TeamCity artifact " + source + " does not exist");
            return;
        }
        Object suffix = null;
        int nextSuffix = 0;
        Path artifactDir = null;
        do {
            suffix = nextSuffix == 0 ? "" : "-" + nextSuffix;
            LinkOption[] linkOptionArray2 = this.getArtifactForPublishingDir().resolve(artifactPath);
            Intrinsics.checkNotNullExpressionValue((Object)linkOptionArray2, (String)"resolve(...)");
            object = linkOptionArray2;
            Path path2 = object.resolve(artifactName + (String)suffix);
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
            Intrinsics.checkNotNullExpressionValue((Object)path2.normalize().toAbsolutePath(), (String)"toAbsolutePath(...)");
            ++nextSuffix;
        } while (Files.exists((Path)(object2 = artifactDir), Arrays.copyOf(object = new LinkOption[0], ((LinkOption[])object).length)));
        PathsKt.deleteRecursively((Path)artifactDir);
        object2 = artifactDir;
        object = new FileAttribute[]{};
        Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories((Path)object2, (FileAttribute[])Arrays.copyOf(object, ((Object[])object).length)), (String)"createDirectories(...)");
        object2 = source;
        object = new LinkOption[]{};
        if (Files.isDirectory((Path)object2, (LinkOption[])Arrays.copyOf(object, ((Object[])object).length))) {
            object2 = Files.walk(source, new FileVisitOption[0]);
            object = null;
            try {
                Stream files = (Stream)object2;
                boolean bl = false;
                Iterator iterator = files.iterator();
                while (iterator.hasNext()) {
                    Path path3;
                    Path path4 = (Path)iterator.next();
                    Intrinsics.checkNotNull((Object)path4);
                    Path path5 = path4;
                    Intrinsics.checkNotNullExpressionValue((Object)artifactDir.resolve(source.relativize(path4)), (String)"resolve(...)");
                    CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                    CopyOption[] copyOptionArray2 = copyOptionArray;
                    Intrinsics.checkNotNullExpressionValue((Object)Files.copy(path5, path3, Arrays.copyOf(copyOptionArray2, copyOptionArray2.length)), (String)"copy(...)");
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)object2, (Throwable)object);
            }
            if (zipContent) {
                TeamCityClient.publishTeamCityArtifacts$printTcArtifactsPublishMessage(artifactDir.toRealPath(new LinkOption[0]) + "/** => " + artifactPath + "/" + artifactName + (String)suffix + ".zip");
            } else {
                TeamCityClient.publishTeamCityArtifacts$printTcArtifactsPublishMessage(artifactDir.toRealPath(new LinkOption[0]) + "/** => " + artifactPath + (String)suffix);
            }
        } else {
            Path tempFile = artifactDir;
            object = source;
            CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
            CopyOption[] copyOptionArray3 = copyOptionArray;
            Intrinsics.checkNotNullExpressionValue((Object)Files.copy((Path)object, tempFile, Arrays.copyOf(copyOptionArray3, copyOptionArray3.length)), (String)"copy(...)");
            if (zipContent) {
                TeamCityClient.publishTeamCityArtifacts$printTcArtifactsPublishMessage(tempFile.toRealPath(new LinkOption[0]) + " => " + artifactPath + "/" + artifactName + (String)suffix + ".zip");
            } else {
                TeamCityClient.publishTeamCityArtifacts$printTcArtifactsPublishMessage(tempFile.toRealPath(new LinkOption[0]) + " => " + artifactPath);
            }
        }
    }

    public static /* synthetic */ void publishTeamCityArtifacts$default(TeamCityClient teamCityClient, Path path, String string, String string2, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = ((Object)path.getFileName()).toString();
        }
        if ((n & 8) != 0) {
            bl = true;
        }
        teamCityClient.publishTeamCityArtifacts(path, string, string2, bl);
    }

    private static final Path artifactForPublishingDir_delegate$lambda$0() {
        Path path = PathManager.getLogDir().getParent().resolve("teamcity-artifacts-for-publish");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        Path path2 = path;
        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
        Path path3 = Files.createDirectories(path2, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"createDirectories(...)");
        return path3;
    }

    /*
     * WARNING - void declaration
     */
    private static final Map systemProperties_delegate$lambda$0(TeamCityClient this$0) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Map<String, String> map = this$0.loadProperties(this$0.systemPropertiesFilePath);
        Properties properties = System.getProperties();
        Intrinsics.checkNotNullExpressionValue((Object)properties, (String)"getProperties(...)");
        Map map2 = properties;
        Map<String, String> map3 = map;
        boolean $i$f$map = false;
        void var3_4 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to((Object)it.getKey().toString(), (Object)it.getValue().toString()));
        }
        return MapsKt.plus(map3, (Iterable)((List)destination$iv$iv));
    }

    private static final String buildNumber_delegate$lambda$0() {
        String string = System.getenv("BUILD_NUMBER");
        if (string == null) {
            string = "";
        }
        return string;
    }

    private static final String configurationName_delegate$lambda$0(TeamCityClient this$0) {
        return this$0.getSystemProperties().get("teamcity.buildConfName");
    }

    private static final Map buildParams_delegate$lambda$0(TeamCityClient this$0) {
        String configurationPropertiesFile = this$0.getSystemProperties().get("teamcity.configuration.properties.file");
        CharSequence charSequence = configurationPropertiesFile;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return MapsKt.emptyMap();
        }
        Path path = Paths.get(configurationPropertiesFile, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        return this$0.loadProperties(path);
    }

    private static final String buildId_delegate$lambda$0(TeamCityClient this$0) {
        return TeamCityClient.getExistingParameter$default(this$0, "teamcity.build.id", false, 2, null);
    }

    private static final String buildTypeId_delegate$lambda$0(TeamCityClient this$0) {
        return TeamCityClient.getExistingParameter$default(this$0, "teamcity.buildType.id", false, 2, null);
    }

    private static final String os_delegate$lambda$0(TeamCityClient this$0) {
        return TeamCityClient.getExistingParameter$default(this$0, "teamcity.agent.jvm.os.name", false, 2, null);
    }

    private static final String branchName_delegate$lambda$0(TeamCityClient this$0) {
        String string = (String)MapsKt.plus(this$0.getSystemProperties(), this$0.getBuildParams()).get("teamcity.build.branch");
        if (string == null) {
            string = "";
        }
        return string;
    }

    private static final String userName_delegate$lambda$0(TeamCityClient this$0) {
        return TeamCityClient.getExistingParameter$default(this$0, "teamcity.auth.userId", false, 2, null);
    }

    private static final String password_delegate$lambda$0(TeamCityClient this$0) {
        return TeamCityClient.getExistingParameter$default(this$0, "teamcity.auth.password", false, 2, null);
    }

    private static final JsonNode get$lambda$1(HttpGet $request, TeamCityClient this$0) {
        return (JsonNode)RetryKt.withRetry-exY8QGI$default(0, null, 0L, () -> TeamCityClient.get$lambda$1$0($request, this$0), 7, null);
    }

    private static final JsonNode get$lambda$1$0(HttpGet $request, TeamCityClient this$0) {
        return (JsonNode)HttpClient.INSTANCE.sendRequest((HttpUriRequest)$request, arg_0 -> TeamCityClient.get$lambda$1$0$0(this$0, arg_0));
    }

    private static final JsonNode get$lambda$1$0$0(TeamCityClient this$0, HttpResponse it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (it.getStatusLine().getStatusCode() != 200) {
            throw new RuntimeException(StringsKt.trimIndent((String)("\n                TeamCity returned not successful status code " + it.getStatusLine().getStatusCode() + ".\n                " + TextStreamsKt.readText((Reader)new InputStreamReader(it.getEntity().getContent())) + "\n                ")));
        }
        return this$0.jacksonMapper.readTree(it.getEntity().getContent());
    }

    private static final JsonNode get$lambda$2(URI $fullUrl) {
        throw new RuntimeException("Couldn't get data from TeamCity " + $fullUrl);
    }

    private static final String getChanges$lambda$0(TeamCityClient this$0, URI $fullUrl) {
        Intrinsics.checkNotNull((Object)$fullUrl);
        String string = this$0.get($fullUrl).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private static final boolean getChanges$lambda$1(Map.Entry it) {
        return Intrinsics.areEqual(it.getKey(), (Object)"change");
    }

    private static final Iterable getChanges$lambda$2(Map.Entry it) {
        Object v = it.getValue();
        Intrinsics.checkNotNullExpressionValue(v, (String)"<get-value>(...)");
        return (Iterable)v;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<ChangeEntity> getChangeDetails$processData(JsonNode jsonRoot) {
        void $this$mapTo$iv$iv;
        String comment = jsonRoot.findValue("comment").asText();
        String userName = jsonRoot.findValue("username").asText();
        String date = jsonRoot.findValue("date").asText();
        JsonNode jsonNode = jsonRoot.findValue("files").findValue("file");
        Intrinsics.checkNotNullExpressionValue((Object)jsonNode, (String)"findValue(...)");
        List filesFields = CollectionsKt.toList((Iterable)((Iterable)jsonNode));
        Iterable $this$map$iv = filesFields;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Object object;
            void fileField;
            JsonNode jsonNode2 = (JsonNode)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = fileField.findValue("file").asText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asText(...)");
            String string2 = fileField.findValue("relative-file").asText();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asText(...)");
            Object object2 = fileField.findValue("before-revision");
            if (object2 == null || (object2 = object2.asText("")) == null) {
                object2 = "";
            }
            if ((object = fileField.findValue("after-revision")) == null || (object = object.asText("")) == null) {
                object = "";
            }
            String string3 = fileField.findValue("changeType").asText();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"asText(...)");
            Intrinsics.checkNotNull((Object)comment);
            Intrinsics.checkNotNull((Object)userName);
            Intrinsics.checkNotNull((Object)date);
            collection.add(new ChangeEntity(string, string2, (String)object2, (String)object, string3, comment, userName, date));
        }
        return (List)destination$iv$iv;
    }

    private static final String getChangeDetails$lambda$1(TeamCityClient this$0, URI $fullUrl) {
        Intrinsics.checkNotNull((Object)$fullUrl);
        String string = this$0.get($fullUrl).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private static final String getTestRunInfo$lambda$0(TeamCityClient this$0, URI $fullUrl) {
        Intrinsics.checkNotNull((Object)$fullUrl);
        String string = this$0.get($fullUrl).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private static final boolean getTestRunInfo$lambda$1(Map.Entry it) {
        return Intrinsics.areEqual(it.getKey(), (Object)"testOccurrence");
    }

    private static final Iterable getTestRunInfo$lambda$2(Map.Entry it) {
        Object v = it.getValue();
        Intrinsics.checkNotNullExpressionValue(v, (String)"<get-value>(...)");
        return (Iterable)v;
    }

    private static final String getBuildInfo$lambda$0(TeamCityClient this$0, URI $fullUrl) {
        Intrinsics.checkNotNull((Object)$fullUrl);
        String string = this$0.get($fullUrl).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private static final void publishTeamCityArtifacts$printTcArtifactsPublishMessage(String spec) {
        String spec2 = StringsKt.replace$default((String)spec, (String)",", (String)"*", (boolean)false, (int)4, null);
        System.out.println((Object)(" ##teamcity[publishArtifacts '" + spec2 + "'] "));
    }

    public TeamCityClient() {
        this(null, null, 3, null);
    }
}

