/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.ant.execution;

import com.intellij.rt.ant.execution.PacketFactory;
import com.intellij.rt.ant.execution.PacketWriter;
import com.intellij.rt.ant.execution.SegmentedOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.util.ArrayDeque;
import java.util.Deque;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.Task;

public final class IdeaAntLogger2
extends DefaultLogger {
    static SegmentedOutputStream ourErr;
    public static final String OUTPUT_PREFIX = "IDEA_ANT_INTEGRATION";
    private final ThreadLocal<Deque<String>> myCallingTasks = ThreadLocal.withInitial(() -> new ArrayDeque());
    private final Priority myMessagePriority = new MessagePriority();
    private final Priority myTargetPriority = new StatePriority(2);
    private final Priority myTaskPriority = new StatePriority(3);
    private final Priority myAlwaysSend = new Priority(){

        @Override
        public void setPriority(int level) {
        }

        @Override
        protected boolean shouldSend(int priority) {
            return true;
        }
    };

    public IdeaAntLogger2() {
        IdeaAntLogger2.guardStreams();
    }

    public synchronized void setMessageOutputLevel(int level) {
        super.setMessageOutputLevel(level);
        this.myMessagePriority.setPriority(level);
        this.myTargetPriority.setPriority(level);
        this.myTaskPriority.setPriority(level);
        this.myAlwaysSend.setPriority(level);
    }

    public synchronized void buildStarted(BuildEvent event) {
        this.myAlwaysSend.sendMessage('B', event.getPriority(), "");
    }

    public synchronized void buildFinished(BuildEvent event) {
        this.myAlwaysSend.sendMessage('b', event.getPriority(), event.getException());
    }

    public synchronized void targetStarted(BuildEvent event) {
        this.myTargetPriority.sendMessage('G', event.getPriority(), event.getTarget().getName());
    }

    public synchronized void targetFinished(BuildEvent event) {
        this.sendException(event, true);
        this.myTargetPriority.sendMessage('g', event.getPriority(), event.getException());
    }

    public synchronized void taskStarted(BuildEvent event) {
        Task task = event.getTask();
        String taskName = task.getTaskName();
        if (taskName == null) {
            taskName = task.getClass().getSimpleName();
        }
        this.getTaskCallStack().push(taskName);
        this.myTaskPriority.sendMessage('T', event.getPriority(), taskName);
    }

    public synchronized void taskFinished(BuildEvent event) {
        try {
            this.sendException(event, true);
            this.myTaskPriority.sendMessage('t', event.getPriority(), event.getException());
        }
        finally {
            this.getTaskCallStack().pop();
        }
    }

    public synchronized void messageLogged(BuildEvent event) {
        boolean failOnError = IdeaAntLogger2.isFailOnError(event);
        if (this.sendException(event, failOnError)) {
            return;
        }
        int priority = event.getPriority();
        if (priority == 0 && !failOnError) {
            priority = 1;
        }
        String message = event.getMessage();
        if (priority == 0) {
            this.myMessagePriority.sendMessage('E', priority, message);
        } else {
            this.myMessagePriority.sendMessage('M', priority, message);
        }
    }

    private static boolean isFailOnError(BuildEvent event) {
        Task task = event.getTask();
        if (task != null) {
            try {
                Field field = task.getClass().getDeclaredField("failonerror");
                field.setAccessible(true);
                return !Boolean.FALSE.equals(field.get(task));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return true;
    }

    private boolean sendException(BuildEvent event, boolean isFailOnError) {
        Throwable exception = event.getException();
        if (exception != null) {
            boolean insideTryTask = this.getTaskCallStack().contains("try");
            if (isFailOnError && !insideTryTask) {
                this.myAlwaysSend.sendMessage('X', event.getPriority(), exception);
                return true;
            }
            this.myMessagePriority.sendMessage('M', insideTryTask ? 3 : 1, exception.getMessage());
        }
        return false;
    }

    public static void guardStreams() {
        if (ourErr != null) {
            return;
        }
        PrintStream err = System.err;
        ourErr = new SegmentedOutputStream(err);
        System.setErr(new PrintStream(ourErr));
        ourErr.sendStart();
    }

    private static void send(PacketWriter packet) {
        packet.sendThrough(ourErr);
    }

    private static PacketWriter createPacket(char id, int priority) {
        PacketWriter packet = PacketFactory.ourInstance.createPacket(id);
        packet.appendLong(priority);
        return packet;
    }

    private Deque<String> getTaskCallStack() {
        return this.myCallingTasks.get();
    }

    private static class MessagePriority
    extends Priority {
        private int myPriority = 0;

        private MessagePriority() {
        }

        @Override
        public void setPriority(int level) {
            this.myPriority = level;
        }

        @Override
        protected boolean shouldSend(int priority) {
            return priority <= this.myPriority;
        }
    }

    private static abstract class Priority {
        private Priority() {
        }

        protected void performSendMessage(char id, int priority, String text) {
            PacketWriter packet = IdeaAntLogger2.createPacket(id, priority);
            packet.appendChar('M');
            packet.appendLimitedString(text);
            IdeaAntLogger2.send(packet);
        }

        protected void performSendMessage(char id, int priority, Throwable throwable) {
            if (throwable != null) {
                PacketWriter packet = IdeaAntLogger2.createPacket(id, priority);
                StringWriter stackTrace = new StringWriter();
                throwable.printStackTrace(new PrintWriter(stackTrace));
                packet.appendChar('X');
                packet.appendLimitedString(stackTrace.toString());
                IdeaAntLogger2.send(packet);
            } else {
                this.performSendMessage(id, priority, "");
            }
        }

        public void sendMessage(char id, int priority, String text) {
            if (this.shouldSend(priority)) {
                this.performSendMessage(id, priority, text);
            }
        }

        public void sendMessage(char id, int priority, Throwable throwable) {
            if (this.shouldSend(priority)) {
                this.performSendMessage(id, priority, throwable);
            }
        }

        public abstract void setPriority(int var1);

        protected abstract boolean shouldSend(int var1);
    }

    private static class StatePriority
    extends Priority {
        private boolean myEnabled = true;
        private final int myMinLevel;

        StatePriority(int minLevel) {
            this.myMinLevel = minLevel;
        }

        @Override
        public void setPriority(int level) {
            this.myEnabled = this.myMinLevel <= level;
        }

        @Override
        protected boolean shouldSend(int priority) {
            return this.myEnabled;
        }
    }
}

