/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.actions;

import com.intellij.CommonBundle;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.javaFX.JavaFXBundle;
import org.jetbrains.plugins.javaFX.fxml.JavaFxFileTypeFactory;
import org.jetbrains.plugins.javaFX.sceneBuilder.SceneBuilderInfo;

public final class OpenInSceneBuilderAction
extends AnAction {
    private static final Logger LOG = Logger.getInstance(OpenInSceneBuilderAction.class);
    public static final String OLD_LAUNCHER = "scenebuilder-launcher.sh";

    public void actionPerformed(@NotNull AnActionEvent e) {
        VirtualFile virtualFile;
        if (e == null) {
            OpenInSceneBuilderAction.$$$reportNull$$$0(0);
        }
        LOG.assertTrue((virtualFile = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE)) != null);
        String path = virtualFile.getPath();
        Project project = OpenInSceneBuilderAction.getEventProject((AnActionEvent)e);
        SceneBuilderInfo info = SceneBuilderInfo.get(project, true);
        if (info == SceneBuilderInfo.EMPTY) {
            return;
        }
        Object pathToSceneBuilder = info.path;
        if (SystemInfo.isMac) {
            pathToSceneBuilder = new File((String)(pathToSceneBuilder = (String)pathToSceneBuilder + "/Contents/MacOS/"), OLD_LAUNCHER).exists() ? (String)pathToSceneBuilder + OLD_LAUNCHER : (String)pathToSceneBuilder + "SceneBuilder";
        }
        GeneralCommandLine commandLine = new GeneralCommandLine();
        try {
            commandLine.setExePath(FileUtil.toSystemDependentName((String)pathToSceneBuilder));
            commandLine.addParameter(path);
            commandLine.createProcess();
        }
        catch (Throwable ex) {
            Messages.showErrorDialog((String)JavaFXBundle.message("javafx.failed.to.start.scene.builder.error", commandLine.getCommandLineString()), (String)CommonBundle.getErrorTitle());
        }
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            OpenInSceneBuilderAction.$$$reportNull$$$0(1);
        }
        Presentation presentation = e.getPresentation();
        presentation.setEnabledAndVisible(false);
        VirtualFile virtualFile = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        if (virtualFile != null && JavaFxFileTypeFactory.isFxml(virtualFile) && e.getProject() != null) {
            presentation.setEnabledAndVisible(true);
        }
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            OpenInSceneBuilderAction.$$$reportNull$$$0(2);
        }
        return actionUpdateThread;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/javaFX/actions/OpenInSceneBuilderAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/javaFX/actions/OpenInSceneBuilderAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

