/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.actions;

import com.intellij.codeInsight.actions.ChangedRangesShifter;
import com.intellij.codeInsight.actions.PsiCollector;
import com.intellij.codeInsight.actions.VcsFacade;
import com.intellij.diff.comparison.iterables.FairDiffIterable;
import com.intellij.diff.tools.util.text.LineOffsets;
import com.intellij.diff.tools.util.text.LineOffsetsUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListChange;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vcs.changes.SimpleContentRevision;
import com.intellij.openapi.vcs.changes.ui.SimpleAsyncChangesBrowser;
import com.intellij.openapi.vcs.ex.LineStatusTracker;
import com.intellij.openapi.vcs.ex.PartialLocalLineStatusTracker;
import com.intellij.openapi.vcs.ex.Range;
import com.intellij.openapi.vcs.ex.RangesBuilder;
import com.intellij.openapi.vcs.impl.LineStatusTrackerManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.codeStyle.ChangedRangesInfo;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsFileUtil;
import com.intellij.vcsUtil.VcsImplUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import one.util.streamex.EntryStream;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

@ApiStatus.Internal
public final class VcsFacadeImpl
extends VcsFacade {
    @NotNull
    public static VcsFacadeImpl getVcsInstance() {
        VcsFacadeImpl vcsFacadeImpl = (VcsFacadeImpl)VcsFacade.getInstance();
        if (vcsFacadeImpl == null) {
            VcsFacadeImpl.$$$reportNull$$$0(0);
        }
        return vcsFacadeImpl;
    }

    public boolean hasActiveVcss(@NotNull Project project) {
        if (project == null) {
            VcsFacadeImpl.$$$reportNull$$$0(1);
        }
        return ProjectLevelVcsManager.getInstance((Project)project).hasActiveVcss();
    }

    public boolean hasChanges(@NotNull PsiFile file) {
        if (file == null) {
            VcsFacadeImpl.$$$reportNull$$$0(2);
        }
        Project project = file.getProject();
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile != null) {
            Change change = ChangeListManager.getInstance((Project)project).getChange(virtualFile);
            return change != null;
        }
        return false;
    }

    public boolean hasChanges(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            VcsFacadeImpl.$$$reportNull$$$0(3);
        }
        if (project == null) {
            VcsFacadeImpl.$$$reportNull$$$0(4);
        }
        Collection changes = ChangeListManager.getInstance((Project)project).getChangesIn(file);
        for (Change change : changes) {
            if (change.getType() == Change.Type.DELETED) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public Boolean isFileUnderVcs(@NotNull PsiFile psiFile) {
        ProjectLevelVcsManager vcsManager;
        if (psiFile == null) {
            VcsFacadeImpl.$$$reportNull$$$0(5);
        }
        Boolean bl = (vcsManager = ProjectLevelVcsManager.getInstance((Project)psiFile.getProject())).getVcsFor(psiFile.getVirtualFile()) != null;
        if (bl == null) {
            VcsFacadeImpl.$$$reportNull$$$0(6);
        }
        return bl;
    }

    @NotNull
    public Set<String> getVcsIgnoreFileNames(@NotNull Project project) {
        if (project == null) {
            VcsFacadeImpl.$$$reportNull$$$0(7);
        }
        Set set = VcsUtil.getVcsIgnoreFileNames((Project)project);
        if (set == null) {
            VcsFacadeImpl.$$$reportNull$$$0(8);
        }
        return set;
    }

    @Nullable
    public ChangedRangesInfo getChangedRangesInfo(@NotNull PsiFile file) {
        CharSequence testContent;
        List trackerRanges;
        Project project;
        Document document;
        if (file == null) {
            VcsFacadeImpl.$$$reportNull$$$0(9);
        }
        if ((document = PsiDocumentManager.getInstance((Project)(project = file.getProject())).getDocument(file)) == null) {
            return null;
        }
        LineStatusTracker tracker = LineStatusTrackerManager.getInstance((Project)project).getLineStatusTracker(document);
        List list = trackerRanges = tracker != null ? tracker.getRanges() : null;
        if (trackerRanges != null) {
            return VcsFacadeImpl.getChangedRangesInfo(document, trackerRanges);
        }
        if (ApplicationManager.getApplication().isUnitTestMode() && (testContent = (CharSequence)file.getUserData(TEST_REVISION_CONTENT)) != null) {
            return VcsFacadeImpl.getChangedRangesInfo(document, VcsFacadeImpl.computeRanges(document, testContent));
        }
        Change change = ChangeListManager.getInstance((Project)project).getChange(file.getVirtualFile());
        if (change == null) {
            return null;
        }
        if (change.getType() == Change.Type.NEW) {
            TextRange fileRange = file.getTextRange();
            return new ChangedRangesInfo(List.of(fileRange), null);
        }
        String contentFromVcs = VcsFacadeImpl.getRevisionedContentFrom(change.getBeforeRevision());
        if (contentFromVcs == null) {
            return null;
        }
        return VcsFacadeImpl.getChangedRangesInfo(document, VcsFacadeImpl.computeRanges(document, contentFromVcs));
    }

    @NotNull
    public List<Integer> getLinesWithRemovedRangesAfter(@NotNull PsiFile file) {
        Project project;
        Document document;
        if (file == null) {
            VcsFacadeImpl.$$$reportNull$$$0(10);
        }
        if ((document = PsiDocumentManager.getInstance((Project)(project = file.getProject())).getDocument(file)) == null) {
            List<Integer> list = Collections.emptyList();
            if (list == null) {
                VcsFacadeImpl.$$$reportNull$$$0(11);
            }
            return list;
        }
        LineStatusTracker tracker = LineStatusTrackerManager.getInstance((Project)project).getLineStatusTracker(document);
        if (tracker == null) {
            List<Integer> list = Collections.emptyList();
            if (list == null) {
                VcsFacadeImpl.$$$reportNull$$$0(12);
            }
            return list;
        }
        List trackerRanges = tracker.getRanges();
        if (trackerRanges == null) {
            List<Integer> list = Collections.emptyList();
            if (list == null) {
                VcsFacadeImpl.$$$reportNull$$$0(13);
            }
            return list;
        }
        List<Integer> list = trackerRanges.stream().filter(range -> range.getType() == 3).map(range -> range.getLine1()).toList();
        if (list == null) {
            VcsFacadeImpl.$$$reportNull$$$0(14);
        }
        return list;
    }

    @NotNull
    public List<PsiFile> getChangedFilesFromDirs(@NotNull Project project, @NotNull List<? extends PsiDirectory> psiDirs) {
        if (project == null) {
            VcsFacadeImpl.$$$reportNull$$$0(15);
        }
        if (psiDirs == null) {
            VcsFacadeImpl.$$$reportNull$$$0(16);
        }
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project);
        Collection allChanges = changeListManager.getAllChanges();
        List dirs = ContainerUtil.map(psiDirs, dir -> dir.getVirtualFile());
        List changes = VcsImplUtil.filterChangesUnderFiles((Iterable)allChanges, (Collection)dirs).toList();
        return VcsFacadeImpl.getChangedFiles(project, changes);
    }

    @NotNull
    private static List<PsiFile> getChangedFiles(@NotNull Project project, @NotNull Collection<? extends Change> changes) {
        if (project == null) {
            VcsFacadeImpl.$$$reportNull$$$0(17);
        }
        if (changes == null) {
            VcsFacadeImpl.$$$reportNull$$$0(18);
        }
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        List list = ContainerUtil.mapNotNull(changes, change -> {
            VirtualFile vFile = change.getVirtualFile();
            return vFile != null ? psiManager.findFile(vFile) : null;
        });
        if (list == null) {
            VcsFacadeImpl.$$$reportNull$$$0(19);
        }
        return list;
    }

    @NotNull
    public <T extends PsiElement> @Unmodifiable List<T> getLocalChangedElements(@NotNull Project project, @NotNull Change change, @NotNull Function<? super VirtualFile, ? extends List<T>> elementExtractor) {
        List elements;
        if (project == null) {
            VcsFacadeImpl.$$$reportNull$$$0(20);
        }
        if (change == null) {
            VcsFacadeImpl.$$$reportNull$$$0(21);
        }
        if (elementExtractor == null) {
            VcsFacadeImpl.$$$reportNull$$$0(22);
        }
        if (change.getType() == Change.Type.DELETED) {
            List list = Collections.emptyList();
            if (list == null) {
                VcsFacadeImpl.$$$reportNull$$$0(23);
            }
            return list;
        }
        if (!(change.getAfterRevision() instanceof CurrentContentRevision)) {
            List list = Collections.emptyList();
            if (list == null) {
                VcsFacadeImpl.$$$reportNull$$$0(24);
            }
            return list;
        }
        VirtualFile file = ((CurrentContentRevision)change.getAfterRevision()).getVirtualFile();
        if (file == null) {
            List list = Collections.emptyList();
            if (list == null) {
                VcsFacadeImpl.$$$reportNull$$$0(25);
            }
            return list;
        }
        Document document = FileDocumentManager.getInstance().getDocument(file);
        if (document == null) {
            List list = Collections.emptyList();
            if (list == null) {
                VcsFacadeImpl.$$$reportNull$$$0(26);
            }
            return list;
        }
        List apply = (List)elementExtractor.fun((Object)file);
        List list = elements = apply == null ? null : ContainerUtil.skipNulls((Collection)apply);
        if (ContainerUtil.isEmpty((Collection)elements)) {
            List list2 = Collections.emptyList();
            if (list2 == null) {
                VcsFacadeImpl.$$$reportNull$$$0(27);
            }
            return list2;
        }
        if (change.getType() == Change.Type.NEW) {
            List list3 = elements;
            if (list3 == null) {
                VcsFacadeImpl.$$$reportNull$$$0(28);
            }
            return list3;
        }
        List<? extends Range> ranges = VcsFacadeImpl.getChangedRangesFromLineStatusTracker(project, document, change);
        if (ranges == null) {
            ranges = VcsFacadeImpl.getChangedRangesFromBeforeRevision(document, change);
        }
        if (ranges == null) {
            List list4 = elements;
            if (list4 == null) {
                VcsFacadeImpl.$$$reportNull$$$0(29);
            }
            return list4;
        }
        BitSet changedLines = VcsFacadeImpl.createChangedLinesBitSet(ranges);
        List list5 = ContainerUtil.filter((Collection)elements, element -> VcsFacadeImpl.isElementChanged(element, document, changedLines));
        if (list5 == null) {
            VcsFacadeImpl.$$$reportNull$$$0(30);
        }
        return list5;
    }

    @NotNull
    public <T extends PsiElement> @Unmodifiable List<T> getPostCommitChangedElements(@NotNull Project project, @NotNull Change change, @NotNull Function<? super VirtualFile, ? extends List<T>> elementExtractor) {
        List elements;
        if (project == null) {
            VcsFacadeImpl.$$$reportNull$$$0(31);
        }
        if (change == null) {
            VcsFacadeImpl.$$$reportNull$$$0(32);
        }
        if (elementExtractor == null) {
            VcsFacadeImpl.$$$reportNull$$$0(33);
        }
        if (change.getType() == Change.Type.DELETED) {
            List list = Collections.emptyList();
            if (list == null) {
                VcsFacadeImpl.$$$reportNull$$$0(34);
            }
            return list;
        }
        VirtualFile file = ChangesUtil.getFilePath((Change)change).getVirtualFile();
        if (file == null) {
            List list = Collections.emptyList();
            if (list == null) {
                VcsFacadeImpl.$$$reportNull$$$0(35);
            }
            return list;
        }
        Document document = FileDocumentManager.getInstance().getDocument(file);
        if (document == null) {
            List list = Collections.emptyList();
            if (list == null) {
                VcsFacadeImpl.$$$reportNull$$$0(36);
            }
            return list;
        }
        List apply = (List)elementExtractor.fun((Object)file);
        List list = elements = apply == null ? null : ContainerUtil.skipNulls((Collection)apply);
        if (ContainerUtil.isEmpty((Collection)elements)) {
            List list2 = Collections.emptyList();
            if (list2 == null) {
                VcsFacadeImpl.$$$reportNull$$$0(37);
            }
            return list2;
        }
        if (change.getType() == Change.Type.NEW) {
            List list3 = elements;
            if (list3 == null) {
                VcsFacadeImpl.$$$reportNull$$$0(38);
            }
            return list3;
        }
        List<Range> ranges = VcsFacadeImpl.getChangedRangesForPostCommit(document, change);
        if (ranges == null) {
            List list4 = elements;
            if (list4 == null) {
                VcsFacadeImpl.$$$reportNull$$$0(39);
            }
            return list4;
        }
        BitSet changedLines = VcsFacadeImpl.createChangedLinesBitSet(ranges);
        List list5 = ContainerUtil.filter((Collection)elements, element -> VcsFacadeImpl.isElementChanged(element, document, changedLines));
        if (list5 == null) {
            VcsFacadeImpl.$$$reportNull$$$0(40);
        }
        return list5;
    }

    @NotNull
    public <T extends PsiElement> @Unmodifiable List<T> getCommitChangedElements(@NotNull Change change, @NotNull PsiCollector<T> elementExtractor) {
        List elementsAfter;
        if (change == null) {
            VcsFacadeImpl.$$$reportNull$$$0(41);
        }
        if (elementExtractor == null) {
            VcsFacadeImpl.$$$reportNull$$$0(42);
        }
        ContentRevision beforeRevision = change.getBeforeRevision();
        ContentRevision afterRevision = change.getAfterRevision();
        String contentBefore = VcsFacadeImpl.getRevisionedContentFrom(beforeRevision);
        String contentAfter = VcsFacadeImpl.getRevisionedContentFrom(afterRevision);
        List elementsBefore = contentBefore != null ? elementExtractor.collectTargetPsi(contentBefore, beforeRevision.getFile().getFileType()) : Collections.emptyList();
        List list = elementsAfter = contentAfter != null ? elementExtractor.collectTargetPsi(contentAfter, afterRevision.getFile().getFileType()) : Collections.emptyList();
        if (elementsBefore.isEmpty() && elementsAfter.isEmpty()) {
            List list2 = Collections.emptyList();
            if (list2 == null) {
                VcsFacadeImpl.$$$reportNull$$$0(43);
            }
            return list2;
        }
        if (change.getType() == Change.Type.NEW) {
            List list3 = elementsAfter;
            if (list3 == null) {
                VcsFacadeImpl.$$$reportNull$$$0(44);
            }
            return list3;
        }
        if (change.getType() == Change.Type.DELETED) {
            List list4 = elementsBefore;
            if (list4 == null) {
                VcsFacadeImpl.$$$reportNull$$$0(45);
            }
            return list4;
        }
        assert (contentBefore != null && contentAfter != null);
        List<Range> ranges = VcsFacadeImpl.getChangedRangesForCommit(contentBefore, contentAfter);
        BitSet changedLinesBefore = VcsFacadeImpl.createLinesBitSetBefore(ranges);
        BitSet changedLinesAfter = VcsFacadeImpl.createLinesBitSetAfter(ranges);
        List changedPsiBefore = VcsFacadeImpl.filterChanged(elementsBefore, changedLinesBefore);
        List changedPsiAfter = VcsFacadeImpl.filterChanged(elementsAfter, changedLinesAfter);
        List list5 = ContainerUtil.concat(changedPsiBefore, changedPsiAfter);
        if (list5 == null) {
            VcsFacadeImpl.$$$reportNull$$$0(46);
        }
        return list5;
    }

    @NotNull
    private static <T extends PsiElement> List<T> filterChanged(@NotNull List<T> elements, @NotNull BitSet changedLines) {
        if (elements == null) {
            VcsFacadeImpl.$$$reportNull$$$0(47);
        }
        if (changedLines == null) {
            VcsFacadeImpl.$$$reportNull$$$0(48);
        }
        if (elements.isEmpty()) {
            List<T> list = elements;
            if (list == null) {
                VcsFacadeImpl.$$$reportNull$$$0(49);
            }
            return list;
        }
        Document document = ((PsiElement)elements.get(0)).getContainingFile().getFileDocument();
        List list = ContainerUtil.filter(elements, element -> VcsFacadeImpl.isElementChanged(element, document, changedLines));
        if (list == null) {
            VcsFacadeImpl.$$$reportNull$$$0(50);
        }
        return list;
    }

    @NotNull
    private static List<Range> getChangedRangesForCommit(@NotNull String contentBefore, @NotNull String contentAfter) {
        if (contentBefore == null) {
            VcsFacadeImpl.$$$reportNull$$$0(51);
        }
        if (contentAfter == null) {
            VcsFacadeImpl.$$$reportNull$$$0(52);
        }
        CharSequence beforeText = VcsFacadeImpl.fixLineSeparators(contentBefore);
        CharSequence afterText = VcsFacadeImpl.fixLineSeparators(contentAfter);
        LineOffsets beforeLineOffsets = LineOffsetsUtil.create((CharSequence)beforeText);
        LineOffsets afterLineOffsets = LineOffsetsUtil.create((CharSequence)afterText);
        FairDiffIterable committedLines = RangesBuilder.compareLines((CharSequence)beforeText, (CharSequence)afterText, (LineOffsets)beforeLineOffsets, (LineOffsets)afterLineOffsets);
        List list = ContainerUtil.map((Iterator)committedLines.changes(), it -> new Range(it.start2, it.end2, it.start1, it.end1, null));
        if (list == null) {
            VcsFacadeImpl.$$$reportNull$$$0(53);
        }
        return list;
    }

    @NotNull
    private static BitSet createLinesBitSetAfter(@NotNull List<? extends Range> ranges) {
        if (ranges == null) {
            VcsFacadeImpl.$$$reportNull$$$0(54);
        }
        BitSet changedLines = new BitSet();
        for (Range range : ranges) {
            if (!range.hasLines()) continue;
            changedLines.set(range.getLine1(), range.getLine2());
        }
        BitSet bitSet = changedLines;
        if (bitSet == null) {
            VcsFacadeImpl.$$$reportNull$$$0(55);
        }
        return bitSet;
    }

    @NotNull
    private static BitSet createLinesBitSetBefore(@NotNull List<? extends Range> ranges) {
        if (ranges == null) {
            VcsFacadeImpl.$$$reportNull$$$0(56);
        }
        BitSet changedLines = new BitSet();
        for (Range range : ranges) {
            if (!range.hasLines()) continue;
            changedLines.set(range.getVcsLine1(), range.getVcsLine2());
        }
        BitSet bitSet = changedLines;
        if (bitSet == null) {
            VcsFacadeImpl.$$$reportNull$$$0(57);
        }
        return bitSet;
    }

    @Nullable
    private static @Unmodifiable List<? extends Range> getChangedRangesFromLineStatusTracker(@NotNull Project project, @NotNull Document document, @NotNull Change change) {
        LineStatusTracker tracker;
        if (project == null) {
            VcsFacadeImpl.$$$reportNull$$$0(58);
        }
        if (document == null) {
            VcsFacadeImpl.$$$reportNull$$$0(59);
        }
        if (change == null) {
            VcsFacadeImpl.$$$reportNull$$$0(60);
        }
        if ((tracker = LineStatusTrackerManager.getInstance((Project)project).getLineStatusTracker(document)) == null) {
            return null;
        }
        if (change instanceof ChangeListChange && tracker instanceof PartialLocalLineStatusTracker) {
            String changeListId = ((ChangeListChange)change).getChangeListId();
            List ranges = ((PartialLocalLineStatusTracker)tracker).getRanges();
            if (ranges == null) {
                return null;
            }
            return ContainerUtil.filter((Collection)ranges, range -> range.getChangelistId().equals(changeListId));
        }
        return tracker.getRanges();
    }

    @Nullable
    private static List<Range> getChangedRangesFromBeforeRevision(@NotNull Document document, @NotNull Change change) {
        String contentFromVcs;
        if (document == null) {
            VcsFacadeImpl.$$$reportNull$$$0(61);
        }
        if (change == null) {
            VcsFacadeImpl.$$$reportNull$$$0(62);
        }
        if ((contentFromVcs = VcsFacadeImpl.getRevisionedContentFrom(change.getBeforeRevision())) == null) {
            return null;
        }
        return VcsFacadeImpl.computeRanges(document, contentFromVcs);
    }

    @Nullable
    private static List<Range> getChangedRangesForPostCommit(@NotNull Document document, @NotNull Change change) {
        String conventBefore;
        if (document == null) {
            VcsFacadeImpl.$$$reportNull$$$0(63);
        }
        if (change == null) {
            VcsFacadeImpl.$$$reportNull$$$0(64);
        }
        if ((conventBefore = VcsFacadeImpl.getRevisionedContentFrom(change.getBeforeRevision())) == null) {
            return null;
        }
        String contentAfter = VcsFacadeImpl.getRevisionedContentFrom(change.getAfterRevision());
        if (contentAfter == null) {
            return null;
        }
        CharSequence beforeText = VcsFacadeImpl.fixLineSeparators(conventBefore);
        CharSequence afterText = VcsFacadeImpl.fixLineSeparators(contentAfter);
        CharSequence localText = document.getImmutableCharSequence();
        LineOffsets beforeLineOffsets = LineOffsetsUtil.create((CharSequence)beforeText);
        LineOffsets afterLineOffsets = LineOffsetsUtil.create((CharSequence)afterText);
        LineOffsets localLineOffsets = LineOffsetsUtil.create((Document)document);
        FairDiffIterable committedLines = RangesBuilder.compareLines((CharSequence)beforeText, (CharSequence)afterText, (LineOffsets)beforeLineOffsets, (LineOffsets)afterLineOffsets);
        FairDiffIterable localLines = RangesBuilder.compareLines((CharSequence)afterText, (CharSequence)localText, (LineOffsets)afterLineOffsets, (LineOffsets)localLineOffsets);
        ChangedRangesShifter builder = new ChangedRangesShifter();
        List ranges = builder.execute(committedLines, localLines);
        return ContainerUtil.map((Collection)ranges, it -> new Range(it.start2, it.end2, it.start1, it.end1, null));
    }

    @NotNull
    private static BitSet createChangedLinesBitSet(@NotNull List<? extends Range> ranges) {
        if (ranges == null) {
            VcsFacadeImpl.$$$reportNull$$$0(65);
        }
        BitSet changedLines = new BitSet();
        for (Range range : ranges) {
            if (range.hasLines()) {
                changedLines.set(range.getLine1(), range.getLine2());
                continue;
            }
            changedLines.set(Math.max(0, range.getLine1() - 1), range.getLine1() + 1);
        }
        BitSet bitSet = changedLines;
        if (bitSet == null) {
            VcsFacadeImpl.$$$reportNull$$$0(66);
        }
        return bitSet;
    }

    private static boolean isElementChanged(@NotNull PsiElement element, @NotNull Document document, @NotNull BitSet changedLines) {
        if (element == null) {
            VcsFacadeImpl.$$$reportNull$$$0(67);
        }
        if (document == null) {
            VcsFacadeImpl.$$$reportNull$$$0(68);
        }
        if (changedLines == null) {
            VcsFacadeImpl.$$$reportNull$$$0(69);
        }
        TextRange textRange = element.getTextRange();
        int startLine = document.getLineNumber(textRange.getStartOffset());
        int endLine = textRange.isEmpty() ? startLine + 1 : document.getLineNumber(textRange.getEndOffset() - 1) + 1;
        int nextSetBit = changedLines.nextSetBit(startLine);
        return nextSetBit != -1 && nextSetBit < endLine;
    }

    @Nullable
    private static String getRevisionedContentFrom(@Nullable ContentRevision contentRevision) {
        if (contentRevision == null) {
            return null;
        }
        try {
            return contentRevision.getContent();
        }
        catch (VcsException e) {
            LOG.warn("Can't get content for: " + String.valueOf(contentRevision), (Throwable)e);
            return null;
        }
    }

    @NotNull
    private static List<Range> computeRanges(@NotNull Document document, @NotNull CharSequence contentFromVcs) {
        if (document == null) {
            VcsFacadeImpl.$$$reportNull$$$0(70);
        }
        if (contentFromVcs == null) {
            VcsFacadeImpl.$$$reportNull$$$0(71);
        }
        List list = RangesBuilder.createRanges((CharSequence)document.getImmutableCharSequence(), (CharSequence)VcsFacadeImpl.fixLineSeparators(contentFromVcs));
        if (list == null) {
            VcsFacadeImpl.$$$reportNull$$$0(72);
        }
        return list;
    }

    @NotNull
    private static CharSequence fixLineSeparators(@NotNull CharSequence contentFromVcs) {
        if (contentFromVcs == null) {
            VcsFacadeImpl.$$$reportNull$$$0(73);
        }
        CharSequence charSequence = StringUtilRt.convertLineSeparators((CharSequence)contentFromVcs, (String)"\n");
        if (charSequence == null) {
            VcsFacadeImpl.$$$reportNull$$$0(74);
        }
        return charSequence;
    }

    public int calculateChangedLinesNumber(@NotNull Document document, @NotNull CharSequence contentFromVcs) {
        if (document == null) {
            VcsFacadeImpl.$$$reportNull$$$0(75);
        }
        if (contentFromVcs == null) {
            VcsFacadeImpl.$$$reportNull$$$0(76);
        }
        List<Range> changedRanges = VcsFacadeImpl.computeRanges(document, contentFromVcs);
        int linesChanges = 0;
        for (Range range : changedRanges) {
            int inserted = range.getLine2() - range.getLine1();
            int deleted = range.getVcsLine2() - range.getVcsLine1();
            linesChanges += Math.max(inserted, deleted);
        }
        return linesChanges;
    }

    @NotNull
    private static ChangedRangesInfo getChangedRangesInfo(@NotNull Document document, @NotNull List<? extends Range> changedRanges) {
        if (document == null) {
            VcsFacadeImpl.$$$reportNull$$$0(77);
        }
        if (changedRanges == null) {
            VcsFacadeImpl.$$$reportNull$$$0(78);
        }
        ArrayList<TextRange> ranges = new ArrayList<TextRange>();
        ArrayList<TextRange> insertedRanges = new ArrayList<TextRange>();
        for (Range range : changedRanges) {
            if (!range.hasLines()) continue;
            int changeStartLine = range.getLine1();
            int changeEndLine = range.getLine2();
            int lineStartOffset = document.getLineStartOffset(changeStartLine);
            int lineEndOffset = document.getLineEndOffset(changeEndLine - 1);
            TextRange changedTextRange = new TextRange(lineStartOffset, lineEndOffset);
            ranges.add(changedTextRange);
            if (range.hasVcsLines()) continue;
            insertedRanges.add(changedTextRange);
        }
        return new ChangedRangesInfo(ranges, insertedRanges);
    }

    public boolean isChangeNotTrackedForFile(@NotNull Project project, @NotNull PsiFile file) {
        if (project == null) {
            VcsFacadeImpl.$$$reportNull$$$0(79);
        }
        if (file == null) {
            VcsFacadeImpl.$$$reportNull$$$0(80);
        }
        if (this.isFileUnderVcs(file).booleanValue()) {
            FileStatus status = ChangeListManager.getInstance((Project)project).getStatus(file.getVirtualFile());
            return status == FileStatus.UNKNOWN || status == FileStatus.IGNORED;
        }
        return true;
    }

    public void runHeavyModificationTask(@NotNull Project project, @NotNull Document document, @NotNull Runnable o) {
        LineStatusTracker tracker;
        if (project == null) {
            VcsFacadeImpl.$$$reportNull$$$0(81);
        }
        if (document == null) {
            VcsFacadeImpl.$$$reportNull$$$0(82);
        }
        if (o == null) {
            VcsFacadeImpl.$$$reportNull$$$0(83);
        }
        if ((tracker = LineStatusTrackerManager.getInstance((Project)project).getLineStatusTracker(document)) != null) {
            tracker.doFrozen(o);
        } else {
            o.run();
        }
    }

    public void markFilesDirty(@NotNull Project project, @NotNull List<? extends VirtualFile> virtualFiles) {
        if (project == null) {
            VcsFacadeImpl.$$$reportNull$$$0(84);
        }
        if (virtualFiles == null) {
            VcsFacadeImpl.$$$reportNull$$$0(85);
        }
        VcsFileUtil.markFilesDirty((Project)project, virtualFiles);
    }

    public JComponent createPatchPreviewComponent(@NotNull Project project, @NotNull Map<VirtualFile, CharSequence> patch) {
        if (project == null) {
            VcsFacadeImpl.$$$reportNull$$$0(86);
        }
        if (patch == null) {
            VcsFacadeImpl.$$$reportNull$$$0(87);
        }
        List changes = EntryStream.of(patch).mapKeyValue((file, content) -> {
            FilePath filePath = VcsUtil.getFilePath((VirtualFile)file);
            CurrentContentRevision current = new CurrentContentRevision(filePath);
            SimpleContentRevision changed = new SimpleContentRevision(content.toString(), filePath, VcsBundle.message((String)"patched.version.name", (Object[])new Object[0]));
            return new Change((ContentRevision)current, (ContentRevision)changed);
        }).toList();
        SimpleAsyncChangesBrowser browser = new SimpleAsyncChangesBrowser(project, false, false);
        browser.setChangesToDisplay((Collection)changes);
        return browser;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 7, 9, 10, 15, 16, 17, 18, 20, 21, 22, 31, 32, 33, 41, 42, 47, 48, 51, 52, 54, 56, 58, 59, 60, 61, 62, 63, 64, 65, 67, 68, 69, 70, 71, 73, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/actions/VcsFacadeImpl";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 15: 
            case 17: 
            case 20: 
            case 31: 
            case 58: 
            case 79: 
            case 81: 
            case 84: 
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: 
            case 9: 
            case 10: 
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiDirs";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 21: 
            case 32: 
            case 41: 
            case 60: 
            case 62: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change";
                break;
            }
            case 22: 
            case 33: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementExtractor";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 48: 
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changedLines";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentBefore";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentAfter";
                break;
            }
            case 54: 
            case 56: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ranges";
                break;
            }
            case 59: 
            case 61: 
            case 63: 
            case 68: 
            case 70: 
            case 75: 
            case 77: 
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 71: 
            case 73: 
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentFromVcs";
                break;
            }
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changedRanges";
                break;
            }
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFiles";
                break;
            }
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patch";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getVcsInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 31: 
            case 32: 
            case 33: 
            case 41: 
            case 42: 
            case 47: 
            case 48: 
            case 51: 
            case 52: 
            case 54: 
            case 56: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 73: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/actions/VcsFacadeImpl";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "isFileUnderVcs";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getVcsIgnoreFileNames";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getLinesWithRemovedRangesAfter";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getChangedFiles";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalChangedElements";
                break;
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getPostCommitChangedElements";
                break;
            }
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommitChangedElements";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "filterChanged";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "getChangedRangesForCommit";
                break;
            }
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "createLinesBitSetAfter";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "createLinesBitSetBefore";
                break;
            }
            case 66: {
                objectArray = objectArray2;
                objectArray2[1] = "createChangedLinesBitSet";
                break;
            }
            case 72: {
                objectArray = objectArray2;
                objectArray2[1] = "computeRanges";
                break;
            }
            case 74: {
                objectArray = objectArray2;
                objectArray2[1] = "fixLineSeparators";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "hasActiveVcss";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "hasChanges";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isFileUnderVcs";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getVcsIgnoreFileNames";
                break;
            }
            case 9: 
            case 77: 
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "getChangedRangesInfo";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getLinesWithRemovedRangesAfter";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getChangedFilesFromDirs";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getChangedFiles";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getLocalChangedElements";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getPostCommitChangedElements";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getCommitChangedElements";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "filterChanged";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "getChangedRangesForCommit";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "createLinesBitSetAfter";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "createLinesBitSetBefore";
                break;
            }
            case 58: 
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "getChangedRangesFromLineStatusTracker";
                break;
            }
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "getChangedRangesFromBeforeRevision";
                break;
            }
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "getChangedRangesForPostCommit";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "createChangedLinesBitSet";
                break;
            }
            case 67: 
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "isElementChanged";
                break;
            }
            case 70: 
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "computeRanges";
                break;
            }
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "fixLineSeparators";
                break;
            }
            case 75: 
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "calculateChangedLinesNumber";
                break;
            }
            case 79: 
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "isChangeNotTrackedForFile";
                break;
            }
            case 81: 
            case 82: 
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "runHeavyModificationTask";
                break;
            }
            case 84: 
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "markFilesDirty";
                break;
            }
            case 86: 
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "createPatchPreviewComponent";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 7, 9, 10, 15, 16, 17, 18, 20, 21, 22, 31, 32, 33, 41, 42, 47, 48, 51, 52, 54, 56, 58, 59, 60, 61, 62, 63, 64, 65, 67, 68, 69, 70, 71, 73, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87 -> new IllegalArgumentException(string);
        };
    }
}

