/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.util.threading;

import com.jetbrains.rd.util.PlatformDependentKt;
import com.jetbrains.rd.util.reactive.ExecutionOrder;
import com.jetbrains.rd.util.reactive.IScheduler;
import com.jetbrains.rd.util.threading.SynchronousScheduler;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0016\u0010\u0010\u001a\u00020\u000f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0012H\u0016R\u001e\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\r\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/rd/util/threading/SynchronousScheduler;", "Lcom/jetbrains/rd/util/reactive/IScheduler;", "()V", "active", "Ljava/lang/ThreadLocal;", "", "Lcom/jetbrains/rd/util/ThreadLocal;", "executionOrder", "Lcom/jetbrains/rd/util/reactive/ExecutionOrder;", "getExecutionOrder", "()Lcom/jetbrains/rd/util/reactive/ExecutionOrder;", "isActive", "", "()Z", "flush", "", "queue", "action", "Lkotlin/Function0;", "rd-core"})
public final class SynchronousScheduler
implements IScheduler {
    @NotNull
    public static final SynchronousScheduler INSTANCE = new SynchronousScheduler();
    @NotNull
    private static final ThreadLocal<Integer> active = PlatformDependentKt.threadLocalWithInitial(active.1.INSTANCE);

    private SynchronousScheduler() {
    }

    @Override
    public void flush() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void queue(@NotNull Function0<Unit> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        active.set(((Number)active.get()).intValue() + 1);
        try {
            action.invoke();
        }
        finally {
            active.set(((Number)active.get()).intValue() - 1);
        }
    }

    @Override
    public boolean isActive() {
        Integer n = active.get();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"active.get()");
        return ((Number)n).intValue() > 0;
    }

    @Override
    @NotNull
    public ExecutionOrder getExecutionOrder() {
        return ExecutionOrder.OutOfOrder;
    }

    @Override
    public void assertThread(@Nullable Object debugInfo) {
        IScheduler.DefaultImpls.assertThread(this, debugInfo);
    }

    @Override
    public void invokeOrQueue(@NotNull Function0<Unit> action) {
        IScheduler.DefaultImpls.invokeOrQueue(this, action);
    }
}

