/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.text;

import java.awt.Component;
import java.awt.Container;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Logger;
import org.assertj.core.util.Preconditions;
import org.assertj.core.util.Strings;
import org.assertj.core.util.VisibleForTesting;
import org.assertj.swing.annotation.RunsInEDT;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.dependency.jsr305.Nullable;
import org.assertj.swing.edt.GuiActionRunner;
import org.assertj.swing.text.AbstractButtonTextReader;
import org.assertj.swing.text.JLabelTextReader;
import org.assertj.swing.text.JListTextReader;
import org.assertj.swing.text.JTextComponentTextReader;
import org.assertj.swing.text.TextReader;
import org.assertj.swing.util.Maps;

public class TextReaders {
    private static Logger logger = Logger.getLogger(TextReaders.class.getCanonicalName());
    @VisibleForTesting
    final ConcurrentMap<Class<?>, TextReader<?>> readers = Maps.newConcurrentHashMap();

    @VisibleForTesting
    TextReaders() {
        this.register(new AbstractButtonTextReader());
        this.register(new JLabelTextReader());
        this.register(new JListTextReader());
        this.register(new JTextComponentTextReader());
    }

    public void register(@Nonnull TextReader<?> reader) {
        Preconditions.checkNotNull(reader);
        Class type = (Class)Preconditions.checkNotNull(reader.supportedComponent());
        TextReader<?> old = this.readers.put(type, reader);
        if (old != null) {
            logger.info(Strings.concat((Object[])new Object[]{"Replaced reader for type ", type.getName()}));
        }
    }

    @RunsInEDT
    public boolean containsText(@Nonnull Container container, @Nonnull String text) {
        Preconditions.checkNotNull((Object)container);
        Preconditions.checkNotNull((Object)text);
        Boolean result = GuiActionRunner.execute(() -> {
            if (this.componentContainsText(container, text)) {
                return true;
            }
            return this.anyComponentContainsText(container.getComponents(), text);
        });
        return (Boolean)Preconditions.checkNotNull((Object)result);
    }

    private boolean anyComponentContainsText(@Nonnull Component[] components, @Nonnull String text) {
        for (Component c : components) {
            if (c == null) continue;
            if (this.componentContainsText(c, text)) {
                return true;
            }
            if (!(c instanceof Container)) continue;
            Component[] children = ((Container)c).getComponents();
            return this.anyComponentContainsText(children, text);
        }
        return false;
    }

    private boolean componentContainsText(@Nonnull Component c, @Nonnull String text) {
        TextReader<?> reader = this.readerFor(c);
        if (reader == null) {
            return false;
        }
        return reader.containsText(c, text);
    }

    @Nullable
    private TextReader<?> readerFor(@Nonnull Component c) {
        for (Class<?> type = c.getClass(); type != null; type = type.getSuperclass()) {
            TextReader reader = (TextReader)this.readers.get(type);
            if (reader != null) {
                return reader;
            }
            if (type.equals(Component.class)) break;
        }
        return null;
    }

    @Nonnull
    public static TextReaders instance() {
        return SingletonHolder.INSTANCE;
    }

    private static class SingletonHolder {
        static final TextReaders INSTANCE = new TextReaders();

        private SingletonHolder() {
        }
    }
}

