/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.eclipse.util;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;

public final class PathUtil {
    @NotNull
    public static String normalize(@NotNull String path) {
        int slashIndex;
        int index;
        if (path == null) {
            PathUtil.$$$reportNull$$$0(0);
        }
        path = FileUtil.toSystemIndependentName((String)path);
        path = StringUtil.trimEnd((String)path, (String)"/");
        while (((String)path).contains("/./")) {
            path = ((String)path).replace("/./", "/");
        }
        path = StringUtil.trimStart((String)path, (String)"./");
        path = StringUtil.trimEnd((String)path, (String)"/.");
        while ((index = ((String)path).indexOf("/..")) >= 0 && (slashIndex = ((String)path).substring(0, index).lastIndexOf(47)) >= 0) {
            path = ((String)path).substring(0, slashIndex) + ((String)path).substring(index + 3);
        }
        String string = path;
        if (string == null) {
            PathUtil.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public static String getRelative(@NotNull String baseRoot, @NotNull String path) {
        int prefix;
        if (baseRoot == null) {
            PathUtil.$$$reportNull$$$0(2);
        }
        if (path == null) {
            PathUtil.$$$reportNull$$$0(3);
        }
        if ((prefix = PathUtil.findCommonPathPrefixLength(baseRoot = PathUtil.normalize(baseRoot), path = PathUtil.normalize(path))) != 0) {
            baseRoot = baseRoot.substring(prefix);
            path = path.substring(prefix);
            if (!baseRoot.isEmpty()) {
                return PathUtil.normalize(PathUtil.revertRelativePath(baseRoot.substring(1)) + path);
            }
            if (!path.isEmpty()) {
                String string = path.substring(1);
                if (string == null) {
                    PathUtil.$$$reportNull$$$0(4);
                }
                return string;
            }
            return ".";
        }
        if (FileUtil.isAbsolute((String)path)) {
            String string = path;
            if (string == null) {
                PathUtil.$$$reportNull$$$0(5);
            }
            return string;
        }
        return PathUtil.normalize(PathUtil.revertRelativePath(baseRoot) + "/" + path);
    }

    private static int findCommonPathPrefixLength(@NotNull String path1, @NotNull String path2) {
        int beg;
        int new_end;
        if (path1 == null) {
            PathUtil.$$$reportNull$$$0(6);
        }
        if (path2 == null) {
            PathUtil.$$$reportNull$$$0(7);
        }
        int end = -1;
        while ((new_end = PathUtil.endOfToken(path1, beg = end + 1)) == PathUtil.endOfToken(path2, beg) && path1.substring(beg, new_end).equals(path2.substring(beg, new_end)) && (end = new_end) != path1.length()) {
        }
        return Math.max(end, 0);
    }

    private static int endOfToken(String s, int index) {
        return (index = s.indexOf(47, index)) == -1 ? s.length() : index;
    }

    @NotNull
    private static String revertRelativePath(@NotNull String path) {
        if (path == null) {
            PathUtil.$$$reportNull$$$0(8);
        }
        if (path.equals(".")) {
            String string = path;
            if (string == null) {
                PathUtil.$$$reportNull$$$0(9);
            }
            return string;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("..");
        int count = PathUtil.normalize(path).split("/").length;
        while (--count > 0) {
            sb.append("/..");
        }
        String string = sb.toString();
        if (string == null) {
            PathUtil.$$$reportNull$$$0(10);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 4, 5, 9, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/eclipse/util/PathUtil";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseRoot";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path1";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path2";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/eclipse/util/PathUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "normalize";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getRelative";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "revertRelativePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "normalize";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 9: 
            case 10: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getRelative";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findCommonPathPrefixLength";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "revertRelativePath";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 4, 5, 9, 10 -> new IllegalStateException(string);
        };
    }
}

