/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.eclipse.config;

import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CachedXmlDocumentSet {
    private final Map<String, String> nameToDir = new HashMap<String, String>();

    @Nullable
    public Element load(@NotNull String name, boolean refresh) throws IOException, JDOMException {
        if (name == null) {
            CachedXmlDocumentSet.$$$reportNull$$$0(0);
        }
        assert (this.nameToDir.containsKey(name)) : name;
        VirtualFile file = this.getFile(name, refresh);
        if (file == null) {
            return null;
        }
        try (InputStream inputStream = file.getInputStream();){
            Element element = JDOMUtil.load((InputStream)inputStream);
            return element;
        }
    }

    public String getParent(@NotNull String name) {
        if (name == null) {
            CachedXmlDocumentSet.$$$reportNull$$$0(1);
        }
        return this.nameToDir.get(name);
    }

    public void register(@NotNull String name, @NotNull String path) {
        if (name == null) {
            CachedXmlDocumentSet.$$$reportNull$$$0(2);
        }
        if (path == null) {
            CachedXmlDocumentSet.$$$reportNull$$$0(3);
        }
        this.nameToDir.put(name, path);
    }

    public void unregister(@NotNull String name) {
        if (name == null) {
            CachedXmlDocumentSet.$$$reportNull$$$0(4);
        }
        this.nameToDir.remove(name);
    }

    public boolean exists(@NotNull String name) {
        if (name == null) {
            CachedXmlDocumentSet.$$$reportNull$$$0(5);
        }
        return this.getFile(name, false) != null;
    }

    @Nullable
    VirtualFile getFile(@NotNull String name, boolean refresh) {
        VirtualFile file;
        if (name == null) {
            CachedXmlDocumentSet.$$$reportNull$$$0(6);
        }
        if ((file = LocalFileSystem.getInstance().findFileByIoFile(new File(this.getParent(name), name))) != null && refresh) {
            file.refresh(false, true);
            if (!file.isValid()) {
                return null;
            }
        }
        return file;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/eclipse/config/CachedXmlDocumentSet";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "load";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getParent";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "register";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "unregister";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "exists";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

