/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.runtime.retain;

import androidx.collection.MutableObjectList;
import androidx.collection.MutableScatterMap;
import androidx.collection.ObjectList;
import androidx.collection.ScatterMap;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.runtime.retain.ControlledRetainedValuesStore;
import androidx.compose.runtime.retain.RetainObserver;
import androidx.compose.runtime.retain.RetainStateProvider;
import androidx.compose.runtime.retain.RetainedValuesStore;
import androidx.compose.runtime.retain.impl.PreconditionsKt;
import androidx.compose.runtime.retain.impl.SafeMultiValueMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u000b*\u0001\u000b\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\tJ\u0006\u0010\u0014\u001a\u00020\u0012J\u0006\u0010\u0015\u001a\u00020\u0012J\b\u0010\u0016\u001a\u00020\u0012H\u0014J\b\u0010\u0017\u001a\u00020\u0012H\u0014J\u001c\u0010\u0018\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0019\u001a\u00020\u00062\b\u0010\u001a\u001a\u0004\u0018\u00010\u0006H\u0016J\u001a\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u00062\b\u0010\u001c\u001a\u0004\u0018\u00010\u0006H\u0014R\u001e\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001d"}, d2={"Landroidx/compose/runtime/retain/ControlledRetainedValuesStore;", "Landroidx/compose/runtime/retain/RetainedValuesStore;", "<init>", "()V", "keptExitedValues", "Landroidx/compose/runtime/retain/impl/SafeMultiValueMap;", "", "Landroidx/collection/MutableScatterMap;", "parentStore", "Landroidx/compose/runtime/retain/RetainStateProvider;", "parentObserver", "androidx/compose/runtime/retain/ControlledRetainedValuesStore$parentObserver$1", "Landroidx/compose/runtime/retain/ControlledRetainedValuesStore$parentObserver$1;", "retainExitedValuesRequestsFromSelf", "", "getRetainExitedValuesRequestsFromSelf", "()I", "setParentRetainStateProvider", "", "parent", "startRetainingExitedValues", "stopRetainingExitedValues", "onStartRetainingExitedValues", "onStopRetainingExitedValues", "getExitedValueOrElse", "key", "defaultValue", "saveExitingValue", "value", "runtime-retain"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nControlledRetainedValuesStore.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ControlledRetainedValuesStore.kt\nandroidx/compose/runtime/retain/ControlledRetainedValuesStore\n+ 2 Preconditions.kt\nandroidx/compose/runtime/retain/impl/PreconditionsKt\n+ 3 SafeMultiValueMap.kt\nandroidx/compose/runtime/retain/impl/SafeMultiValueMap\n+ 4 ScatterMap.kt\nandroidx/collection/ScatterMap\n+ 5 ScatterMap.kt\nandroidx/collection/ScatterMapKt\n+ 6 ObjectList.kt\nandroidx/collection/ObjectList\n*L\n1#1,211:1\n49#2,4:212\n139#3:216\n140#3,3:233\n144#3,3:242\n147#3:252\n372#4,3:217\n329#4,6:220\n339#4,3:227\n342#4,2:231\n345#4,6:245\n375#4:251\n1399#5:226\n1270#5:230\n287#6,6:236\n*S KotlinDebug\n*F\n+ 1 ControlledRetainedValuesStore.kt\nandroidx/compose/runtime/retain/ControlledRetainedValuesStore\n*L\n120#1:212,4\n126#1:216\n126#1:233,3\n126#1:242,3\n126#1:252\n126#1:217,3\n126#1:220,6\n126#1:227,3\n126#1:231,2\n126#1:245,6\n126#1:251\n126#1:226\n126#1:230\n126#1:236,6\n*E\n"})
public final class ControlledRetainedValuesStore
extends RetainedValuesStore {
    @NotNull
    private final MutableScatterMap<Object, Object> keptExitedValues = SafeMultiValueMap.constructor-impl$default(null, 1, null);
    @NotNull
    private RetainStateProvider parentStore = RetainStateProvider.NeverRetainExitedValues.INSTANCE;
    @NotNull
    private final parentObserver.1 parentObserver = new RetainStateProvider.RetainStateObserver(this){
        final /* synthetic */ ControlledRetainedValuesStore this$0;
        {
            this.this$0 = $receiver;
        }

        public void onStartRetainingExitedValues() {
            this.this$0.requestRetainExitedValues();
        }

        public void onStopRetainingExitedValues() {
            this.this$0.unRequestRetainExitedValues();
        }
    };
    public static final int $stable = 8;

    public final int getRetainExitedValuesRequestsFromSelf() {
        return this.getRetainExitedValuesRequests() - (this.parentStore.isRetainingExitedValues() ? 1 : 0);
    }

    public final void setParentRetainStateProvider(@NotNull RetainStateProvider parent) {
        RetainStateProvider oldParent = this.parentStore;
        this.parentStore = parent;
        parent.addRetainStateObserver(this.parentObserver);
        oldParent.removeRetainStateObserver(this.parentObserver);
        if (parent.isRetainingExitedValues()) {
            this.startRetainingExitedValues();
        }
        if (oldParent.isRetainingExitedValues()) {
            this.stopRetainingExitedValues();
        }
    }

    public final void startRetainingExitedValues() {
        this.requestRetainExitedValues();
    }

    public final void stopRetainingExitedValues() {
        this.unRequestRetainExitedValues();
    }

    @Override
    protected void onStartRetainingExitedValues() {
        boolean value$iv = SafeMultiValueMap.isEmpty-impl(this.keptExitedValues);
        boolean $i$f$checkPrecondition = false;
        if (!value$iv) {
            boolean bl = false;
            PreconditionsKt.throwIllegalStateException("Attempted to start retaining exited values with pending exited values");
        }
    }

    @Override
    protected void onStopRetainingExitedValues() {
        MutableScatterMap<Object, Object> mutableScatterMap = this.keptExitedValues;
        boolean bl = false;
        ScatterMap this_$iv$iv = mutableScatterMap;
        boolean $i$f$forEachValue = false;
        Object[] v$iv$iv = this_$iv$iv.values;
        ScatterMap this_$iv$iv$iv = this_$iv$iv;
        boolean $i$f$forEachIndexed = false;
        int i$iv$iv$iv = 0;
        long[] m$iv$iv$iv = this_$iv$iv$iv.metadata;
        int lastIndex$iv$iv$iv = m$iv$iv$iv.length - 2;
        if (i$iv$iv$iv <= lastIndex$iv$iv$iv) {
            while (true) {
                long slot$iv$iv$iv;
                long $this$maskEmptyOrDeleted$iv$iv$iv$iv = slot$iv$iv$iv = m$iv$iv$iv[i$iv$iv$iv];
                boolean $i$f$maskEmptyOrDeleted = false;
                if (($this$maskEmptyOrDeleted$iv$iv$iv$iv & ($this$maskEmptyOrDeleted$iv$iv$iv$iv ^ 0xFFFFFFFFFFFFFFFFL) << 7 & 0x8080808080808080L) != -9187201950435737472L) {
                    int bitCount$iv$iv$iv = 8 - (~(i$iv$iv$iv - lastIndex$iv$iv$iv) >>> 31);
                    for (int j$iv$iv$iv = 0; j$iv$iv$iv < bitCount$iv$iv$iv; ++j$iv$iv$iv) {
                        long value$iv$iv$iv$iv = slot$iv$iv$iv & 0xFFL;
                        boolean $i$f$isFull = false;
                        if (value$iv$iv$iv$iv < 128L) {
                            boolean bl2;
                            Object value;
                            int index$iv$iv$iv;
                            int index$iv$iv = index$iv$iv$iv = (i$iv$iv$iv << 3) + j$iv$iv$iv;
                            boolean bl3 = false;
                            Object it$iv = v$iv$iv[index$iv$iv];
                            boolean bl4 = false;
                            if (it$iv instanceof MutableObjectList) {
                                Object object = it$iv;
                                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type androidx.collection.MutableObjectList<V of androidx.compose.runtime.retain.impl.SafeMultiValueMap>");
                                ObjectList this_$iv$iv2 = (MutableObjectList)object;
                                boolean $i$f$forEach = false;
                                Object[] content$iv$iv = this_$iv$iv2.content;
                                int n = this_$iv$iv2._size;
                                for (int i$iv$iv = 0; i$iv$iv < n; ++i$iv$iv) {
                                    Object value$iv = content$iv$iv[i$iv$iv];
                                    boolean bl5 = false;
                                    value = value$iv;
                                    bl2 = false;
                                    if (!(value instanceof RetainObserver)) continue;
                                    ((RetainObserver)value).onRetired();
                                }
                            } else {
                                value = it$iv;
                                bl2 = false;
                                if (value instanceof RetainObserver) {
                                    ((RetainObserver)value).onRetired();
                                }
                            }
                        }
                        slot$iv$iv$iv >>= 8;
                    }
                    if (bitCount$iv$iv$iv != 8) break;
                }
                if (i$iv$iv$iv == lastIndex$iv$iv$iv) break;
                ++i$iv$iv$iv;
            }
        }
        SafeMultiValueMap.clear-impl(this.keptExitedValues);
    }

    @Override
    @Nullable
    public Object getExitedValueOrElse(@NotNull Object key, @Nullable Object defaultValue) {
        return SafeMultiValueMap.removeLast-impl(this.keptExitedValues, key, defaultValue);
    }

    @Override
    protected void saveExitingValue(@NotNull Object key, @Nullable Object value) {
        SafeMultiValueMap.add-impl(this.keptExitedValues, key, value);
    }
}

