/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.devkit.toolwindow;

import com.intellij.internal.statistic.devkit.toolwindow.StatisticsEventLogConsole;
import com.intellij.internal.statistic.devkit.toolwindow.StatisticsEventLogFormatter;
import com.intellij.internal.statistic.devkit.toolwindow.StatisticsEventLogMessageBuilder;
import com.intellij.internal.statistic.devkit.toolwindow.StatisticsLogFilterModel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.util.Disposer;
import com.jetbrains.fus.reporting.model.lion3.LogEvent;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/internal/statistic/devkit/toolwindow/ChangedStateEventsPanel;", "Lcom/intellij/openapi/ui/SimpleToolWindowPanel;", "project", "Lcom/intellij/openapi/project/Project;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "difference", "", "Lcom/jetbrains/fus/reporting/model/lion3/LogEvent;", "recorderId", "", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/Disposable;Ljava/util/Collection;Ljava/lang/String;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "model", "Lcom/intellij/internal/statistic/devkit/toolwindow/StatisticsLogFilterModel;", "logFormatter", "Lcom/intellij/internal/statistic/devkit/toolwindow/StatisticsEventLogFormatter;", "consoleLog", "Lcom/intellij/internal/statistic/devkit/toolwindow/StatisticsEventLogConsole;", "intellij.platform.statistics.devkit"})
public final class ChangedStateEventsPanel
extends SimpleToolWindowPanel {
    @NotNull
    private final Project project;
    @NotNull
    private final StatisticsLogFilterModel model;
    @NotNull
    private final StatisticsEventLogFormatter logFormatter;
    @NotNull
    private final StatisticsEventLogConsole consoleLog;

    public ChangedStateEventsPanel(@NotNull Project project, @NotNull Disposable parentDisposable, @NotNull Collection<? extends LogEvent> difference, @NotNull String recorderId) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkNotNullParameter(difference, (String)"difference");
        Intrinsics.checkNotNullParameter((Object)recorderId, (String)"recorderId");
        super(false, true);
        this.project = project;
        this.model = new StatisticsLogFilterModel();
        this.logFormatter = new StatisticsEventLogFormatter(this.model);
        this.consoleLog = new StatisticsEventLogConsole(this.project, this.model, recorderId, this.logFormatter);
        this.setContent(this.consoleLog.getComponent());
        StatisticsEventLogMessageBuilder messageBuilder = new StatisticsEventLogMessageBuilder();
        for (LogEvent logEvent : difference) {
            this.consoleLog.addLogLine(messageBuilder.buildLogMessage(logEvent, null, null));
        }
        Disposer.register((Disposable)parentDisposable, (Disposable)((Disposable)this.consoleLog));
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }
}

