/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations.coverage;

import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.coverage.CoverageClassFilterEditor;
import com.intellij.execution.configurations.coverage.CoverageConfigurable;
import com.intellij.execution.configurations.coverage.JavaCoverageEnabledConfiguration;
import com.intellij.execution.ui.NestedGroupFragment;
import com.intellij.execution.ui.SettingsEditorFragment;
import com.intellij.java.coverage.JavaCoverageBundle;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.classFilter.ClassFilter;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.JBInsets;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.border.Border;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CoverageFragment<T extends RunConfigurationBase<?>>
extends NestedGroupFragment<T> {
    private final RunConfigurationBase<?> myConfiguration;

    public CoverageFragment(RunConfigurationBase<?> configuration) {
        super("coverage", JavaCoverageBundle.message("coverage.settings", new Object[0]), JavaCoverageBundle.message("coverage.settings.group", new Object[0]), p -> false);
        this.myConfiguration = configuration;
    }

    public String getChildrenGroupName() {
        return JavaCoverageBundle.message("coverage.settings.menu", new Object[0]);
    }

    protected List<SettingsEditorFragment<T, ?>> createChildren() {
        ArrayList fragments = new ArrayList();
        SettingsEditorFragment<T, CoverageClassFilterEditor> include = this.createFilterEditor("coverage.include", JavaCoverageBundle.message("record.coverage.filters.title", new Object[0]), true, JavaCoverageBundle.message("coverage.settings.include", new Object[0]));
        include.setActionHint(JavaCoverageBundle.message("show.coverage.data.only.in.specified.classes.and.packages", new Object[0]));
        fragments.add(include);
        SettingsEditorFragment<T, CoverageClassFilterEditor> exclude = this.createFilterEditor("coverage.exclude", JavaCoverageBundle.message("exclude.coverage.filters.title", new Object[0]), false, JavaCoverageBundle.message("coverage.settings.exclude", new Object[0]));
        exclude.setActionHint(JavaCoverageBundle.message("do.not.show.coverage.data.in.specified.classes.and.packages", new Object[0]));
        fragments.add(exclude);
        return fragments;
    }

    @NotNull
    private SettingsEditorFragment<T, CoverageClassFilterEditor> createFilterEditor(String id, @NotNull @Nls String message, boolean included, @NotNull @Nls String optionName) {
        if (message == null) {
            CoverageFragment.$$$reportNull$$$0(0);
        }
        if (optionName == null) {
            CoverageFragment.$$$reportNull$$$0(1);
        }
        CoverageClassFilterEditor filterEditor = new CoverageClassFilterEditor(this.myConfiguration.getProject());
        filterEditor.setBorder((Border)IdeBorderFactory.createTitledBorder((String)message, (boolean)false, (Insets)JBInsets.emptyInsets()));
        filterEditor.setupEasyFocusTraversing();
        return new SettingsEditorFragment(id, optionName, null, (JComponent)((Object)filterEditor), (p, editor) -> editor.setFilters(CoverageConfigurable.getCoveragePatterns(CoverageFragment.getConfiguration(p), included)), (p, editor) -> CoverageFragment.setCoveragePatterns(CoverageFragment.getConfiguration(p), this.isSelected() && filterEditor.isVisible() ? editor.getFilters() : ClassFilter.EMPTY_ARRAY, included), p -> CoverageConfigurable.getCoveragePatterns(CoverageFragment.getConfiguration(p), included).length > 0);
    }

    @Nullable
    private static JavaCoverageEnabledConfiguration getConfiguration(RunConfigurationBase<?> configuration) {
        return JavaCoverageEnabledConfiguration.getFrom(configuration);
    }

    private static void setCoveragePatterns(@Nullable JavaCoverageEnabledConfiguration configuration, ClassFilter[] filters, boolean included) {
        if (configuration == null) {
            return;
        }
        Object[] patterns = CoverageConfigurable.getCoveragePatterns(configuration, !included);
        for (ClassFilter filter : filters) {
            filter.INCLUDE = included;
        }
        configuration.setCoveragePatterns((ClassFilter[])ArrayUtil.mergeArrays((Object[])filters, (Object[])patterns));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "message";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "optionName";
                break;
            }
        }
        objectArray[1] = "com/intellij/execution/configurations/coverage/CoverageFragment";
        objectArray[2] = "createFilterEditor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

