/*
 * Decompiled with CFR 0.152.
 */
package git4idea.validators;

import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.util.text.StringUtil;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public final class GitRefNameValidator
implements InputValidator {
    private static final GitRefNameValidator INSTANCE = new GitRefNameValidator();
    private static final String CONTROL_CHARS;
    private static final Pattern REPLACE;
    private static final Pattern DROP;
    private static final Pattern ENDPATTERNS;
    private static final Pattern VALIDATEPATTERNS;

    public static GitRefNameValidator getInstance() {
        return INSTANCE;
    }

    private GitRefNameValidator() {
    }

    public boolean checkInput(String inputString) {
        return !StringUtil.isEmptyOrSpaces((String)inputString) && !VALIDATEPATTERNS.matcher(inputString).find();
    }

    public boolean canClose(String inputString) {
        return this.checkInput(inputString);
    }

    @NotNull
    public String cleanUpBranchName(@NotNull String branchName) {
        if (branchName == null) {
            GitRefNameValidator.$$$reportNull$$$0(0);
        }
        String string = this.cleanUpBranchNameOnTyping(branchName).replaceAll(ENDPATTERNS.pattern(), "");
        if (string == null) {
            GitRefNameValidator.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String cleanUpBranchNameOnTyping(@NotNull String branchName) {
        if (branchName == null) {
            GitRefNameValidator.$$$reportNull$$$0(2);
        }
        String string = branchName.replaceAll(DROP.pattern(), "").replaceAll(REPLACE.pattern(), AdvancedSettings.getString((String)"git.branch.cleanup.symbol"));
        if (string == null) {
            GitRefNameValidator.$$$reportNull$$$0(3);
        }
        return string;
    }

    static {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (char c = '\u0000'; c < ' '; c = (char)(c + '\u0001')) {
            sb.append(c);
        }
        sb.append('\u007f');
        sb.append("]");
        CONTROL_CHARS = sb.toString();
        REPLACE = Pattern.compile(" +|" + CONTROL_CHARS);
        DROP = Pattern.compile("(^\\.)|(^-)|(^/)|[~:^?*\"\\[\\\\]+|(@\\{)+|/(?=/)|(\\.(?=\\.))+|\\.(?=/)|(?<=/)\\.|");
        ENDPATTERNS = Pattern.compile("(([./]|\\.lock)$)|");
        VALIDATEPATTERNS = Pattern.compile(DROP.pattern() + ENDPATTERNS.pattern() + REPLACE.pattern());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branchName";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/validators/GitRefNameValidator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/validators/GitRefNameValidator";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "cleanUpBranchName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "cleanUpBranchNameOnTyping";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "cleanUpBranchName";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "cleanUpBranchNameOnTyping";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3 -> new IllegalStateException(string);
        };
    }
}

