/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.tooling.internal;

import com.google.common.base.Objects;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.AnnotationProcessingConfig;
import org.jetbrains.plugins.gradle.tooling.util.GradleContainerUtil;

public class AnnotationProcessingConfigImpl
implements AnnotationProcessingConfig,
Serializable {
    private final List<File> myPaths;
    private final List<String> myArgs;
    private final String myProcessorOutput;
    private final boolean isTestSources;

    public AnnotationProcessingConfigImpl(Collection<File> files, List<String> args, String output, boolean sources) {
        this.myProcessorOutput = output;
        this.isTestSources = sources;
        this.myPaths = new ArrayList<File>(files);
        this.myArgs = args;
    }

    @NotNull
    public Collection<String> getAnnotationProcessorPath() {
        Set set = GradleContainerUtil.unmodifiablePathSet(this.myPaths);
        if (set == null) {
            AnnotationProcessingConfigImpl.$$$reportNull$$$0(0);
        }
        return set;
    }

    @NotNull
    public Collection<String> getAnnotationProcessorArguments() {
        List<String> list = this.myArgs;
        if (list == null) {
            AnnotationProcessingConfigImpl.$$$reportNull$$$0(1);
        }
        return list;
    }

    public boolean isTestSources() {
        return this.isTestSources;
    }

    @Nullable
    public String getProcessorOutput() {
        return this.myProcessorOutput;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnnotationProcessingConfigImpl config = (AnnotationProcessingConfigImpl)o;
        return this.isTestSources == config.isTestSources && Objects.equal((Object)this.myProcessorOutput, (Object)config.myProcessorOutput) && Objects.equal(this.myPaths, config.myPaths) && Objects.equal(this.myArgs, config.myArgs);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.myPaths, this.myArgs, this.myProcessorOutput, this.isTestSources});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/plugins/gradle/tooling/internal/AnnotationProcessingConfigImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotationProcessorPath";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotationProcessorArguments";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

