/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.model;

import com.intellij.openapi.util.Pair;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.gradle.tooling.internal.gradle.DefaultBuildIdentifier;
import org.gradle.tooling.model.gradle.BasicGradleProject;
import org.gradle.tooling.model.gradle.GradleBuild;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.DefaultGradleLightProject;
import org.jetbrains.plugins.gradle.model.GradleLightBuild;

@ApiStatus.Internal
public final class DefaultGradleLightBuild
implements GradleLightBuild,
Serializable {
    @NotNull
    private final String myName;
    @NotNull
    private final DefaultBuildIdentifier myBuildIdentifier;
    @NotNull
    private final DefaultGradleLightProject myRootProject;
    @NotNull
    private final List<DefaultGradleLightProject> myProjects;
    @Nullable
    private DefaultGradleLightBuild myParentBuild;

    public DefaultGradleLightBuild(@NotNull GradleBuild gradleBuild, @NotNull GradleVersion gradleVersion) {
        if (gradleBuild == null) {
            DefaultGradleLightBuild.$$$reportNull$$$0(0);
        }
        if (gradleVersion == null) {
            DefaultGradleLightBuild.$$$reportNull$$$0(1);
        }
        this.myParentBuild = null;
        BasicGradleProject rootGradleProject = gradleBuild.getRootProject();
        this.myName = rootGradleProject.getName();
        this.myBuildIdentifier = new DefaultBuildIdentifier(gradleBuild.getBuildIdentifier().getRootDir());
        LinkedHashMap<BasicGradleProject, DefaultGradleLightProject> projects = new LinkedHashMap<BasicGradleProject, DefaultGradleLightProject>();
        for (BasicGradleProject project : gradleBuild.getProjects()) {
            projects.put(project, new DefaultGradleLightProject(this, project, gradleVersion));
        }
        DefaultGradleLightBuild.replicateModelHierarchy(rootGradleProject, it -> (DefaultGradleLightProject)projects.get(it), BasicGradleProject::getChildren, DefaultGradleLightProject::addChildProject);
        this.myRootProject = (DefaultGradleLightProject)projects.get(rootGradleProject);
        this.myProjects = new ArrayList(projects.values());
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            DefaultGradleLightBuild.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public DefaultBuildIdentifier getBuildIdentifier() {
        DefaultBuildIdentifier defaultBuildIdentifier = this.myBuildIdentifier;
        if (defaultBuildIdentifier == null) {
            DefaultGradleLightBuild.$$$reportNull$$$0(3);
        }
        return defaultBuildIdentifier;
    }

    @NotNull
    public DefaultGradleLightProject getRootProject() {
        DefaultGradleLightProject defaultGradleLightProject = this.myRootProject;
        if (defaultGradleLightProject == null) {
            DefaultGradleLightBuild.$$$reportNull$$$0(4);
        }
        return defaultGradleLightProject;
    }

    @NotNull
    public List<DefaultGradleLightProject> getProjects() {
        List<DefaultGradleLightProject> list = this.myProjects;
        if (list == null) {
            DefaultGradleLightBuild.$$$reportNull$$$0(5);
        }
        return list;
    }

    @Nullable
    public DefaultGradleLightBuild getParentBuild() {
        return this.myParentBuild;
    }

    public void setParentBuild(@Nullable DefaultGradleLightBuild parentBuild) {
        this.myParentBuild = parentBuild;
    }

    public String toString() {
        return "ProjectModel{name='" + this.myName + '\'' + ", id=" + this.myBuildIdentifier + '}';
    }

    public static <ModelA, ModelB> void replicateModelHierarchy(@NotNull ModelA rootModelA, @NotNull @NotNull Function<@NotNull ModelA, @Nullable ModelB> getModel, @NotNull @NotNull Function<@NotNull ModelA, @NotNull Collection<? extends @NotNull ModelA>> getChildModel, @NotNull @NotNull BiConsumer<@NotNull ModelB, @NotNull ModelB> addChildModel) {
        ModelB rootModelB;
        if (rootModelA == null) {
            DefaultGradleLightBuild.$$$reportNull$$$0(6);
        }
        if (getModel == null) {
            DefaultGradleLightBuild.$$$reportNull$$$0(7);
        }
        if (getChildModel == null) {
            DefaultGradleLightBuild.$$$reportNull$$$0(8);
        }
        if (addChildModel == null) {
            DefaultGradleLightBuild.$$$reportNull$$$0(9);
        }
        if ((rootModelB = getModel.apply(rootModelA)) == null) {
            return;
        }
        ArrayDeque<Pair> queue = new ArrayDeque<Pair>();
        queue.add(new Pair(rootModelA, rootModelB));
        while (!queue.isEmpty()) {
            Pair parentModel = (Pair)queue.remove();
            Object parentModelA = parentModel.getFirst();
            Object parentModelB = parentModel.getSecond();
            for (ModelA childModelA : getChildModel.apply(parentModelA)) {
                ModelB childModelB = getModel.apply(childModelA);
                if (childModelB == null) continue;
                queue.add(new Pair(childModelA, childModelB));
                addChildModel.accept(parentModelB, childModelB);
            }
        }
    }

    @NotNull
    public static List<DefaultGradleLightBuild> convertGradleBuilds(@NotNull Collection<? extends GradleBuild> gradleBuilds, @NotNull GradleVersion gradleVersion) {
        if (gradleBuilds == null) {
            DefaultGradleLightBuild.$$$reportNull$$$0(10);
        }
        if (gradleVersion == null) {
            DefaultGradleLightBuild.$$$reportNull$$$0(11);
        }
        LinkedHashMap<GradleBuild, DefaultGradleLightBuild> gradleBuildsToConverted = new LinkedHashMap<GradleBuild, DefaultGradleLightBuild>();
        for (GradleBuild gradleBuild : gradleBuilds) {
            DefaultGradleLightBuild build = new DefaultGradleLightBuild(gradleBuild, gradleVersion);
            gradleBuildsToConverted.put(gradleBuild, build);
        }
        DefaultGradleLightBuild.setIncludedBuildsHierarchy(gradleBuilds, gradleBuildsToConverted);
        DefaultGradleLightBuild.setBuildSrcHierarchy(gradleBuildsToConverted.values());
        return new ArrayList<DefaultGradleLightBuild>(gradleBuildsToConverted.values());
    }

    private static void setIncludedBuildsHierarchy(@NotNull Collection<? extends GradleBuild> gradleBuilds, Map<GradleBuild, DefaultGradleLightBuild> gradleBuildsToConverted) {
        if (gradleBuilds == null) {
            DefaultGradleLightBuild.$$$reportNull$$$0(12);
        }
        for (GradleBuild gradleBuild : gradleBuilds) {
            DefaultGradleLightBuild build = gradleBuildsToConverted.get(gradleBuild);
            assert (build != null);
            for (GradleBuild includedGradleBuild : gradleBuild.getIncludedBuilds()) {
                DefaultGradleLightBuild buildToUpdate = gradleBuildsToConverted.get(includedGradleBuild);
                assert (buildToUpdate != null);
                buildToUpdate.setParentBuild(build);
            }
        }
    }

    private static void setBuildSrcHierarchy(@NotNull Collection<DefaultGradleLightBuild> convertedBuilds) {
        if (convertedBuilds == null) {
            DefaultGradleLightBuild.$$$reportNull$$$0(13);
        }
        HashMap<Path, DefaultGradleLightBuild> pathToBuild = new HashMap<Path, DefaultGradleLightBuild>();
        for (DefaultGradleLightBuild build : convertedBuilds) {
            pathToBuild.put(build.getBuildIdentifier().getRootDir().toPath(), build);
        }
        for (DefaultGradleLightBuild build : convertedBuilds) {
            DefaultGradleLightBuild parentBuild;
            Path buildSrcPath;
            Path parentDirectory;
            if (!build.getName().equals("buildSrc") || (parentDirectory = (buildSrcPath = build.getBuildIdentifier().getRootDir().toPath()).getParent()) == null || (parentBuild = (DefaultGradleLightBuild)pathToBuild.get(parentDirectory)) == null) continue;
            build.setParentBuild(parentBuild);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradleBuild";
                break;
            }
            case 1: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradleVersion";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/model/DefaultGradleLightBuild";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootModelA";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "getModel";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "getChildModel";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "addChildModel";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradleBuilds";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "convertedBuilds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/model/DefaultGradleLightBuild";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildIdentifier";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootProject";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjects";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "replicateModelHierarchy";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "convertGradleBuilds";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setIncludedBuildsHierarchy";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setBuildSrcHierarchy";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

