/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.polySymbols.query.impl;

import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.polySymbols.PolySymbol;
import com.intellij.polySymbols.context.PolyContext;
import com.intellij.polySymbols.context.PolyContextKindRules;
import com.intellij.polySymbols.context.PolyContextRulesProvider;
import com.intellij.polySymbols.context.impl.PolyContextDiscoveryKt;
import com.intellij.polySymbols.query.PolySymbolNameConversionRulesProvider;
import com.intellij.polySymbols.query.PolySymbolNamesProvider;
import com.intellij.polySymbols.query.PolySymbolQueryConfigurator;
import com.intellij.polySymbols.query.PolySymbolQueryExecutor;
import com.intellij.polySymbols.query.PolySymbolQueryExecutorFactory;
import com.intellij.polySymbols.query.PolySymbolQueryResultsCustomizerFactory;
import com.intellij.polySymbols.query.PolySymbolScope;
import com.intellij.polySymbols.query.impl.PolySymbolNamesProviderImpl;
import com.intellij.polySymbols.query.impl.PolySymbolQueryExecutorImpl;
import com.intellij.polySymbols.query.impl.PolySymbolQueryScopeService;
import com.intellij.polySymbols.utils.FileUtils;
import com.intellij.polySymbols.utils.PolySymbolPrioritizedScope;
import com.intellij.polySymbols.utils.PolySymbolUtils;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001a\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\"\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\n2\b\u0010\u0016\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0017\u001a\u00020\u0002H\u0016J\b\u0010\u0018\u001a\u00020\u0014H\u0016J9\u0010\u0019\u001a\u001e\u0012\u0014\u0012\u0012\u0012\b\u0012\u00060\u001bj\u0002`\u001c\u0012\u0004\u0012\u00020\u001d0\b\u0012\u0004\u0012\u00020\u001e0\u001a2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b J\"\u0010!\u001a\u00020\"2\u0006\u0010\u0003\u001a\u00020\u00042\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010#\u001a\u00020$H\u0002J\u0018\u0010%\u001a\b\u0012\u0004\u0012\u00020\n0&2\b\u0010#\u001a\u0004\u0018\u00010\u0010H\u0002J\u0016\u0010%\u001a\b\u0012\u0004\u0012\u00020\n0&2\u0006\u0010#\u001a\u00020\tH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0007\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/intellij/polySymbols/query/impl/PolySymbolQueryExecutorFactoryImpl;", "Lcom/intellij/polySymbols/query/PolySymbolQueryExecutorFactory;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "customScope", "Lcom/intellij/util/containers/MultiMap;", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/intellij/polySymbols/query/PolySymbolScope;", "modificationCount", "", "create", "Lcom/intellij/polySymbols/query/PolySymbolQueryExecutor;", "location", "Lcom/intellij/psi/PsiElement;", "allowResolve", "", "addScope", "", "scope", "contextDirectory", "disposable", "dispose", "getContextRules", "Lkotlin/Pair;", "", "Lcom/intellij/polySymbols/PolyContextKind;", "Lcom/intellij/polySymbols/context/PolyContextKindRules;", "Lcom/intellij/openapi/util/ModificationTracker;", "dir", "getContextRules$intellij_platform_polySymbols", "createNamesProvider", "Lcom/intellij/polySymbols/query/PolySymbolNamesProvider;", "context", "Lcom/intellij/polySymbols/context/PolyContext;", "getCustomScope", "", "intellij.platform.polySymbols"})
@SourceDebugExtension(value={"SMAP\nPolySymbolQueryExecutorFactoryImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PolySymbolQueryExecutorFactoryImpl.kt\ncom/intellij/polySymbols/query/impl/PolySymbolQueryExecutorFactoryImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,135:1\n1869#2,2:136\n1869#2,2:139\n1011#2,2:143\n808#2,11:145\n1563#2:156\n1634#2,3:157\n1869#2,2:160\n1374#2:162\n1460#2,5:163\n1374#2:168\n1460#2,5:169\n1869#2,2:174\n1#3:138\n30#4,2:141\n*S KotlinDebug\n*F\n+ 1 PolySymbolQueryExecutorFactoryImpl.kt\ncom/intellij/polySymbols/query/impl/PolySymbolQueryExecutorFactoryImpl\n*L\n37#1:136,2\n42#1:139,2\n49#1:143,2\n82#1:145,11\n83#1:156\n83#1:157,3\n84#1:160,2\n89#1:162\n89#1:163,5\n102#1:168\n102#1:169,5\n104#1:174,2\n45#1:141,2\n*E\n"})
public final class PolySymbolQueryExecutorFactoryImpl
implements PolySymbolQueryExecutorFactory,
Disposable {
    @NotNull
    private final Project project;
    @NotNull
    private final MultiMap<VirtualFile, PolySymbolScope> customScope;
    private long modificationCount;

    public PolySymbolQueryExecutorFactoryImpl(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.customScope = new MultiMap();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public PolySymbolQueryExecutor create(@Nullable PsiElement location, boolean allowResolve) {
        Object object;
        Application application;
        block8: {
            block7: {
                void $this$forEach$iv;
                application = ApplicationManager.getApplication();
                application.assertReadAccessAllowed();
                Iterable iterable = PolySymbolQueryConfigurator.EP_NAME.getExtensionList();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    PolySymbolQueryConfigurator it = (PolySymbolQueryConfigurator)element$iv;
                    boolean bl = false;
                    it.beforeQueryExecutorCreation(this.project);
                }
                object = location;
                if (object == null) break block7;
                PsiElement it = object;
                boolean bl = false;
                PolyContext polyContext = PolyContextDiscoveryKt.buildPolyContext(it);
                object = polyContext;
                if (polyContext != null) break block8;
            }
            object = PolyContext.Companion.empty();
        }
        Object context = object;
        List scopeList = new ArrayList();
        Iterable $this$forEach$iv = this.getCustomScope(location);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PolySymbolScope p0 = (PolySymbolScope)element$iv;
            boolean bl = false;
            scopeList.add(p0);
        }
        PsiElement psiElement = location;
        PsiElement originalLocation = psiElement != null ? psiElement.getOriginalElement() : null;
        Intrinsics.checkNotNull((Object)application);
        ComponentManager $this$service$iv = (ComponentManager)application;
        boolean $i$f$service = false;
        Class<PolySymbolQueryScopeService> serviceClass$iv = PolySymbolQueryScopeService.class;
        Object object2 = $this$service$iv.getService(serviceClass$iv);
        if (object2 == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        scopeList.addAll((Collection)((PolySymbolQueryScopeService)object2).buildScope(this.project, originalLocation, (PolyContext)context, allowResolve));
        List $this$sortBy$iv = scopeList;
        boolean $i$f$sortBy = false;
        if ($this$sortBy$iv.size() > 1) {
            CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    Object object;
                    Object object2;
                    PolySymbolScope it = (PolySymbolScope)a;
                    boolean bl = false;
                    PolySymbolScope $this$asSafely$iv = it;
                    boolean $i$f$asSafely = false;
                    PolySymbolScope polySymbolScope = $this$asSafely$iv;
                    if (!(polySymbolScope instanceof PolySymbolPrioritizedScope)) {
                        polySymbolScope = null;
                    }
                    if ((object2 = (PolySymbolPrioritizedScope)((Object)polySymbolScope)) == null || (object2 = object2.getPriority()) == null) {
                        object2 = PolySymbol.Priority.NORMAL;
                    }
                    it = (PolySymbolScope)b;
                    Comparable comparable = Double.valueOf(object2.getValue());
                    bl = false;
                    $this$asSafely$iv = it;
                    $i$f$asSafely = false;
                    PolySymbolScope polySymbolScope2 = $this$asSafely$iv;
                    if (!(polySymbolScope2 instanceof PolySymbolPrioritizedScope)) {
                        polySymbolScope2 = null;
                    }
                    if ((object = (PolySymbolPrioritizedScope)((Object)polySymbolScope2)) == null || (object = object.getPriority()) == null) {
                        object = PolySymbol.Priority.NORMAL;
                    }
                    return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Double.valueOf(object.getValue()));
                }
            });
        }
        return new PolySymbolQueryExecutorImpl(location, scopeList, this.createNamesProvider(this.project, originalLocation, (PolyContext)context), PolySymbolQueryResultsCustomizerFactory.Companion.getQueryResultsCustomizer(location, (PolyContext)context), (PolyContext)context, allowResolve);
    }

    @Override
    public void addScope(@NotNull PolySymbolScope scope, @Nullable VirtualFile contextDirectory, @NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        long l = this.modificationCount;
        this.modificationCount = l + 1L;
        this.customScope.putValue((Object)contextDirectory, (Object)scope);
        Disposer.register((Disposable)disposable, () -> PolySymbolQueryExecutorFactoryImpl.addScope$lambda$0(this, contextDirectory, scope));
    }

    public void dispose() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Pair<MultiMap<String, PolyContextKindRules>, ModificationTracker> getContextRules$intellij_platform_polySymbols(@NotNull Project project, @NotNull VirtualFile dir) {
        void $this$flatMapTo$iv$iv;
        void $this$forEach$iv;
        Iterator $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        MultiMap result2 = new MultiMap();
        Iterable iterable = this.getCustomScope(dir);
        boolean $i$f$filterIsInstance = false;
        void var6_7 = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof PolyContextRulesProvider)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterIsInstanceTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            Object item$iv$iv = iterator.next();
            PolyContextRulesProvider polyContextRulesProvider = (PolyContextRulesProvider)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getContextRules());
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MultiMap it = (MultiMap)element$iv;
            boolean bl = false;
            result2.putAllValues(it);
        }
        List providers = new ArrayList();
        Iterable $this$flatMap$iv = PolySymbolQueryConfigurator.EP_NAME.getExtensionList();
        boolean $i$f$flatMap = false;
        Iterable it = $this$flatMap$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            PolySymbolQueryConfigurator it2 = (PolySymbolQueryConfigurator)element$iv$iv;
            boolean bl = false;
            it2.beforeQueryExecutorCreation(project);
            Iterable list$iv$iv = it2.getContextRulesProviders(project, dir);
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        for (PolyContextRulesProvider provider : (List)destination$iv$iv2) {
            result2.putAllValues(provider.getContextRules());
            providers.add(provider.createPointer());
        }
        return new Pair((Object)result2, (Object)PolySymbolUtils.createModificationTracker(providers));
    }

    /*
     * WARNING - void declaration
     */
    private final PolySymbolNamesProvider createNamesProvider(Project project, PsiElement location, PolyContext context) {
        void $this$forEach$iv;
        void $this$flatMapTo$iv$iv;
        List nameConversionRules = new ArrayList();
        List providers = new ArrayList();
        Iterable $this$flatMap$iv = PolySymbolQueryConfigurator.EP_NAME.getExtensionList();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            PolySymbolQueryConfigurator provider = (PolySymbolQueryConfigurator)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = provider.getNameConversionRulesProviders(project, location, context);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PolySymbolNameConversionRulesProvider provider = (PolySymbolNameConversionRulesProvider)element$iv;
            boolean bl = false;
            nameConversionRules.add(provider.getNameConversionRules());
            providers.add(provider.createPointer());
        }
        return new PolySymbolNamesProviderImpl(context.getFramework(), nameConversionRules, PolySymbolUtils.createModificationTracker(providers));
    }

    /*
     * Enabled aggressive block sorting
     */
    private final List<PolySymbolScope> getCustomScope(PsiElement context) {
        List<PolySymbolScope> list2;
        if (context != null) {
            VirtualFile virtualFile;
            PsiFile psiFile;
            PsiElement it = context;
            boolean bl = false;
            PsiFile psiFile2 = InjectedLanguageManager.getInstance((Project)it.getProject()).getTopLevelFile(it);
            if (psiFile2 != null && (psiFile = psiFile2.getOriginalFile()) != null && (virtualFile = psiFile.getVirtualFile()) != null) {
                VirtualFile it2 = virtualFile;
                boolean bl2 = false;
                VirtualFile virtualFile2 = FileUtils.findOriginalFile(it2);
                if (virtualFile2 != null) {
                    VirtualFile it3 = virtualFile2;
                    boolean bl3 = false;
                    List<PolySymbolScope> list3 = this.getCustomScope(it3);
                    if (list3 != null) {
                        list2 = list3;
                        return list2;
                    }
                }
            }
        }
        list2 = CollectionsKt.emptyList();
        return list2;
    }

    private final List<PolySymbolScope> getCustomScope(VirtualFile context) {
        List result2 = new ArrayList();
        if (!this.customScope.isEmpty()) {
            Collection collection = this.customScope.get(null);
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"get(...)");
            result2.addAll(collection);
            for (VirtualFile f = context; f != null; f = f.getParent()) {
                if (!this.customScope.containsKey((Object)f)) continue;
                Collection collection2 = this.customScope.get((Object)f);
                Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"get(...)");
                result2.addAll(collection2);
            }
        }
        return result2;
    }

    private static final void addScope$lambda$0(PolySymbolQueryExecutorFactoryImpl this$0, VirtualFile $contextDirectory, PolySymbolScope $scope) {
        this$0.customScope.remove((Object)$contextDirectory, (Object)$scope);
    }
}

