/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui;

import com.intellij.database.DataGridBundle;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.run.ui.CellViewer;
import com.intellij.database.run.ui.CellViewerFactory;
import com.intellij.database.run.ui.EditorCellViewerFactory;
import com.intellij.database.run.ui.EmptyCellViewerFactory;
import com.intellij.database.run.ui.ReadonlyEditorCellViewerFactory;
import com.intellij.database.run.ui.TabInfoProvider;
import com.intellij.database.run.ui.UpdateEvent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\f\u001a\u00020\u0007H\u0002J\u0012\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u000eH\u0002J\b\u0010\u0012\u001a\u00020\u000eH\u0016J\b\u0010\u0013\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/database/run/ui/ValueTabInfoProvider;", "Lcom/intellij/database/run/ui/TabInfoProvider;", "grid", "Lcom/intellij/database/datagrid/DataGrid;", "<init>", "(Lcom/intellij/database/datagrid/DataGrid;)V", "currentViewerFactory", "Lcom/intellij/database/run/ui/CellViewerFactory;", "viewerFactories", "", "viewer", "Lcom/intellij/database/run/ui/CellViewer;", "chooseViewerFactory", "update", "", "event", "Lcom/intellij/database/run/ui/UpdateEvent;", "updateViewer", "dispose", "getViewer", "Companion", "intellij.grid.impl"})
@SourceDebugExtension(value={"SMAP\nValueTabInfoProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ValueTabInfoProvider.kt\ncom/intellij/database/run/ui/ValueTabInfoProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,71:1\n1999#2,14:72\n*S KotlinDebug\n*F\n+ 1 ValueTabInfoProvider.kt\ncom/intellij/database/run/ui/ValueTabInfoProvider\n*L\n39#1:72,14\n*E\n"})
public final class ValueTabInfoProvider
extends TabInfoProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DataGrid grid;
    @NotNull
    private CellViewerFactory currentViewerFactory;
    @NotNull
    private final List<CellViewerFactory> viewerFactories;
    @NotNull
    private CellViewer viewer;
    @NotNull
    private static final Logger LOG;

    /*
     * WARNING - void declaration
     */
    public ValueTabInfoProvider(@NotNull DataGrid grid) {
        void $this$viewerFactories_u24lambda_u240;
        Intrinsics.checkNotNullParameter((Object)grid, (String)"grid");
        String string = DataGridBundle.message((String)"EditMaximized.ValueEditor.text", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Object object = ActionManager.getInstance().getAction("Console.TableResult.EditMaximized.Value.Group");
        super(string, object instanceof ActionGroup ? (ActionGroup)object : null);
        this.grid = grid;
        Object object2 = object = CollectionsKt.createListBuilder();
        ValueTabInfoProvider valueTabInfoProvider = this;
        boolean bl = false;
        $this$viewerFactories_u24lambda_u240.add(EditorCellViewerFactory.INSTANCE);
        $this$viewerFactories_u24lambda_u240.add(ReadonlyEditorCellViewerFactory.INSTANCE);
        $this$viewerFactories_u24lambda_u240.add(EmptyCellViewerFactory.INSTANCE);
        $this$viewerFactories_u24lambda_u240.addAll((Collection)CellViewerFactory.Companion.getExternalFactories());
        valueTabInfoProvider.viewerFactories = CollectionsKt.build((List)object);
        this.currentViewerFactory = this.chooseViewerFactory();
        this.viewer = this.currentViewerFactory.createViewer(this.grid);
        this.updateTabInfo();
    }

    private final CellViewerFactory chooseViewerFactory() {
        CellViewerFactory cellViewerFactory;
        Object v2;
        ModelIndex modelIndex = this.grid.getSelectionModel().getLeadSelectionRow();
        Intrinsics.checkNotNullExpressionValue((Object)modelIndex, (String)"getLeadSelectionRow(...)");
        ModelIndex rowIdx = modelIndex;
        ModelIndex modelIndex2 = this.grid.getSelectionModel().getLeadSelectionColumn();
        Intrinsics.checkNotNullExpressionValue((Object)modelIndex2, (String)"getLeadSelectionColumn(...)");
        ModelIndex columnIdx = modelIndex2;
        Iterable $this$maxByOrNull$iv = this.viewerFactories;
        boolean $i$f$maxByOrNull = false;
        Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v2 = null;
        } else {
            Object maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v2 = maxElem$iv;
            } else {
                CellViewerFactory it = (CellViewerFactory)maxElem$iv;
                boolean bl = false;
                Comparable maxValue$iv = (Comparable)((Object)it.getSuitability(this.grid, (ModelIndex<GridRow>)rowIdx, (ModelIndex<GridColumn>)columnIdx));
                do {
                    Object e$iv = iterator$iv.next();
                    CellViewerFactory it2 = (CellViewerFactory)e$iv;
                    $i$a$-maxByOrNull-ValueTabInfoProvider$chooseViewerFactory$factory$1 = false;
                    Comparable v$iv = (Comparable)((Object)it2.getSuitability(this.grid, (ModelIndex<GridRow>)rowIdx, (ModelIndex<GridColumn>)columnIdx));
                    if (maxValue$iv.compareTo(v$iv) >= 0) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v2 = maxElem$iv;
            }
        }
        CellViewerFactory factory = v2;
        if (factory == null) {
            LOG.error("Cannot find cell viewer factory for " + rowIdx + " " + columnIdx);
        }
        if ((cellViewerFactory = factory) == null) {
            cellViewerFactory = EmptyCellViewerFactory.INSTANCE;
        }
        return cellViewerFactory;
    }

    @Override
    public void update(@Nullable UpdateEvent event) {
        this.updateViewer();
        super.update(event);
    }

    private final void updateViewer() {
        CellViewerFactory factory = this.chooseViewerFactory();
        if (!Intrinsics.areEqual((Object)this.currentViewerFactory, (Object)factory)) {
            this.currentViewerFactory = factory;
            CellViewer oldViewer = this.viewer;
            this.viewer = factory.createViewer(this.grid);
            this.updateTabInfo();
            Disposer.dispose((Disposable)oldViewer);
        }
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.viewer);
    }

    @Override
    @NotNull
    public CellViewer getViewer() {
        return this.viewer;
    }

    static {
        Logger logger = Logger.getInstance(ValueTabInfoProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/database/run/ui/ValueTabInfoProvider$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.grid.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

