/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridUtil;
import com.intellij.database.datagrid.color.ColorLayer;
import com.intellij.database.datagrid.color.GridColorModel;
import com.intellij.database.datagrid.color.GridColorModelImpl;
import com.intellij.database.datagrid.color.TableHeatmapColorLayer;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareToggleAction;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0004J\u0012\u0010\f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0004J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\u000f"}, d2={"Lcom/intellij/database/run/actions/ToggleTableViewBaseAction;", "Lcom/intellij/openapi/project/DumbAwareToggleAction;", "<init>", "()V", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "getOrCreateHeatMapColorLayer", "Lcom/intellij/database/datagrid/color/TableHeatmapColorLayer;", "getHeatMapColorLayer", "getGridColorModel", "Lcom/intellij/database/datagrid/color/GridColorModelImpl;", "intellij.grid.impl"})
public abstract class ToggleTableViewBaseAction
extends DumbAwareToggleAction {
    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        DataGrid dataGrid = GridUtil.getDataGrid(e.getDataContext());
        e.getPresentation().setEnabled(dataGrid != null);
        if (e.getPresentation().isEnabled()) {
            super.update(e);
        }
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    @Nullable
    protected final TableHeatmapColorLayer getOrCreateHeatMapColorLayer(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        TableHeatmapColorLayer heatmapColorLayer = this.getHeatMapColorLayer(e);
        if (heatmapColorLayer != null) {
            return heatmapColorLayer;
        }
        DataGrid dataGrid = GridUtil.getDataGrid(e.getDataContext());
        if (dataGrid == null) {
            return null;
        }
        DataGrid grid = dataGrid;
        return TableHeatmapColorLayer.Companion.installOn(grid);
    }

    @Nullable
    protected final TableHeatmapColorLayer getHeatMapColorLayer(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        GridColorModelImpl gridColorModelImpl = this.getGridColorModel(e);
        ColorLayer colorLayer = gridColorModelImpl != null ? gridColorModelImpl.getLayer(TableHeatmapColorLayer.class) : null;
        return colorLayer instanceof TableHeatmapColorLayer ? (TableHeatmapColorLayer)colorLayer : null;
    }

    private final GridColorModelImpl getGridColorModel(AnActionEvent e) {
        DataGrid dataGrid = GridUtil.getDataGrid(e.getDataContext());
        if (dataGrid == null) {
            return null;
        }
        DataGrid grid = dataGrid;
        GridColorModel gridColorModel = grid.getColorModel();
        return gridColorModel instanceof GridColorModelImpl ? (GridColorModelImpl)gridColorModel : null;
    }
}

