/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.ClassLoweringPass;
import org.jetbrains.kotlin.backend.common.phaser.PhaseDescription;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.JvmLoweredDeclarationOrigin;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.builders.IrElementBuilder;
import org.jetbrains.kotlin.ir.builders.IrElementBuilderKt;
import org.jetbrains.kotlin.ir.builders.declarations.DeclarationBuildersKt;
import org.jetbrains.kotlin.ir.builders.declarations.IrFunctionBuilder;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationsKt;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrFactoryHelpersKt;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrMutableAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrTypeParametersContainer;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.impl.BuildersKt;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrDelegatingConstructorCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.JvmStandardClassIds;

@PhaseDescription(name="JvmOverloadsAnnotation")
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u001c\u0010\u0012\u001a\u00020\u000e*\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\"\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016*\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/JvmOverloadsAnnotationLowering;", "Lorg/jetbrains/kotlin/backend/common/ClassLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "lower", "", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "generateWrappers", "target", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "generateWrapper", "numDefaultParametersToExpect", "", "generateWrapperHeader", "Lorg/jetbrains/kotlin/ir/declarations/IrFactory;", "oldFunction", "generateNewParameters", "", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "backend.jvm.lower"})
@SourceDebugExtension(value={"SMAP\nJvmOverloadsAnnotationLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmOverloadsAnnotationLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/JvmOverloadsAnnotationLowering\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 4 declarationBuilders.kt\norg/jetbrains/kotlin/ir/builders/declarations/DeclarationBuildersKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,155:1\n812#2,12:156\n777#2:168\n873#2,2:169\n1915#2,2:171\n1834#2,4:173\n1661#2,3:182\n1642#2,10:194\n1915#2:204\n1916#2:206\n1652#2:207\n406#3,5:177\n411#3:185\n315#4,4:186\n269#4,4:190\n1#5:205\n*S KotlinDebug\n*F\n+ 1 JvmOverloadsAnnotationLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/JvmOverloadsAnnotationLowering\n*L\n38#1:156,12\n38#1:168\n38#1:169,2\n42#1:171,2\n48#1:173,4\n72#1:182,3\n138#1:194,10\n138#1:204\n138#1:206\n138#1:207\n72#1:177,5\n72#1:185\n103#1:186,4\n112#1:190,4\n138#1:205\n*E\n"})
public final class JvmOverloadsAnnotationLowering
implements ClassLoweringPass {
    @NotNull
    private final JvmBackendContext context;

    public JvmOverloadsAnnotationLowering(@NotNull JvmBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
    }

    @NotNull
    public final JvmBackendContext getContext() {
        return this.context;
    }

    /*
     * WARNING - void declaration
     */
    public void lower(@NotNull IrClass irClass) {
        void $this$filterTo$iv$iv;
        Iterable $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)irClass, (String)"irClass");
        Iterable $this$filterIsInstance$iv = irClass.getDeclarations();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof IrFunction)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            IrFunction it = (IrFunction)element$iv$iv;
            boolean bl = false;
            if (!IrUtilsKt.hasAnnotation((IrAnnotationContainer)((IrAnnotationContainer)it), (FqName)JvmStandardClassIds.INSTANCE.getJVM_OVERLOADS_FQ_NAME())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List functions = (List)destination$iv$iv;
        Iterable $this$forEach$iv = functions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrFunction it = (IrFunction)element$iv;
            boolean bl = false;
            this.generateWrappers(it, irClass);
        }
    }

    private final void generateWrappers(IrFunction target, IrClass irClass) {
        int n;
        Iterable $this$count$iv = target.getParameters();
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                IrValueParameter it = (IrValueParameter)element$iv;
                boolean bl = false;
                if (!(it.getDefaultValue() != null) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        int numDefaultParameters = n;
        for (int i = numDefaultParameters - 1; -1 < i; --i) {
            IrFunction wrapper = this.generateWrapper(target, i);
            IrDeclarationsKt.addMember((IrClass)irClass, (IrDeclaration)((IrDeclaration)wrapper));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final IrFunction generateWrapper(IrFunction target, int numDefaultParametersToExpect) {
        IrBody irBody;
        void $this$mapTo$iv$iv;
        void $this$assignFrom$iv;
        IrFunctionAccessExpression irFunctionAccessExpression;
        IrFunction wrapperIrFunction = this.generateWrapperHeader(this.context.getIrFactory(), target, numDefaultParametersToExpect);
        IrFunction irFunction = target;
        if (irFunction instanceof IrConstructor) {
            irFunctionAccessExpression = (IrFunctionAccessExpression)BuildersKt.fromSymbolOwner$default((IrDelegatingConstructorCallImpl.Companion)IrDelegatingConstructorCallImpl.Companion, (int)-1, (int)-1, (IrType)this.context.getIrBuiltIns().getUnitType(), (IrConstructorSymbol)((IrConstructor)target).getSymbol(), (int)0, (int)16, null);
        } else if (irFunction instanceof IrSimpleFunction) {
            irFunctionAccessExpression = (IrFunctionAccessExpression)BuildersKt.fromSymbolOwner$default((IrCallImpl.Companion)IrCallImpl.Companion, (int)-1, (int)-1, (IrType)target.getReturnType(), (IrSimpleFunctionSymbol)((IrSimpleFunction)target).getSymbol(), null, null, (int)48, null);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        IrFunctionAccessExpression call = irFunctionAccessExpression;
        for (IrTypeParameter arg : IrUtilsKt.getAllTypeParameters((IrFunction)wrapperIrFunction)) {
            call.getTypeArguments().set(arg.getIndex(), IrTypesKt.getDefaultType((IrTypeParameter)arg));
        }
        Ref.IntRef parametersCopied = new Ref.IntRef();
        int defaultParametersCopied = 0;
        List list = (List)call.getArguments();
        Collection other$iv = target.getParameters();
        boolean $i$f$assignFrom = false;
        $this$assignFrom$iv.clear();
        if ($this$assignFrom$iv instanceof ArrayList) {
            ((ArrayList)$this$assignFrom$iv).ensureCapacity(other$iv.size());
        }
        Iterable iterable = other$iv;
        Collection destination$iv$iv = (Collection)$this$assignFrom$iv;
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            IrGetValueImpl irGetValueImpl;
            void valueParameter;
            IrValueParameter irValueParameter = (IrValueParameter)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            if (valueParameter.getDefaultValue() == null) {
                irGetValueImpl = JvmOverloadsAnnotationLowering.generateWrapper$lambda$0$irGetParameter(wrapperIrFunction, parametersCopied);
            } else if (defaultParametersCopied < numDefaultParametersToExpect) {
                ++defaultParametersCopied;
                irGetValueImpl = JvmOverloadsAnnotationLowering.generateWrapper$lambda$0$irGetParameter(wrapperIrFunction, parametersCopied);
            } else {
                irGetValueImpl = null;
            }
            collection.add((IrExpression)irGetValueImpl);
        }
        list = target;
        if (list instanceof IrConstructor) {
            irBody = (IrBody)IrFactoryHelpersKt.createBlockBody((IrFactory)this.context.getIrFactory(), (int)-1, (int)-1, (List)CollectionsKt.listOf((Object)call));
        } else if (list instanceof IrSimpleFunction) {
            irBody = (IrBody)this.context.getIrFactory().createExpressionBody(-1, -1, (IrExpression)call);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        wrapperIrFunction.setBody(irBody);
        return wrapperIrFunction;
    }

    private final IrFunction generateWrapperHeader(IrFactory $this$generateWrapperHeader, IrFunction oldFunction, int numDefaultParametersToExpect) {
        IrFunction irFunction;
        IrFunction irFunction2 = oldFunction;
        if (irFunction2 instanceof IrConstructor) {
            IrFactory $this$buildConstructor$iv = $this$generateWrapperHeader;
            boolean $i$f$buildConstructor = false;
            IrFunctionBuilder $this$buildConstructor_u24lambda_u241$iv = new IrFunctionBuilder();
            boolean bl = false;
            IrFunctionBuilder $this$generateWrapperHeader_u24lambda_u240 = $this$buildConstructor_u24lambda_u241$iv;
            boolean bl2 = false;
            IrElementBuilderKt.setSourceRange((IrElementBuilder)((IrElementBuilder)$this$generateWrapperHeader_u24lambda_u240), (IrElement)((IrElement)oldFunction));
            $this$generateWrapperHeader_u24lambda_u240.setOrigin((IrDeclarationOrigin)JvmLoweredDeclarationOrigin.INSTANCE.getJVM_OVERLOADS_WRAPPER());
            $this$generateWrapperHeader_u24lambda_u240.setName(oldFunction.getName());
            $this$generateWrapperHeader_u24lambda_u240.setVisibility(oldFunction.getVisibility());
            $this$generateWrapperHeader_u24lambda_u240.setReturnType(oldFunction.getReturnType());
            $this$generateWrapperHeader_u24lambda_u240.setInline(oldFunction.isInline());
            irFunction = (IrFunction)DeclarationBuildersKt.buildConstructor((IrFactory)$this$buildConstructor$iv, (IrFunctionBuilder)$this$buildConstructor_u24lambda_u241$iv);
        } else if (irFunction2 instanceof IrSimpleFunction) {
            IrFactory $this$buildFun$iv = $this$generateWrapperHeader;
            boolean $i$f$buildFun = false;
            IrFunctionBuilder $this$buildFun_u24lambda_u240$iv = new IrFunctionBuilder();
            boolean bl = false;
            IrFunctionBuilder $this$generateWrapperHeader_u24lambda_u241 = $this$buildFun_u24lambda_u240$iv;
            boolean bl3 = false;
            IrElementBuilderKt.setSourceRange((IrElementBuilder)((IrElementBuilder)$this$generateWrapperHeader_u24lambda_u241), (IrElement)((IrElement)oldFunction));
            $this$generateWrapperHeader_u24lambda_u241.setOrigin((IrDeclarationOrigin)JvmLoweredDeclarationOrigin.INSTANCE.getJVM_OVERLOADS_WRAPPER());
            $this$generateWrapperHeader_u24lambda_u241.setName(oldFunction.getName());
            $this$generateWrapperHeader_u24lambda_u241.setVisibility(oldFunction.getVisibility());
            $this$generateWrapperHeader_u24lambda_u241.setModality(this.context.getConfig().getLanguageVersionSettings().supportsFeature(LanguageFeature.GenerateJvmOverloadsAsFinal) ? Modality.FINAL : ((IrSimpleFunction)oldFunction).getModality());
            $this$generateWrapperHeader_u24lambda_u241.setReturnType(oldFunction.getReturnType());
            $this$generateWrapperHeader_u24lambda_u241.setInline(oldFunction.isInline());
            $this$generateWrapperHeader_u24lambda_u241.setSuspend(((IrSimpleFunction)oldFunction).isSuspend());
            irFunction = (IrFunction)DeclarationBuildersKt.buildFunction((IrFactory)$this$buildFun$iv, (IrFunctionBuilder)$this$buildFun_u24lambda_u240$iv);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        IrFunction res2 = irFunction;
        res2.setParent(oldFunction.getParent());
        IrUtilsKt.copyAnnotationsFrom((IrMutableAnnotationContainer)((IrMutableAnnotationContainer)res2), (IrAnnotationContainer)((IrAnnotationContainer)oldFunction));
        IrUtilsKt.copyTypeParametersFrom$default((IrTypeParametersContainer)((IrTypeParametersContainer)res2), (IrTypeParametersContainer)((IrTypeParametersContainer)oldFunction), null, null, (int)6, null);
        res2.setParameters(CollectionsKt.plus((Collection)res2.getParameters(), (Iterable)this.generateNewParameters(res2, oldFunction, numDefaultParametersToExpect)));
        return res2;
    }

    /*
     * WARNING - void declaration
     */
    private final List<IrValueParameter> generateNewParameters(IrFunction $this$generateNewParameters, IrFunction oldFunction, int numDefaultParametersToExpect) {
        void $this$mapNotNullTo$iv$iv;
        int defaultParametersCopied = 0;
        Iterable $this$mapNotNull$iv = oldFunction.getParameters();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            IrValueParameter irValueParameter;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            IrValueParameter oldParameter = (IrValueParameter)element$iv$iv;
            boolean bl2 = false;
            if (oldParameter.getDefaultValue() == null) {
                irValueParameter = IrUtilsKt.copyTo$default((IrValueParameter)oldParameter, (IrFunction)$this$generateNewParameters, null, (int)0, (int)0, null, null, null, null, null, (boolean)false, (boolean)false, (boolean)false, null, null, (int)16382, null);
            } else if (defaultParametersCopied < numDefaultParametersToExpect) {
                ++defaultParametersCopied;
                irValueParameter = IrUtilsKt.copyTo$default((IrValueParameter)oldParameter, (IrFunction)$this$generateNewParameters, null, (int)0, (int)0, null, null, null, null, null, (boolean)oldParameter.isCrossinline(), (boolean)oldParameter.isNoinline(), (boolean)false, null, null, (int)14590, null);
            } else {
                irValueParameter = null;
            }
            if (irValueParameter == null) continue;
            IrValueParameter it$iv$iv = irValueParameter;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final IrGetValueImpl generateWrapper$lambda$0$irGetParameter(IrFunction wrapperIrFunction, Ref.IntRef parametersCopied) {
        int n = parametersCopied.element;
        parametersCopied.element = n + 1;
        return BuildersKt.IrGetValueImpl$default((int)-1, (int)-1, (IrValueSymbol)((IrValueSymbol)((IrValueParameter)wrapperIrFunction.getParameters().get(n)).getSymbol()), null, (int)8, null);
    }
}

