/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.ObjectUtilsRt;
import com.intellij.util.containers.HashingStrategy;
import com.intellij.util.containers.RefValueHashMapUtil;
import com.intellij.util.containers.ReferenceQueueable;
import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Deprecated
@ApiStatus.ScheduledForRemoval
public class ConcurrentWeakKeySoftValueHashMap<K, V>
implements ConcurrentMap<K, V>,
ReferenceQueueable {
    private final ConcurrentMap<KeyReference<K, V>, ValueReference<K, V>> myMap;
    final ReferenceQueue<K> myKeyQueue;
    final ReferenceQueue<V> myValueQueue;
    @NotNull
    final HashingStrategy<? super K> myHashingStrategy;
    private static final ThreadLocal<HardKey<?, ?>> HARD_KEY = ThreadLocal.withInitial(() -> new HardKey());

    protected ConcurrentWeakKeySoftValueHashMap(int initialCapacity, float loadFactor, int concurrencyLevel) {
        this(initialCapacity, loadFactor, concurrencyLevel, HashingStrategy.canonical());
    }

    protected ConcurrentWeakKeySoftValueHashMap(int initialCapacity, float loadFactor, int concurrencyLevel, @NotNull HashingStrategy<? super K> hashingStrategy) {
        if (hashingStrategy == null) {
            ConcurrentWeakKeySoftValueHashMap.$$$reportNull$$$0(0);
        }
        this.myKeyQueue = new ReferenceQueue();
        this.myValueQueue = new ReferenceQueue();
        this.myHashingStrategy = hashingStrategy;
        this.myMap = new ConcurrentHashMap<KeyReference<K, V>, ValueReference<K, V>>(initialCapacity, loadFactor, concurrencyLevel);
    }

    @NotNull
    KeyReference<K, V> createKeyReference(@NotNull K k, @NotNull V v) {
        if (k == null) {
            ConcurrentWeakKeySoftValueHashMap.$$$reportNull$$$0(1);
        }
        if (v == null) {
            ConcurrentWeakKeySoftValueHashMap.$$$reportNull$$$0(2);
        }
        ValueReference<K, V> valueReference = this.createValueReference(v, this.myValueQueue);
        WeakKey keyReference = new WeakKey(k, valueReference, this.myHashingStrategy, this.myKeyQueue);
        if (valueReference instanceof SoftValue) {
            ((SoftValue)valueReference).myKeyReference = keyReference;
        }
        ObjectUtilsRt.reachabilityFence(k);
        ObjectUtilsRt.reachabilityFence(v);
        WeakKey weakKey = keyReference;
        if (weakKey == null) {
            ConcurrentWeakKeySoftValueHashMap.$$$reportNull$$$0(3);
        }
        return weakKey;
    }

    @NotNull
    protected ValueReference<K, V> createValueReference(@NotNull V value, @NotNull ReferenceQueue<? super V> queue) {
        if (value == null) {
            ConcurrentWeakKeySoftValueHashMap.$$$reportNull$$$0(4);
        }
        if (queue == null) {
            ConcurrentWeakKeySoftValueHashMap.$$$reportNull$$$0(5);
        }
        return new SoftValue(value, queue);
    }

    @Override
    public int size() {
        return this.myMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.myMap.isEmpty();
    }

    @Override
    public void clear() {
        this.myMap.clear();
        this.processQueue();
    }

    @NotNull
    private HardKey<K, V> createHardKey(@NotNull Object o) {
        if (o == null) {
            ConcurrentWeakKeySoftValueHashMap.$$$reportNull$$$0(6);
        }
        Object key = o;
        HardKey<?, ?> hardKey = HARD_KEY.get();
        ((HardKey)hardKey).set(key, this.myHashingStrategy.hashCode(key));
        HardKey<?, ?> hardKey2 = hardKey;
        if (hardKey2 == null) {
            ConcurrentWeakKeySoftValueHashMap.$$$reportNull$$$0(7);
        }
        return hardKey2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(@NotNull Object key) {
        if (key == null) {
            ConcurrentWeakKeySoftValueHashMap.$$$reportNull$$$0(8);
        }
        HardKey<K, V> hardKey = this.createHardKey(key);
        try {
            ValueReference valueReference = (ValueReference)this.myMap.get(hardKey);
            V v = valueReference == null ? null : (V)valueReference.get();
            return v;
        }
        finally {
            hardKey.clear();
        }
    }

    @Override
    public boolean containsKey(@NotNull Object key) {
        if (key == null) {
            ConcurrentWeakKeySoftValueHashMap.$$$reportNull$$$0(9);
        }
        throw RefValueHashMapUtil.pointlessContainsKey();
    }

    @Override
    public boolean containsValue(@NotNull Object value) {
        if (value == null) {
            ConcurrentWeakKeySoftValueHashMap.$$$reportNull$$$0(10);
        }
        throw RefValueHashMapUtil.pointlessContainsValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(@NotNull Object key) {
        if (key == null) {
            ConcurrentWeakKeySoftValueHashMap.$$$reportNull$$$0(11);
        }
        HardKey<K, V> hardKey = this.createHardKey(key);
        try {
            ValueReference valueReference = (ValueReference)this.myMap.remove(hardKey);
            V v = valueReference == null ? null : (V)valueReference.get();
            return v;
        }
        finally {
            hardKey.clear();
            this.processQueue();
        }
    }

    @Override
    public void putAll(@NotNull Map<? extends K, ? extends V> m) {
        if (m == null) {
            ConcurrentWeakKeySoftValueHashMap.$$$reportNull$$$0(12);
        }
        for (Map.Entry<K, V> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public V put(K key, V value) {
        KeyReference<K, V> keyReference = this.createKeyReference(key, value);
        ValueReference<K, V> valueReference = keyReference.getValueReference();
        ValueReference<K, V> prevValReference = this.myMap.put(keyReference, valueReference);
        this.processQueue();
        return prevValReference == null ? null : (V)prevValReference.get();
    }

    @Override
    @ApiStatus.Internal
    public boolean processQueue() {
        ValueReference valueReference;
        KeyReference keyReference;
        boolean removed = false;
        while ((keyReference = (KeyReference)((Object)this.myKeyQueue.poll())) != null) {
            valueReference = keyReference.getValueReference();
            removed |= this.myMap.remove(keyReference, valueReference);
        }
        while ((valueReference = (ValueReference)((Object)this.myValueQueue.poll())) != null) {
            keyReference = valueReference.getKeyReference();
            if (keyReference == null) continue;
            removed |= this.myMap.remove(keyReference, valueReference);
        }
        return removed;
    }

    @Override
    @NotNull
    public Set<K> keySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public Collection<V> values() {
        ArrayList<Object> values2 = new ArrayList<Object>();
        for (ValueReference valueReference : this.myMap.values()) {
            Object v = valueReference == null ? null : (Object)valueReference.get();
            if (v == null) continue;
            values2.add(v);
        }
        ArrayList<Object> arrayList = values2;
        if (arrayList == null) {
            ConcurrentWeakKeySoftValueHashMap.$$$reportNull$$$0(13);
        }
        return arrayList;
    }

    @Override
    @NotNull
    public Set<Map.Entry<K, V>> entrySet() {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(@NotNull Object key, @NotNull Object value) {
        if (key == null) {
            ConcurrentWeakKeySoftValueHashMap.$$$reportNull$$$0(14);
        }
        if (value == null) {
            ConcurrentWeakKeySoftValueHashMap.$$$reportNull$$$0(15);
        }
        HardKey<K, V> hardKey = this.createHardKey(key);
        try {
            ValueReference valueReference = (ValueReference)this.myMap.get(hardKey);
            Object v = valueReference == null ? null : valueReference.get();
            boolean bl = value.equals(v) && this.myMap.remove(hardKey, valueReference);
            return bl;
        }
        finally {
            hardKey.clear();
            this.processQueue();
        }
    }

    @Override
    public V putIfAbsent(@NotNull K key, @NotNull V value) {
        Object prev;
        if (key == null) {
            ConcurrentWeakKeySoftValueHashMap.$$$reportNull$$$0(16);
        }
        if (value == null) {
            ConcurrentWeakKeySoftValueHashMap.$$$reportNull$$$0(17);
        }
        KeyReference<K, V> keyRef = this.createKeyReference(key, value);
        ValueReference<K, V> newRef = keyRef.getValueReference();
        while (true) {
            ValueReference<K, V> oldRef;
            if ((oldRef = this.myMap.putIfAbsent(keyRef, newRef)) == null) {
                prev = null;
                break;
            }
            V oldVal = oldRef.get();
            if (oldVal == null) {
                if (this.myMap.replace(keyRef, oldRef, newRef)) {
                    prev = null;
                    break;
                }
            } else {
                prev = oldVal;
                break;
            }
            this.processQueue();
        }
        this.processQueue();
        return prev;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean replace(@NotNull K key, @NotNull V oldValue, @NotNull V newValue) {
        if (key == null) {
            ConcurrentWeakKeySoftValueHashMap.$$$reportNull$$$0(18);
        }
        if (oldValue == null) {
            ConcurrentWeakKeySoftValueHashMap.$$$reportNull$$$0(19);
        }
        if (newValue == null) {
            ConcurrentWeakKeySoftValueHashMap.$$$reportNull$$$0(20);
        }
        HardKey<K, V> oldKeyReference = this.createHardKey(key);
        try {
            ValueReference<K, V> oldValueReference = this.createValueReference(oldValue, this.myValueQueue);
            ValueReference<K, V> newValueReference = this.createValueReference(newValue, this.myValueQueue);
            boolean replaced = this.myMap.replace(oldKeyReference, oldValueReference, newValueReference);
            this.processQueue();
            boolean bl = replaced;
            return bl;
        }
        finally {
            oldKeyReference.clear();
            ObjectUtilsRt.reachabilityFence(oldValue);
            ObjectUtilsRt.reachabilityFence(newValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V replace(@NotNull K key, @NotNull V value) {
        if (key == null) {
            ConcurrentWeakKeySoftValueHashMap.$$$reportNull$$$0(21);
        }
        if (value == null) {
            ConcurrentWeakKeySoftValueHashMap.$$$reportNull$$$0(22);
        }
        HardKey<K, V> keyReference = this.createHardKey(key);
        try {
            ValueReference<K, V> valueReference = this.createValueReference(value, this.myValueQueue);
            ValueReference<K, V> result = this.myMap.replace(keyReference, valueReference);
            V prev = result == null ? null : (V)result.get();
            this.processQueue();
            V v = prev;
            return v;
        }
        finally {
            keyReference.clear();
            ObjectUtilsRt.reachabilityFence(value);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 7: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 7: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hashingStrategy";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "k";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "v";
                break;
            }
            case 3: 
            case 7: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/containers/ConcurrentWeakKeySoftValueHashMap";
                break;
            }
            case 4: 
            case 10: 
            case 15: 
            case 17: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queue";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 8: 
            case 9: 
            case 11: 
            case 14: 
            case 16: 
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "m";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldValue";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/containers/ConcurrentWeakKeySoftValueHashMap";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createKeyReference";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createHardKey";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "values";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createKeyReference";
                break;
            }
            case 3: 
            case 7: 
            case 13: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createValueReference";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createHardKey";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "containsKey";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "containsValue";
                break;
            }
            case 11: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "remove";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "putAll";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "putIfAbsent";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "replace";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 7: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface ValueReference<K, V>
    extends Supplier<V> {
        public KeyReference<K, V> getKeyReference();

        @Override
        public V get();
    }

    static final class WeakKey<K, V>
    extends WeakReference<K>
    implements KeyReference<K, V> {
        private final int myHash;
        private final HashingStrategy<? super K> myStrategy;
        @NotNull
        private final ValueReference<K, V> myValueReference;

        WeakKey(@NotNull K k, @NotNull ValueReference<K, V> valueReference, @NotNull HashingStrategy<? super K> strategy, @NotNull ReferenceQueue<? super K> queue) {
            if (k == null) {
                WeakKey.$$$reportNull$$$0(0);
            }
            if (valueReference == null) {
                WeakKey.$$$reportNull$$$0(1);
            }
            if (strategy == null) {
                WeakKey.$$$reportNull$$$0(2);
            }
            if (queue == null) {
                WeakKey.$$$reportNull$$$0(3);
            }
            super(k, queue);
            this.myValueReference = valueReference;
            this.myHash = strategy.hashCode(k);
            this.myStrategy = strategy;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof KeyReference)) {
                return false;
            }
            Object t = this.get();
            Object other = ((KeyReference)o).get();
            if (t == null || other == null) {
                return false;
            }
            if (t == other) {
                return true;
            }
            return this.myHash == o.hashCode() && this.myStrategy.equals(t, other);
        }

        @Override
        public int hashCode() {
            return this.myHash;
        }

        @Override
        @NotNull
        public ValueReference<K, V> getValueReference() {
            ValueReference<K, V> valueReference = this.myValueReference;
            if (valueReference == null) {
                WeakKey.$$$reportNull$$$0(4);
            }
            return valueReference;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "k";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "valueReference";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "strategy";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "queue";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/containers/ConcurrentWeakKeySoftValueHashMap$WeakKey";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/containers/ConcurrentWeakKeySoftValueHashMap$WeakKey";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValueReference";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static final class SoftValue<K, V>
    extends SoftReference<V>
    implements ValueReference<K, V> {
        volatile KeyReference<K, V> myKeyReference;

        private SoftValue(@NotNull V value, @NotNull ReferenceQueue<? super V> queue) {
            if (value == null) {
                SoftValue.$$$reportNull$$$0(0);
            }
            if (queue == null) {
                SoftValue.$$$reportNull$$$0(1);
            }
            super(value, queue);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null) {
                return false;
            }
            Object v = this.get();
            Object thatV = ((ValueReference)o).get();
            return v != null && v.equals(thatV);
        }

        @Override
        public KeyReference<K, V> getKeyReference() {
            return this.myKeyReference;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "value";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "queue";
                    break;
                }
            }
            objectArray[1] = "com/intellij/util/containers/ConcurrentWeakKeySoftValueHashMap$SoftValue";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface KeyReference<K, V>
    extends Supplier<K> {
        @Override
        public K get();

        @NotNull
        public ValueReference<K, V> getValueReference();

        public boolean equals(Object var1);

        public int hashCode();
    }

    private static class HardKey<K, V>
    extends PhantomReference<K>
    implements KeyReference<K, V> {
        private K referent;
        private int myHash;

        HardKey() {
            super(null, null);
        }

        private void set(@NotNull K key, int hash) {
            if (key == null) {
                HardKey.$$$reportNull$$$0(0);
            }
            this.referent = key;
            this.myHash = hash;
        }

        @Override
        public void clear() {
            this.referent = null;
        }

        @Override
        public K get() {
            return this.referent;
        }

        @Override
        public boolean equals(Object o) {
            return o.equals(this);
        }

        @Override
        public int hashCode() {
            return this.myHash;
        }

        @Override
        @NotNull
        public ValueReference<K, V> getValueReference() {
            throw new UnsupportedOperationException();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/util/containers/ConcurrentWeakKeySoftValueHashMap$HardKey", "set"));
        }
    }
}

