/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.io;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.CaseSensitivityAttribute;
import com.intellij.util.BitUtil;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.DosFileAttributes;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FileAttributes {
    private static final byte SYM_LINK = 1;
    private static final byte HIDDEN = 2;
    private static final byte READ_ONLY = 4;
    private static final int TYPE_SHIFT = 3;
    private static final int CASE_SENSITIVITY_SHIFT = 5;
    public static final FileAttributes BROKEN_SYMLINK = new FileAttributes(1, 0L, 0L);
    private final byte flags;
    public final long length;
    public final long lastModified;

    public FileAttributes(boolean isDirectory, boolean isSpecial, boolean isSymlink, boolean isHidden, long length, long lastModified, boolean isWritable) {
        this(isDirectory, isSpecial, isSymlink, isHidden, length, lastModified, isWritable, CaseSensitivity.UNKNOWN);
    }

    /*
     * WARNING - void declaration
     */
    public FileAttributes(boolean isDirectory, boolean isSpecial, boolean isSymlink, boolean isHidden, long length, long lastModified, boolean bl, @NotNull CaseSensitivity caseSensitivity) {
        void caseSensitivity2;
        void isWritable;
        if (caseSensitivity == null) {
            FileAttributes.$$$reportNull$$$0(0);
        }
        this(FileAttributes.flags(isDirectory, isSpecial, isSymlink, isHidden, (boolean)isWritable, (CaseSensitivity)caseSensitivity2), length, lastModified);
    }

    private FileAttributes(byte flags, long length, long lastModified) {
        if (flags != -1 && (flags & 0x80) != 0) {
            throw new IllegalArgumentException("Invalid flags: " + Integer.toBinaryString(flags));
        }
        if (length < 0L) {
            throw new IllegalArgumentException("Invalid length: " + length);
        }
        this.flags = flags;
        this.length = this.isDirectory() ? 0L : length;
        this.lastModified = lastModified;
    }

    private static byte flags(boolean isDirectory, boolean isSpecial, boolean isSymlink, boolean isHidden, boolean isWritable, CaseSensitivity sensitivity) {
        byte flags = 0;
        if (isSymlink) {
            flags = (byte)(flags | 1);
        }
        if (isHidden) {
            flags = (byte)(flags | 2);
        }
        if (!isWritable) {
            flags = (byte)(flags | 4);
        }
        int type_flags = (isSpecial ? 3 : (isDirectory ? 2 : 1)) << 3;
        flags = (byte)(flags | type_flags);
        flags = FileAttributes.packSensitivityIntoFlags(isDirectory ? sensitivity : CaseSensitivity.UNKNOWN, flags);
        return flags;
    }

    private static byte packSensitivityIntoFlags(CaseSensitivity sensitivity, byte flags) {
        int sensitivity_flags = sensitivity.isUnknown() ? 0 : (sensitivity.isSensitive() ? 1 : 2);
        flags = (byte)(flags | sensitivity_flags << 5);
        return flags;
    }

    public boolean isFile() {
        return (this.flags >> 3 & 3) == 1;
    }

    public boolean isDirectory() {
        return (this.flags >> 3 & 3) == 2;
    }

    public boolean isSpecial() {
        return !this.isDirectory() && (this.flags >> 3 & 3) == 3;
    }

    public boolean isSymLink() {
        return BitUtil.isSet(this.flags, (byte)1);
    }

    public boolean isHidden() {
        return BitUtil.isSet(this.flags, (byte)2);
    }

    public boolean isWritable() {
        return !BitUtil.isSet(this.flags, (byte)4);
    }

    @Nullable(value="`null` means an unknown type, typically a broken symlink")
    public @Nullable(value="`null` means an unknown type, typically a broken symlink") Type getType() {
        int type = this.flags >> 3 & 3;
        switch (type) {
            case 0: {
                return null;
            }
            case 1: {
                return Type.FILE;
            }
            case 2: {
                return Type.DIRECTORY;
            }
            case 3: {
                return Type.SPECIAL;
            }
        }
        throw new IllegalStateException("Invalid type flags: " + Integer.toBinaryString(this.flags));
    }

    @NotNull
    public CaseSensitivity areChildrenCaseSensitive() {
        if (!this.isDirectory()) {
            CaseSensitivity caseSensitivity = CaseSensitivity.UNKNOWN;
            if (caseSensitivity == null) {
                FileAttributes.$$$reportNull$$$0(1);
            }
            return caseSensitivity;
        }
        int sensitivity_flags = this.flags >> 5 & 3;
        switch (sensitivity_flags) {
            case 0: {
                CaseSensitivity caseSensitivity = CaseSensitivity.UNKNOWN;
                if (caseSensitivity == null) {
                    FileAttributes.$$$reportNull$$$0(2);
                }
                return caseSensitivity;
            }
            case 1: {
                CaseSensitivity caseSensitivity = CaseSensitivity.SENSITIVE;
                if (caseSensitivity == null) {
                    FileAttributes.$$$reportNull$$$0(3);
                }
                return caseSensitivity;
            }
            case 2: {
                CaseSensitivity caseSensitivity = CaseSensitivity.INSENSITIVE;
                if (caseSensitivity == null) {
                    FileAttributes.$$$reportNull$$$0(4);
                }
                return caseSensitivity;
            }
        }
        throw new IllegalStateException("Invalid sensitivity flags: " + Integer.toBinaryString(sensitivity_flags));
    }

    @NotNull
    public FileAttributes withCaseSensitivity(@NotNull CaseSensitivity sensitivity) {
        if (sensitivity == null) {
            FileAttributes.$$$reportNull$$$0(5);
        }
        byte newFlags = (byte)(this.flags & 0xFFFFFF9F);
        newFlags = FileAttributes.packSensitivityIntoFlags(sensitivity, newFlags);
        return new FileAttributes(newFlags, this.length, this.lastModified);
    }

    @NotNull
    public FileAttributes withTimeStamp(long timestamp) {
        return new FileAttributes(this.flags, this.length, timestamp);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileAttributes that = (FileAttributes)o;
        if (this.flags != that.flags) {
            return false;
        }
        if (this.lastModified != that.lastModified) {
            return false;
        }
        return this.length == that.length;
    }

    public int hashCode() {
        int result = this.flags;
        result = 31 * result + Long.hashCode(this.length);
        result = 31 * result + Long.hashCode(this.lastModified);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[").append((Object)this.getType()).append(": '");
        if (BitUtil.isSet(this.flags, (byte)1)) {
            sb.append('l');
        }
        if (BitUtil.isSet(this.flags, (byte)2)) {
            sb.append('.');
        }
        if (BitUtil.isSet(this.flags, (byte)4)) {
            sb.append("ro");
        }
        sb.append("', ").append(this.length).append('b');
        sb.append(", modified: ").append(this.lastModified);
        if (this.isDirectory()) {
            sb.append(", case-sensitive: ").append((Object)this.areChildrenCaseSensitive());
        }
        sb.append(']');
        return sb.toString();
    }

    @NotNull
    public static FileAttributes fromNio(@NotNull Path path, @NotNull BasicFileAttributes attrs) {
        boolean isSymbolicLink;
        if (path == null) {
            FileAttributes.$$$reportNull$$$0(6);
        }
        if (attrs == null) {
            FileAttributes.$$$reportNull$$$0(7);
        }
        boolean isDirectory = attrs.isDirectory();
        boolean isOther = attrs.isOther();
        Path parent = path.getParent();
        boolean isSpecial = isOther && (!SystemInfo.isWindows || !isDirectory);
        boolean bl = isSymbolicLink = attrs.isSymbolicLink() || SystemInfo.isWindows && isOther && isDirectory && parent != null;
        if (isSymbolicLink) {
            try {
                attrs = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
                isDirectory = attrs.isDirectory();
            }
            catch (IOException e) {
                FileAttributes fileAttributes = BROKEN_SYMLINK;
                if (fileAttributes == null) {
                    FileAttributes.$$$reportNull$$$0(8);
                }
                return fileAttributes;
            }
        }
        boolean isHidden = false;
        boolean isWritable = false;
        if (SystemInfo.isWindows) {
            isHidden = parent != null && ((DosFileAttributes)attrs).isHidden();
            isWritable = isDirectory || !((DosFileAttributes)attrs).isReadOnly();
        } else {
            try {
                isWritable = isDirectory || Files.isWritable(path);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        long lastModified = attrs.lastModifiedTime().toMillis();
        CaseSensitivity caseSensitivity = isDirectory && attrs instanceof CaseSensitivityAttribute ? ((CaseSensitivityAttribute)attrs).getCaseSensitivity() : CaseSensitivity.UNKNOWN;
        return new FileAttributes(isDirectory, isSpecial, isSymbolicLink, isHidden, attrs.size(), lastModified, isWritable, caseSensitivity);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caseSensitivity";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/util/io/FileAttributes";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sensitivity";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attrs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/util/io/FileAttributes";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "areChildrenCaseSensitive";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "fromNio";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 8: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "withCaseSensitivity";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "fromNio";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum CaseSensitivity {
        SENSITIVE,
        INSENSITIVE,
        UNKNOWN;


        @ApiStatus.Experimental
        public boolean isSensitive() {
            return this == SENSITIVE;
        }

        @ApiStatus.Experimental
        public boolean isInsensitive() {
            return this == INSENSITIVE;
        }

        @ApiStatus.Experimental
        public boolean isUnknown() {
            return this == UNKNOWN;
        }

        @ApiStatus.Experimental
        public boolean isKnown() {
            return this != UNKNOWN;
        }

        @ApiStatus.Experimental
        public boolean toBooleanWithDefault(boolean defaultIfUnknown) {
            switch (this.ordinal()) {
                case 0: {
                    return true;
                }
                case 1: {
                    return false;
                }
                case 2: {
                    return defaultIfUnknown;
                }
            }
            throw new AssertionError((Object)((Object)((Object)this) + " is unrecognized"));
        }

        @ApiStatus.Experimental
        public boolean toBooleanOrFail() {
            switch (this.ordinal()) {
                case 0: {
                    return true;
                }
                case 1: {
                    return false;
                }
                case 2: {
                    throw new IllegalStateException("case sensitivity is UNKNOWN");
                }
            }
            throw new AssertionError((Object)((Object)((Object)this) + " is unrecognized"));
        }

        public static CaseSensitivity fromBoolean(boolean isCaseSensitive) {
            return isCaseSensitive ? SENSITIVE : INSENSITIVE;
        }
    }

    public static enum Type {
        FILE,
        DIRECTORY,
        SPECIAL;

    }
}

