/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.connection.request;

import com.intellij.internal.statistic.config.StatisticsStringUtil;
import com.intellij.internal.statistic.eventLog.connection.metadata.StatsConnectionSettings;
import com.intellij.internal.statistic.eventLog.connection.metadata.StatsProxyInfo;
import com.intellij.internal.statistic.eventLog.connection.request.StatsHttpResponse;
import com.intellij.internal.statistic.eventLog.connection.request.StatsRequestResult;
import com.intellij.internal.statistic.eventLog.connection.request.StatsResponseException;
import com.intellij.internal.statistic.eventLog.connection.request.StatsResponseHandler;
import com.intellij.internal.statistic.eventLog.connection.request.StatsResponseProcessor;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.Charset;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.zip.GZIPOutputStream;
import javax.net.ssl.SSLContext;
import org.jetbrains.annotations.NotNull;

public class StatsRequestBuilder {
    private static final int SUCCESS_CODE = 200;
    private static final List<Integer> CAN_RETRY_CODES = Arrays.asList(408, 429, 500, 502, 503, 504, 598);
    private static final int MAX_RETRIES = 1;
    private static final int RETRY_INTERVAL = 500;
    private final String myUserAgent;
    private final StatsProxyInfo myProxyInfo;
    private final SSLContext mySSLContext;
    private final Map<String, String> myExtraHeaders;
    private final String myUrl;
    private final String myMethod;
    private String myContent;
    private String myContentType;
    private Charset myCharset;
    private StatsResponseHandler onSucceed;
    private StatsResponseHandler onFail;

    public StatsRequestBuilder(@NotNull String method, @NotNull String url, @NotNull StatsConnectionSettings settings) {
        if (method == null) {
            StatsRequestBuilder.$$$reportNull$$$0(0);
        }
        if (url == null) {
            StatsRequestBuilder.$$$reportNull$$$0(1);
        }
        if (settings == null) {
            StatsRequestBuilder.$$$reportNull$$$0(2);
        }
        this.myMethod = method;
        this.myUrl = url;
        this.myUserAgent = settings.provideUserAgent();
        this.myProxyInfo = settings.provideProxy(this.myUrl);
        this.mySSLContext = settings.provideSSLContext();
        this.myExtraHeaders = settings.provideExtraHeaders();
    }

    @NotNull
    public StatsRequestBuilder withBody(@NotNull String body, @NotNull String contentType, @NotNull Charset charset) {
        if (body == null) {
            StatsRequestBuilder.$$$reportNull$$$0(3);
        }
        if (contentType == null) {
            StatsRequestBuilder.$$$reportNull$$$0(4);
        }
        if (charset == null) {
            StatsRequestBuilder.$$$reportNull$$$0(5);
        }
        if (StatisticsStringUtil.isEmptyOrSpaces(body)) {
            throw new EmptyHttpRequestBody();
        }
        this.myContent = body;
        this.myContentType = contentType;
        this.myCharset = charset;
        StatsRequestBuilder statsRequestBuilder = this;
        if (statsRequestBuilder == null) {
            StatsRequestBuilder.$$$reportNull$$$0(6);
        }
        return statsRequestBuilder;
    }

    @NotNull
    public StatsRequestBuilder fail(@NotNull StatsResponseHandler processor) {
        if (processor == null) {
            StatsRequestBuilder.$$$reportNull$$$0(7);
        }
        this.onFail = processor;
        StatsRequestBuilder statsRequestBuilder = this;
        if (statsRequestBuilder == null) {
            StatsRequestBuilder.$$$reportNull$$$0(8);
        }
        return statsRequestBuilder;
    }

    @NotNull
    public StatsRequestBuilder succeed(@NotNull StatsResponseHandler processor) {
        if (processor == null) {
            StatsRequestBuilder.$$$reportNull$$$0(9);
        }
        this.onSucceed = processor;
        StatsRequestBuilder statsRequestBuilder = this;
        if (statsRequestBuilder == null) {
            StatsRequestBuilder.$$$reportNull$$$0(10);
        }
        return statsRequestBuilder;
    }

    public void send() throws IOException, StatsResponseException {
        this.send(response -> {
            if (this.onSucceed != null) {
                this.onSucceed.handle(response, 200);
            }
            return true;
        });
    }

    public <T> StatsRequestResult<T> send(StatsResponseProcessor<? extends T> processor) throws IOException, StatsResponseException {
        HttpRequest request;
        HttpClient client = this.newClient();
        HttpResponse<String> response = StatsRequestBuilder.trySend(client, request = this.newRequest());
        int code = response.statusCode();
        if (code == 200) {
            T result = processor.onSucceed(new StatsHttpResponse(response, code));
            return StatsRequestResult.succeed(result);
        }
        if (this.onFail != null) {
            this.onFail.handle(new StatsHttpResponse(response, code), code);
        }
        return StatsRequestResult.error(code);
    }

    private static HttpResponse<String> trySend(HttpClient client, HttpRequest request) throws IOException, StatsResponseException {
        return StatsRequestBuilder.trySend(client, request, 0);
    }

    private static HttpResponse<String> trySend(HttpClient client, HttpRequest request, int retryCounter) throws IOException, StatsResponseException {
        try {
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
            if (CAN_RETRY_CODES.contains(response.statusCode()) && retryCounter < 1) {
                Thread.sleep(500L);
                response = StatsRequestBuilder.trySend(client, request, ++retryCounter);
            }
            return response;
        }
        catch (InterruptedException | SecurityException e) {
            throw new StatsResponseException(e);
        }
    }

    private HttpClient newClient() {
        HttpClient.Builder builder = HttpClient.newBuilder();
        builder.followRedirects(HttpClient.Redirect.NORMAL);
        if (this.myProxyInfo != null && !this.myProxyInfo.isNoProxy()) {
            StatsRequestBuilder.configureProxy(builder, this.myProxyInfo);
        }
        if (this.mySSLContext != null) {
            builder.sslContext(this.mySSLContext);
        }
        return builder.build();
    }

    private static void configureProxy(HttpClient.Builder builder, @NotNull StatsProxyInfo info) {
        SocketAddress proxyAddress;
        Proxy proxy;
        if (info == null) {
            StatsRequestBuilder.$$$reportNull$$$0(11);
        }
        if (((proxy = info.getProxy()).type() == Proxy.Type.HTTP || proxy.type() == Proxy.Type.SOCKS) && (proxyAddress = proxy.address()) instanceof InetSocketAddress) {
            String login;
            InetSocketAddress address = (InetSocketAddress)proxyAddress;
            String hostName = address.getHostString();
            int port = address.getPort();
            builder.proxy(ProxySelector.of(new InetSocketAddress(hostName, port)));
            final StatsProxyInfo.StatsProxyAuthProvider auth = info.getProxyAuth();
            if (auth != null && (login = auth.getProxyLogin()) != null) {
                builder.authenticator(new Authenticator(){

                    @Override
                    protected PasswordAuthentication getPasswordAuthentication() {
                        return new PasswordAuthentication(login, Objects.requireNonNullElse(auth.getProxyPassword(), "").toCharArray());
                    }
                });
            }
        }
    }

    @NotNull
    private HttpRequest newRequest() {
        HttpRequest.Builder builder = HttpRequest.newBuilder().setHeader("User-Agent", this.myUserAgent).timeout(Duration.ofSeconds(10L)).uri(URI.create(this.myUrl));
        if ("HEAD".equals(this.myMethod)) {
            builder.method(this.myMethod, HttpRequest.BodyPublishers.noBody());
        } else if ("POST".equals(this.myMethod)) {
            if (this.myContent == null || this.myContent.isBlank()) {
                throw new EmptyHttpRequestBody();
            }
            builder.setHeader("Chunked", Boolean.toString(false));
            builder.setHeader("Content-Type", String.format(Locale.ENGLISH, "%s; charset=%s", this.myContentType, this.myCharset));
            builder.setHeader("Content-Encoding", "gzip");
            builder.POST(HttpRequest.BodyPublishers.ofByteArray(this.getCompressedContent()));
        } else if ("GET".equals(this.myMethod)) {
            builder.GET();
        } else {
            throw new IllegalHttpRequestTypeException();
        }
        this.myExtraHeaders.forEach((k, v) -> builder.setHeader((String)k, (String)v));
        HttpRequest httpRequest = builder.build();
        if (httpRequest == null) {
            StatsRequestBuilder.$$$reportNull$$$0(12);
        }
        return httpRequest;
    }

    private byte[] getCompressedContent() {
        byte[] byArray;
        ByteArrayOutputStream gZippedBody = new ByteArrayOutputStream();
        try {
            GZIPOutputStream gZipper = new GZIPOutputStream(gZippedBody);
            gZipper.write(this.myContent.getBytes(this.myCharset));
            gZippedBody.flush();
            gZipper.close();
            byArray = gZippedBody.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    gZippedBody.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new HttpRequestBodyGzipException(e);
            }
        }
        gZippedBody.close();
        return byArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 8, 10, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "body";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentType";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charset";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/eventLog/connection/request/StatsRequestBuilder";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/eventLog/connection/request/StatsRequestBuilder";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "withBody";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "fail";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "succeed";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "newRequest";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "withBody";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 12: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "fail";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "succeed";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "configureProxy";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 8, 10, 12 -> new IllegalStateException(string);
        };
    }

    public static class EmptyHttpRequestBody
    extends InvalidHttpRequest {
        public EmptyHttpRequestBody() {
            super(51);
        }
    }

    public static class IllegalHttpRequestTypeException
    extends InvalidHttpRequest {
        public IllegalHttpRequestTypeException() {
            super(52);
        }
    }

    public static class HttpRequestBodyGzipException
    extends InvalidHttpRequest {
        public HttpRequestBodyGzipException(IOException ioException) {
            super(53, (Throwable)ioException);
        }
    }

    public static class InvalidHttpRequest
    extends RuntimeException {
        private final int myCode;

        public InvalidHttpRequest(int code) {
            this(code, null);
        }

        public InvalidHttpRequest(int code, Throwable throwable) {
            super(throwable);
            this.myCode = code;
        }

        public int getCode() {
            return this.myCode;
        }
    }
}

