/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractCharCollection;
import com.carrotsearch.hppc.AbstractIterator;
import com.carrotsearch.hppc.AbstractShortCollection;
import com.carrotsearch.hppc.CharCollection;
import com.carrotsearch.hppc.CharContainer;
import com.carrotsearch.hppc.CharLookupContainer;
import com.carrotsearch.hppc.CharShortAssociativeContainer;
import com.carrotsearch.hppc.CharShortHashMap;
import com.carrotsearch.hppc.CharShortMap;
import com.carrotsearch.hppc.ShortContainer;
import com.carrotsearch.hppc.comparators.CharComparator;
import com.carrotsearch.hppc.comparators.CharShortComparator;
import com.carrotsearch.hppc.cursors.CharCursor;
import com.carrotsearch.hppc.cursors.CharShortCursor;
import com.carrotsearch.hppc.cursors.ShortCursor;
import com.carrotsearch.hppc.predicates.CharPredicate;
import com.carrotsearch.hppc.predicates.CharShortPredicate;
import com.carrotsearch.hppc.predicates.ShortPredicate;
import com.carrotsearch.hppc.procedures.CharProcedure;
import com.carrotsearch.hppc.procedures.CharShortProcedure;
import com.carrotsearch.hppc.procedures.ShortProcedure;
import com.carrotsearch.hppc.sorting.QuickSort;
import java.util.Iterator;
import java.util.function.IntBinaryOperator;

public class SortedIterationCharShortHashMap
implements CharShortMap {
    public final CharShortHashMap delegate;
    public final int[] iterationOrder;

    public SortedIterationCharShortHashMap(CharShortHashMap delegate, CharComparator comparator) {
        this.delegate = delegate;
        this.iterationOrder = this.sortIterationOrder(this.createEntryIndexes(), comparator);
    }

    public SortedIterationCharShortHashMap(CharShortHashMap delegate, CharShortComparator comparator) {
        this.delegate = delegate;
        this.iterationOrder = this.sortIterationOrder(this.createEntryIndexes(), comparator);
    }

    private int[] createEntryIndexes() {
        char[] keys = this.delegate.keys;
        int size = this.delegate.size();
        int[] entryIndexes = new int[size];
        int entry = 0;
        if (this.delegate.hasEmptyKey) {
            entryIndexes[entry++] = this.delegate.mask + 1;
        }
        int keyIndex = 0;
        while (entry < size) {
            if (keys[keyIndex] != '\u0000') {
                entryIndexes[entry++] = keyIndex;
            }
            ++keyIndex;
        }
        return entryIndexes;
    }

    protected int[] sortIterationOrder(int[] entryIndexes, CharComparator comparator) {
        QuickSort.sort(entryIndexes, (i, j) -> {
            char[] keys = this.delegate.keys;
            return comparator.compare(keys[entryIndexes[i]], keys[entryIndexes[j]]);
        });
        return entryIndexes;
    }

    protected int[] sortIterationOrder(final int[] entryIndexes, final CharShortComparator comparator) {
        QuickSort.sort(entryIndexes, new IntBinaryOperator(){
            final char[] keys;
            final short[] values;
            {
                this.keys = SortedIterationCharShortHashMap.this.delegate.keys;
                this.values = SortedIterationCharShortHashMap.this.delegate.values;
            }

            @Override
            public int applyAsInt(int i, int j) {
                int index1 = entryIndexes[i];
                int index2 = entryIndexes[j];
                return comparator.compare(this.keys[index1], this.values[index1], this.keys[index2], this.values[index2]);
            }
        });
        return entryIndexes;
    }

    @Override
    public Iterator<CharShortCursor> iterator() {
        assert (this.checkUnmodified());
        return new EntryIterator();
    }

    @Override
    public boolean containsKey(char key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public int size() {
        assert (this.checkUnmodified());
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public int removeAll(CharContainer container) {
        throw SortedIterationCharShortHashMap.readOnlyException();
    }

    @Override
    public int removeAll(CharPredicate predicate) {
        throw SortedIterationCharShortHashMap.readOnlyException();
    }

    @Override
    public int removeAll(CharShortPredicate predicate) {
        throw SortedIterationCharShortHashMap.readOnlyException();
    }

    @Override
    public <T extends CharShortProcedure> T forEach(T procedure) {
        assert (this.checkUnmodified());
        int[] iterationOrder = this.iterationOrder;
        char[] keys = this.delegate.keys;
        short[] values = this.delegate.values;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            int slot = iterationOrder[i];
            procedure.apply(keys[slot], values[slot]);
        }
        return procedure;
    }

    @Override
    public <T extends CharShortPredicate> T forEach(T predicate) {
        int slot;
        assert (this.checkUnmodified());
        int[] iterationOrder = this.iterationOrder;
        char[] keys = this.delegate.keys;
        short[] values = this.delegate.values;
        int size = this.size();
        for (int i = 0; i < size && predicate.apply(keys[slot = iterationOrder[i]], values[slot]); ++i) {
        }
        return predicate;
    }

    @Override
    public CharCollection keys() {
        assert (this.checkUnmodified());
        return new KeysContainer();
    }

    @Override
    public ShortContainer values() {
        assert (this.checkUnmodified());
        return new ValuesContainer();
    }

    @Override
    public short get(char key) {
        return this.delegate.get(key);
    }

    @Override
    public short getOrDefault(char key, short defaultValue) {
        return this.delegate.getOrDefault(key, defaultValue);
    }

    @Override
    public short put(char key, short value) {
        throw SortedIterationCharShortHashMap.readOnlyException();
    }

    @Override
    public int putAll(CharShortAssociativeContainer container) {
        throw SortedIterationCharShortHashMap.readOnlyException();
    }

    @Override
    public int putAll(Iterable<? extends CharShortCursor> iterable) {
        throw SortedIterationCharShortHashMap.readOnlyException();
    }

    @Override
    public short putOrAdd(char key, short putValue, short incrementValue) {
        throw SortedIterationCharShortHashMap.readOnlyException();
    }

    @Override
    public short addTo(char key, short additionValue) {
        throw SortedIterationCharShortHashMap.readOnlyException();
    }

    @Override
    public short remove(char key) {
        throw SortedIterationCharShortHashMap.readOnlyException();
    }

    @Override
    public int indexOf(char key) {
        return this.delegate.indexOf(key);
    }

    @Override
    public boolean indexExists(int index) {
        return this.delegate.indexExists(index);
    }

    @Override
    public short indexGet(int index) {
        return this.delegate.indexGet(index);
    }

    @Override
    public short indexReplace(int index, short newValue) {
        throw SortedIterationCharShortHashMap.readOnlyException();
    }

    @Override
    public void indexInsert(int index, char key, short value) {
        throw SortedIterationCharShortHashMap.readOnlyException();
    }

    @Override
    public short indexRemove(int index) {
        throw SortedIterationCharShortHashMap.readOnlyException();
    }

    @Override
    public void clear() {
        throw SortedIterationCharShortHashMap.readOnlyException();
    }

    @Override
    public void release() {
        throw SortedIterationCharShortHashMap.readOnlyException();
    }

    @Override
    public String visualizeKeyDistribution(int characters) {
        return this.delegate.visualizeKeyDistribution(characters);
    }

    private static RuntimeException readOnlyException() {
        throw new UnsupportedOperationException("Read-only view cannot be modified");
    }

    private boolean checkUnmodified() {
        assert (this.delegate.size() == this.iterationOrder.length) : "The delegate map changed; this is not supported by this read-only view";
        return true;
    }

    private final class EntryIterator
    extends AbstractIterator<CharShortCursor> {
        private final CharShortCursor cursor = new CharShortCursor();
        private int index;

        private EntryIterator() {
        }

        @Override
        protected CharShortCursor fetch() {
            if (this.index < SortedIterationCharShortHashMap.this.iterationOrder.length) {
                int slot;
                this.cursor.index = slot = SortedIterationCharShortHashMap.this.iterationOrder[this.index++];
                this.cursor.key = SortedIterationCharShortHashMap.this.delegate.keys[slot];
                this.cursor.value = SortedIterationCharShortHashMap.this.delegate.values[slot];
                return this.cursor;
            }
            return (CharShortCursor)this.done();
        }
    }

    private final class KeysContainer
    extends AbstractCharCollection
    implements CharLookupContainer {
        private final SortedIterationCharShortHashMap owner;

        private KeysContainer() {
            this.owner = SortedIterationCharShortHashMap.this;
        }

        @Override
        public boolean contains(char e) {
            return this.owner.containsKey(e);
        }

        @Override
        public <T extends CharProcedure> T forEach(T procedure) {
            this.owner.forEach((k, v) -> procedure.apply(k));
            return procedure;
        }

        @Override
        public <T extends CharPredicate> T forEach(T predicate) {
            this.owner.forEach((key, value) -> predicate.apply(key));
            return predicate;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<CharCursor> iterator() {
            return new KeysIterator();
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public void clear() {
            throw SortedIterationCharShortHashMap.readOnlyException();
        }

        @Override
        public void release() {
            throw SortedIterationCharShortHashMap.readOnlyException();
        }

        @Override
        public int removeAll(CharPredicate predicate) {
            throw SortedIterationCharShortHashMap.readOnlyException();
        }

        @Override
        public int removeAll(char e) {
            throw SortedIterationCharShortHashMap.readOnlyException();
        }
    }

    private final class ValuesContainer
    extends AbstractShortCollection {
        private final SortedIterationCharShortHashMap owner;

        private ValuesContainer() {
            this.owner = SortedIterationCharShortHashMap.this;
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public boolean contains(short value) {
            for (CharShortCursor c : this.owner) {
                if (value != c.value) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends ShortProcedure> T forEach(T procedure) {
            this.owner.forEach((k, v) -> procedure.apply(v));
            return procedure;
        }

        @Override
        public <T extends ShortPredicate> T forEach(T predicate) {
            this.owner.forEach((k, v) -> predicate.apply(v));
            return predicate;
        }

        @Override
        public Iterator<ShortCursor> iterator() {
            return new ValuesIterator();
        }

        @Override
        public int removeAll(short e) {
            throw SortedIterationCharShortHashMap.readOnlyException();
        }

        @Override
        public int removeAll(ShortPredicate predicate) {
            throw SortedIterationCharShortHashMap.readOnlyException();
        }

        @Override
        public void clear() {
            throw SortedIterationCharShortHashMap.readOnlyException();
        }

        @Override
        public void release() {
            throw SortedIterationCharShortHashMap.readOnlyException();
        }
    }

    private final class ValuesIterator
    extends AbstractIterator<ShortCursor> {
        private final ShortCursor cursor = new ShortCursor();
        private int index;

        private ValuesIterator() {
        }

        @Override
        protected ShortCursor fetch() {
            if (this.index < SortedIterationCharShortHashMap.this.iterationOrder.length) {
                int slot;
                this.cursor.index = slot = SortedIterationCharShortHashMap.this.iterationOrder[this.index++];
                this.cursor.value = SortedIterationCharShortHashMap.this.delegate.values[slot];
                return this.cursor;
            }
            return (ShortCursor)this.done();
        }
    }

    private final class KeysIterator
    extends AbstractIterator<CharCursor> {
        private final CharCursor cursor = new CharCursor();
        private int index;

        private KeysIterator() {
        }

        @Override
        protected CharCursor fetch() {
            if (this.index < SortedIterationCharShortHashMap.this.iterationOrder.length) {
                int slot;
                this.cursor.index = slot = SortedIterationCharShortHashMap.this.iterationOrder[this.index++];
                this.cursor.value = SortedIterationCharShortHashMap.this.delegate.keys[slot];
                return this.cursor;
            }
            return (CharCursor)this.done();
        }
    }
}

