/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.util.cmd;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.apache.commons.cli.Option;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.util.cmd.GradleCommandLineTokenizer;
import org.jetbrains.plugins.gradle.util.cmd.node.GradleCommandLineOption;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0012\u0010\f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\r\u001a\u00020\u000bH\u0014J\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fJ\n\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002J\n\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002J\n\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0002J\n\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002J\u001e\u0010\u0018\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u00192\u0006\u0010\r\u001a\u00020\u000bH\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00040\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/plugins/gradle/util/cmd/GradleCommandLineOptionParser;", "", "options", "", "Lorg/apache/commons/cli/Option;", "tokenizer", "Lorg/jetbrains/plugins/gradle/util/cmd/GradleCommandLineTokenizer;", "<init>", "(Ljava/util/Collection;Lorg/jetbrains/plugins/gradle/util/cmd/GradleCommandLineTokenizer;)V", "optionIndex", "", "", "getOption", "token", "tryParseOption", "Lorg/jetbrains/plugins/gradle/util/cmd/node/GradleCommandLineOption;", "tryParsePropertyNotation", "Lorg/jetbrains/plugins/gradle/util/cmd/node/GradleCommandLineOption$PropertyNotation;", "tryParseShortNotation", "Lorg/jetbrains/plugins/gradle/util/cmd/node/GradleCommandLineOption$ShortNotation;", "tryParseLongNotation", "Lorg/jetbrains/plugins/gradle/util/cmd/node/GradleCommandLineOption$LongNotation;", "tryParseVarargNotation", "Lorg/jetbrains/plugins/gradle/util/cmd/node/GradleCommandLineOption$VarargNotation;", "parsePropertyOrNull", "Lkotlin/Pair;", "intellij.gradle"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nGradleCommandLineOptionParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradleCommandLineOptionParser.kt\norg/jetbrains/plugins/gradle/util/cmd/GradleCommandLineOptionParser\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,119:1\n682#2:120\n712#2,4:121\n682#2:125\n712#2,4:126\n*S KotlinDebug\n*F\n+ 1 GradleCommandLineOptionParser.kt\norg/jetbrains/plugins/gradle/util/cmd/GradleCommandLineOptionParser\n*L\n17#1:120\n17#1:121,4\n20#1:125\n20#1:126,4\n*E\n"})
public class GradleCommandLineOptionParser {
    @NotNull
    private final Collection<Option> options;
    @NotNull
    private final GradleCommandLineTokenizer tokenizer;
    @NotNull
    private final Map<String, Option> optionIndex;

    public GradleCommandLineOptionParser(@NotNull Collection<? extends Option> options, @NotNull GradleCommandLineTokenizer tokenizer) {
        Map map;
        Option it;
        Map map2;
        Sequence $this$associateByTo$iv$iv;
        Sequence $this$associateBy$iv;
        Intrinsics.checkNotNullParameter(options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)tokenizer, (String)"tokenizer");
        this.options = options;
        this.tokenizer = tokenizer;
        Sequence sequence = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)this.options), GradleCommandLineOptionParser::optionIndex$lambda$0);
        GradleCommandLineOptionParser gradleCommandLineOptionParser = this;
        boolean $i$f$associateBy = false;
        void var5_6 = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            Option option = (Option)element$iv$iv;
            map2 = destination$iv$iv;
            boolean bl = false;
            map2.put("-" + it.getOpt(), element$iv$iv);
        }
        $this$associateBy$iv = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)this.options), GradleCommandLineOptionParser::optionIndex$lambda$2);
        map2 = destination$iv$iv;
        $i$f$associateBy = false;
        $this$associateByTo$iv$iv = $this$associateBy$iv;
        destination$iv$iv = new LinkedHashMap();
        $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            it = (Option)element$iv$iv;
            map = destination$iv$iv;
            boolean bl = false;
            map.put("--" + it.getLongOpt(), element$iv$iv);
        }
        map = destination$iv$iv;
        gradleCommandLineOptionParser.optionIndex = MapsKt.plus((Map)map2, (Map)map);
    }

    @Nullable
    protected Option getOption(@NotNull String token) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        return this.optionIndex.get(token);
    }

    @Nullable
    public final GradleCommandLineOption tryParseOption() {
        int marker = this.tokenizer.mark();
        GradleCommandLineOption.PropertyNotation propertyNotation = this.tryParsePropertyNotation();
        if (propertyNotation != null) {
            return propertyNotation;
        }
        this.tokenizer.rollback(marker);
        GradleCommandLineOption.ShortNotation shortOption = this.tryParseShortNotation();
        if (shortOption != null) {
            return shortOption;
        }
        this.tokenizer.rollback(marker);
        GradleCommandLineOption.LongNotation longOption = this.tryParseLongNotation();
        if (longOption != null) {
            return longOption;
        }
        this.tokenizer.rollback(marker);
        GradleCommandLineOption.VarargNotation option = this.tryParseVarargNotation();
        if (option != null) {
            return option;
        }
        this.tokenizer.rollback(marker);
        return null;
    }

    private final GradleCommandLineOption.PropertyNotation tryParsePropertyNotation() {
        String token = this.tokenizer.expected();
        for (Option option : this.options) {
            String string = option.getOpt();
            if (string == null) continue;
            String optionName = "-" + string;
            if (option.getArgs() != 1 || Intrinsics.areEqual((Object)token, (Object)optionName) || !StringsKt.startsWith$default((String)token, (String)optionName, (boolean)false, (int)2, null)) continue;
            String value = StringsKt.removePrefix((String)token, (CharSequence)optionName);
            Pair<String, String> pair = this.parsePropertyOrNull(value);
            if (pair == null) continue;
            Pair<String, String> pair2 = pair;
            String propertyName = (String)pair2.component1();
            String propertyValue = (String)pair2.component2();
            return new GradleCommandLineOption.PropertyNotation(optionName, propertyName, propertyValue);
        }
        return null;
    }

    private final GradleCommandLineOption.ShortNotation tryParseShortNotation() {
        String token = this.tokenizer.expected();
        for (Option option : this.options) {
            String string = option.getOpt();
            if (string == null) continue;
            String optionName = "-" + string;
            if (option.getArgs() != 1 || Intrinsics.areEqual((Object)token, (Object)optionName) || !StringsKt.startsWith$default((String)token, (String)optionName, (boolean)false, (int)2, null)) continue;
            String value = StringsKt.removePrefix((String)token, (CharSequence)optionName);
            return new GradleCommandLineOption.ShortNotation(optionName, value);
        }
        return null;
    }

    private final GradleCommandLineOption.LongNotation tryParseLongNotation() {
        String token = this.tokenizer.expected();
        if (!StringsKt.startsWith$default((String)token, (String)"--", (boolean)false, (int)2, null)) {
            return null;
        }
        Pair<String, String> pair = this.parsePropertyOrNull(token);
        if (pair == null) {
            return null;
        }
        Pair<String, String> pair2 = pair;
        String name = (String)pair2.component1();
        String value = (String)pair2.component2();
        Option option = this.getOption(name);
        if (option == null) {
            return null;
        }
        Option option2 = option;
        if (option2.getArgs() != 1 || !StringsKt.startsWith$default((String)token, (String)(name + "="), (boolean)false, (int)2, null)) {
            return null;
        }
        return new GradleCommandLineOption.LongNotation(name, value);
    }

    private final GradleCommandLineOption.VarargNotation tryParseVarargNotation() {
        String token = this.tokenizer.expected();
        Option option = this.getOption(token);
        if (option == null) {
            return null;
        }
        Option option2 = option;
        ArrayList<String> values = new ArrayList<String>();
        switch (option2.getArgs()) {
            case -1: {
                break;
            }
            case -2: {
                while (!this.tokenizer.isEof()) {
                    String optionValue = this.tokenizer.expected();
                    values.add(optionValue);
                }
                break;
            }
            default: {
                int n = option2.getArgs();
                for (int i = 0; i < n; ++i) {
                    int it = i;
                    boolean bl = false;
                    if (this.tokenizer.isEof()) continue;
                    String optionValue = this.tokenizer.expected();
                    values.add(optionValue);
                }
            }
        }
        return new GradleCommandLineOption.VarargNotation(token, (List<String>)values);
    }

    private final Pair<String, String> parsePropertyOrNull(String token) {
        if (!StringsKt.contains$default((CharSequence)token, (char)'=', (boolean)false, (int)2, null)) {
            return null;
        }
        String name = StringsKt.substringBefore$default((String)token, (char)'=', null, (int)2, null);
        String value = StringsKt.substringAfter$default((String)token, (char)'=', null, (int)2, null);
        if (StringsKt.contains$default((CharSequence)name, (char)'\"', (boolean)false, (int)2, null)) {
            return null;
        }
        if (StringsKt.contains$default((CharSequence)name, (char)'\'', (boolean)false, (int)2, null)) {
            return null;
        }
        return TuplesKt.to((Object)name, (Object)value);
    }

    private static final boolean optionIndex$lambda$0(Option it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getOpt() != null;
    }

    private static final boolean optionIndex$lambda$2(Option it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getLongOpt() != null;
    }
}

