/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.issue;

import com.intellij.build.issue.BuildIssueQuickFix;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.project.Project;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.issue.GradleJVMIssuePatternMatcher;
import org.jetbrains.plugins.gradle.issue.UnresolvedDependencyIssue;
import org.jetbrains.plugins.gradle.issue.UnresolvedDependencyIssueKt;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.util.GradleBundle;
import org.jetbrains.plugins.gradle.util.GradleConstants;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0087\b\u0018\u00002\u00020\u0001:\u0001\u0017B7\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\t\u0010\nJ\t\u0010\u000b\u001a\u00020\u0003H\u00c2\u0003J\u000b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u00c2\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c2\u0003J\t\u0010\u000e\u001a\u00020\u0007H\u00c2\u0003J\u000b\u0010\u000f\u001a\u0004\u0018\u00010\u0003H\u00c2\u0003J?\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00072\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0003H\u00d6\u0001R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/plugins/gradle/issue/UnresolvedDependencySyncIssue;", "Lorg/jetbrains/plugins/gradle/issue/UnresolvedDependencyIssue;", "dependencyName", "", "failureMessage", "projectPath", "isOfflineMode", "", "dependencyOwner", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ZLjava/lang/String;)V", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "", "hashCode", "", "toString", "DisableOfflineAndReimport", "intellij.gradle"})
@ApiStatus.Experimental
public final class UnresolvedDependencySyncIssue
extends UnresolvedDependencyIssue {
    @NotNull
    private final String dependencyName;
    @Nullable
    private final String failureMessage;
    @NotNull
    private final String projectPath;
    private final boolean isOfflineMode;
    @Nullable
    private final String dependencyOwner;

    @JvmOverloads
    public UnresolvedDependencySyncIssue(@NotNull String dependencyName, @Nullable String failureMessage, @NotNull String projectPath, boolean isOfflineMode, @Nullable String dependencyOwner) {
        Intrinsics.checkNotNullParameter((Object)dependencyName, (String)"dependencyName");
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        super(dependencyName, dependencyOwner);
        this.dependencyName = dependencyName;
        this.failureMessage = failureMessage;
        this.projectPath = projectPath;
        this.isOfflineMode = isOfflineMode;
        this.dependencyOwner = dependencyOwner;
        GradleJVMIssuePatternMatcher.GradleJVMIssueMatchResult jvmIssueInfo = GradleJVMIssuePatternMatcher.INSTANCE.analyzeFailureMessage(this.failureMessage);
        Object object = jvmIssueInfo;
        if (object == null || (object = ((GradleJVMIssuePatternMatcher.GradleJVMIssueMatchResult)object).getCleanedMessage()) == null) {
            object = this.failureMessage;
        }
        Object cleanedMessage = object;
        this.addDescription(this.buildDescription((String)cleanedMessage));
        Object[] objectArray = new Object[]{"disable_offline_mode"};
        String string = GradleBundle.message("gradle.build.quick.fix.disable.offline.mode.reload", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        GradleJVMIssuePatternMatcher.GradleJVMIssueMatchResult gradleJVMIssueMatchResult = jvmIssueInfo;
        this.configureQuickFix((String)cleanedMessage, this.isOfflineMode, string, this.projectPath, gradleJVMIssueMatchResult != null ? Integer.valueOf(gradleJVMIssueMatchResult.getRequiredJvmVersion()) : null);
        if (this.isOfflineMode) {
            this.addQuickFix(new DisableOfflineAndReimport(this.projectPath));
        }
    }

    public /* synthetic */ UnresolvedDependencySyncIssue(String string, String string2, String string3, boolean bl, String string4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            string4 = null;
        }
        this(string, string2, string3, bl, string4);
    }

    private final String component1() {
        return this.dependencyName;
    }

    private final String component2() {
        return this.failureMessage;
    }

    private final String component3() {
        return this.projectPath;
    }

    private final boolean component4() {
        return this.isOfflineMode;
    }

    private final String component5() {
        return this.dependencyOwner;
    }

    @NotNull
    public final UnresolvedDependencySyncIssue copy(@NotNull String dependencyName, @Nullable String failureMessage, @NotNull String projectPath, boolean isOfflineMode, @Nullable String dependencyOwner) {
        Intrinsics.checkNotNullParameter((Object)dependencyName, (String)"dependencyName");
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        return new UnresolvedDependencySyncIssue(dependencyName, failureMessage, projectPath, isOfflineMode, dependencyOwner);
    }

    public static /* synthetic */ UnresolvedDependencySyncIssue copy$default(UnresolvedDependencySyncIssue unresolvedDependencySyncIssue, String string, String string2, String string3, boolean bl, String string4, int n, Object object) {
        if ((n & 1) != 0) {
            string = unresolvedDependencySyncIssue.dependencyName;
        }
        if ((n & 2) != 0) {
            string2 = unresolvedDependencySyncIssue.failureMessage;
        }
        if ((n & 4) != 0) {
            string3 = unresolvedDependencySyncIssue.projectPath;
        }
        if ((n & 8) != 0) {
            bl = unresolvedDependencySyncIssue.isOfflineMode;
        }
        if ((n & 0x10) != 0) {
            string4 = unresolvedDependencySyncIssue.dependencyOwner;
        }
        return unresolvedDependencySyncIssue.copy(string, string2, string3, bl, string4);
    }

    @NotNull
    public String toString() {
        return "UnresolvedDependencySyncIssue(dependencyName=" + this.dependencyName + ", failureMessage=" + this.failureMessage + ", projectPath=" + this.projectPath + ", isOfflineMode=" + this.isOfflineMode + ", dependencyOwner=" + this.dependencyOwner + ")";
    }

    public int hashCode() {
        int result = this.dependencyName.hashCode();
        result = result * 31 + (this.failureMessage == null ? 0 : this.failureMessage.hashCode());
        result = result * 31 + this.projectPath.hashCode();
        result = result * 31 + Boolean.hashCode(this.isOfflineMode);
        result = result * 31 + (this.dependencyOwner == null ? 0 : this.dependencyOwner.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof UnresolvedDependencySyncIssue)) {
            return false;
        }
        UnresolvedDependencySyncIssue unresolvedDependencySyncIssue = (UnresolvedDependencySyncIssue)((Object)other);
        if (!Intrinsics.areEqual((Object)this.dependencyName, (Object)unresolvedDependencySyncIssue.dependencyName)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.failureMessage, (Object)unresolvedDependencySyncIssue.failureMessage)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.projectPath, (Object)unresolvedDependencySyncIssue.projectPath)) {
            return false;
        }
        if (this.isOfflineMode != unresolvedDependencySyncIssue.isOfflineMode) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.dependencyOwner, (Object)unresolvedDependencySyncIssue.dependencyOwner);
    }

    @JvmOverloads
    public UnresolvedDependencySyncIssue(@NotNull String dependencyName, @Nullable String failureMessage, @NotNull String projectPath, boolean isOfflineMode) {
        Intrinsics.checkNotNullParameter((Object)dependencyName, (String)"dependencyName");
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        this(dependencyName, failureMessage, projectPath, isOfflineMode, null, 16, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\t\u001a\u0006\u0012\u0002\b\u00030\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/plugins/gradle/issue/UnresolvedDependencySyncIssue$DisableOfflineAndReimport;", "Lcom/intellij/build/issue/BuildIssueQuickFix;", "projectPath", "", "<init>", "(Ljava/lang/String;)V", "id", "getId", "()Ljava/lang/String;", "runQuickFix", "Ljava/util/concurrent/CompletableFuture;", "project", "Lcom/intellij/openapi/project/Project;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "intellij.gradle"})
    public static final class DisableOfflineAndReimport
    implements BuildIssueQuickFix {
        @NotNull
        private final String projectPath;
        @NotNull
        private final String id;

        public DisableOfflineAndReimport(@NotNull String projectPath) {
            Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
            this.projectPath = projectPath;
            this.id = "disable_offline_mode";
        }

        @NotNull
        public String getId() {
            return this.id;
        }

        @NotNull
        public CompletableFuture<?> runQuickFix(@NotNull Project project, @NotNull DataContext dataContext) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
            GradleSettings.getInstance(project).setOfflineWork(false);
            CompletableFuture completableFuture = UnresolvedDependencyIssueKt.access$tryRerun(dataContext);
            if (completableFuture == null) {
                CompletableFuture completableFuture2 = ExternalSystemUtil.requestImport((Project)project, (String)this.projectPath, (ProjectSystemId)GradleConstants.SYSTEM_ID);
                completableFuture = completableFuture2;
                Intrinsics.checkNotNullExpressionValue((Object)completableFuture2, (String)"requestImport(...)");
            }
            return completableFuture;
        }
    }
}

