/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiParser;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.YAMLElementTypes;
import org.jetbrains.yaml.YAMLLanguage;
import org.jetbrains.yaml.lexer.YAMLFlexLexer;
import org.jetbrains.yaml.parser.YAMLParser;
import org.jetbrains.yaml.psi.impl.YAMLAliasImpl;
import org.jetbrains.yaml.psi.impl.YAMLAnchorImpl;
import org.jetbrains.yaml.psi.impl.YAMLArrayImpl;
import org.jetbrains.yaml.psi.impl.YAMLBlockMappingImpl;
import org.jetbrains.yaml.psi.impl.YAMLBlockSequenceImpl;
import org.jetbrains.yaml.psi.impl.YAMLCompoundValueImpl;
import org.jetbrains.yaml.psi.impl.YAMLDocumentImpl;
import org.jetbrains.yaml.psi.impl.YAMLFileImpl;
import org.jetbrains.yaml.psi.impl.YAMLHashImpl;
import org.jetbrains.yaml.psi.impl.YAMLKeyValueImpl;
import org.jetbrains.yaml.psi.impl.YAMLPlainTextImpl;
import org.jetbrains.yaml.psi.impl.YAMLPsiElementImpl;
import org.jetbrains.yaml.psi.impl.YAMLQuotedTextImpl;
import org.jetbrains.yaml.psi.impl.YAMLScalarListImpl;
import org.jetbrains.yaml.psi.impl.YAMLScalarTextImpl;
import org.jetbrains.yaml.psi.impl.YAMLSequenceItemImpl;

public class YAMLParserDefinition
implements ParserDefinition {
    public static final IFileElementType FILE = new IFileElementType((Language)YAMLLanguage.INSTANCE);

    @NotNull
    public Lexer createLexer(Project project) {
        return new YAMLFlexLexer();
    }

    @NotNull
    public PsiParser createParser(Project project) {
        return new YAMLParser();
    }

    @NotNull
    public IFileElementType getFileNodeType() {
        IFileElementType iFileElementType = FILE;
        if (iFileElementType == null) {
            YAMLParserDefinition.$$$reportNull$$$0(0);
        }
        return iFileElementType;
    }

    @NotNull
    public TokenSet getWhitespaceTokens() {
        TokenSet tokenSet = YAMLElementTypes.WHITESPACE_TOKENS;
        if (tokenSet == null) {
            YAMLParserDefinition.$$$reportNull$$$0(1);
        }
        return tokenSet;
    }

    @NotNull
    public TokenSet getCommentTokens() {
        TokenSet tokenSet = YAMLElementTypes.YAML_COMMENT_TOKENS;
        if (tokenSet == null) {
            YAMLParserDefinition.$$$reportNull$$$0(2);
        }
        return tokenSet;
    }

    @NotNull
    public TokenSet getStringLiteralElements() {
        TokenSet tokenSet = YAMLElementTypes.TEXT_SCALAR_ITEMS;
        if (tokenSet == null) {
            YAMLParserDefinition.$$$reportNull$$$0(3);
        }
        return tokenSet;
    }

    @NotNull
    public PsiElement createElement(ASTNode node) {
        IElementType type = node.getElementType();
        if (type == YAMLElementTypes.DOCUMENT) {
            return new YAMLDocumentImpl(node);
        }
        if (type == YAMLElementTypes.KEY_VALUE_PAIR) {
            return new YAMLKeyValueImpl(node);
        }
        if (type == YAMLElementTypes.COMPOUND_VALUE) {
            return new YAMLCompoundValueImpl(node);
        }
        if (type == YAMLElementTypes.SEQUENCE) {
            return new YAMLBlockSequenceImpl(node);
        }
        if (type == YAMLElementTypes.MAPPING) {
            return new YAMLBlockMappingImpl(node);
        }
        if (type == YAMLElementTypes.SEQUENCE_ITEM) {
            return new YAMLSequenceItemImpl(node);
        }
        if (type == YAMLElementTypes.HASH) {
            return new YAMLHashImpl(node);
        }
        if (type == YAMLElementTypes.ARRAY) {
            return new YAMLArrayImpl(node);
        }
        if (type == YAMLElementTypes.SCALAR_LIST_VALUE) {
            return new YAMLScalarListImpl(node);
        }
        if (type == YAMLElementTypes.SCALAR_TEXT_VALUE) {
            return new YAMLScalarTextImpl(node);
        }
        if (type == YAMLElementTypes.SCALAR_PLAIN_VALUE) {
            return new YAMLPlainTextImpl(node);
        }
        if (type == YAMLElementTypes.SCALAR_QUOTED_STRING) {
            return new YAMLQuotedTextImpl(node);
        }
        if (type == YAMLElementTypes.ANCHOR_NODE) {
            return new YAMLAnchorImpl(node);
        }
        if (type == YAMLElementTypes.ALIAS_NODE) {
            return new YAMLAliasImpl(node);
        }
        return new YAMLPsiElementImpl(node);
    }

    @NotNull
    public PsiFile createFile(@NotNull FileViewProvider viewProvider) {
        if (viewProvider == null) {
            YAMLParserDefinition.$$$reportNull$$$0(4);
        }
        return new YAMLFileImpl(viewProvider);
    }

    @NotNull
    public ParserDefinition.SpaceRequirements spaceExistenceTypeBetweenTokens(ASTNode left, ASTNode right) {
        ParserDefinition.SpaceRequirements spaceRequirements = ParserDefinition.SpaceRequirements.MAY;
        if (spaceRequirements == null) {
            YAMLParserDefinition.$$$reportNull$$$0(5);
        }
        return spaceRequirements;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/yaml/YAMLParserDefinition";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileNodeType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getWhitespaceTokens";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommentTokens";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringLiteralElements";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/yaml/YAMLParserDefinition";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "spaceExistenceTypeBetweenTokens";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 4 -> new IllegalArgumentException(string);
        };
    }
}

