/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal.invokers;

import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.testng.ClassMethodMap;
import org.testng.IClassListener;
import org.testng.IMethodInstance;
import org.testng.ITestClass;
import org.testng.ITestContext;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.collections.Lists;
import org.testng.collections.Sets;
import org.testng.internal.ConfigurationGroupMethods;
import org.testng.internal.ITestClassConfigInfo;
import org.testng.internal.RuntimeBehavior;
import org.testng.internal.TestMethodComparator;
import org.testng.internal.invokers.ConfigMethodArguments;
import org.testng.internal.invokers.IConfigInvoker;
import org.testng.internal.invokers.ITestInvoker;
import org.testng.thread.IWorker;

public class TestMethodWorker
implements IWorker<ITestNGMethod> {
    private final List<IMethodInstance> m_methodInstances;
    private final Map<String, String> m_parameters;
    private final List<ITestResult> m_testResults = Lists.newArrayList();
    private final ConfigurationGroupMethods m_groupMethods;
    private final ClassMethodMap m_classMethodMap;
    private final ITestContext m_testContext;
    private final List<IClassListener> m_listeners;
    private long currentThreadId;
    private long threadIdToRunOn = -1L;
    private boolean completed = true;
    private final ITestInvoker m_testInvoker;
    private final IConfigInvoker m_configInvoker;

    public TestMethodWorker(ITestInvoker testInvoker, IConfigInvoker configInvoker, List<IMethodInstance> testMethods, Map<String, String> parameters, ConfigurationGroupMethods groupMethods, ClassMethodMap classMethodMap, ITestContext testContext, List<IClassListener> listeners) {
        this.m_testInvoker = testInvoker;
        this.m_configInvoker = configInvoker;
        this.m_methodInstances = testMethods;
        this.m_parameters = parameters;
        this.m_groupMethods = groupMethods;
        this.m_classMethodMap = classMethodMap;
        this.m_testContext = testContext;
        this.m_listeners = listeners;
    }

    @Override
    public long getTimeOut() {
        long result = 0L;
        for (IMethodInstance mi : this.m_methodInstances) {
            ITestNGMethod tm = mi.getMethod();
            if (tm.getTimeOut() <= result) continue;
            result = tm.getTimeOut();
        }
        return result;
    }

    public String toString() {
        StringBuilder result = new StringBuilder("[Worker thread:" + Thread.currentThread().getId() + " priority:" + this.getPriority() + " ");
        for (IMethodInstance m : this.m_methodInstances) {
            result.append(m.getMethod()).append(" ");
        }
        result.append("]");
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.currentThreadId = Thread.currentThread().getId();
        if (RuntimeBehavior.enforceThreadAffinity() && this.doesTaskHavePreRequisites() && this.currentThreadId != this.threadIdToRunOn) {
            this.completed = false;
            return;
        }
        for (IMethodInstance testMethodInstance : this.m_methodInstances) {
            Object object;
            ITestNGMethod testMethod = testMethodInstance.getMethod();
            if (this.canInvokeBeforeClassMethods()) {
                object = testMethod.getInstance();
                synchronized (object) {
                    this.invokeBeforeClassMethods(testMethod.getTestClass(), testMethodInstance);
                }
            }
            try {
                this.invokeTestMethods(testMethod, testMethodInstance.getInstance());
            }
            finally {
                object = testMethod.getInstance();
                synchronized (object) {
                    this.invokeAfterClassMethods(testMethod.getTestClass(), testMethodInstance);
                }
            }
        }
    }

    private boolean doesTaskHavePreRequisites() {
        return this.threadIdToRunOn != -1L;
    }

    protected void invokeTestMethods(ITestNGMethod tm, Object instance) {
        List<ITestResult> testResults = this.m_testInvoker.invokeTestMethods(tm, this.m_groupMethods, instance, this.m_testContext);
        if (testResults != null) {
            this.m_testResults.addAll(testResults);
        }
    }

    private boolean canInvokeBeforeClassMethods() {
        return this.m_classMethodMap != null;
    }

    protected void invokeBeforeClassMethods(ITestClass testClass, IMethodInstance mi) {
        Object instance;
        Map<ITestClass, Set<Object>> invokedBeforeClassMethods = this.m_classMethodMap.getInvokedBeforeClassMethods();
        Set instances = invokedBeforeClassMethods.computeIfAbsent(testClass, key -> Sets.newHashSet());
        if (!instances.contains(instance = mi.getInstance())) {
            instances.add(instance);
            for (IClassListener listener : this.m_listeners) {
                listener.onBeforeClass(testClass);
            }
            ConfigMethodArguments attributes = new ConfigMethodArguments.Builder().forTestClass(testClass).usingConfigMethodsAs(((ITestClassConfigInfo)((Object)testClass)).getInstanceBeforeClassMethods(instance)).forSuite(this.m_testContext.getSuite().getXmlSuite()).usingParameters(this.m_parameters).usingInstance(instance).build();
            this.m_configInvoker.invokeConfigurations(attributes);
        }
    }

    protected void invokeAfterClassMethods(ITestClass testClass, IMethodInstance mi) {
        Object inst;
        if (this.m_classMethodMap == null) {
            return;
        }
        List<Object> invokeInstances = Lists.newArrayList();
        ITestNGMethod tm = mi.getMethod();
        boolean removalSuccessful = this.m_classMethodMap.removeAndCheckIfLast(tm, mi.getInstance());
        if (!removalSuccessful) {
            return;
        }
        Map<ITestClass, Set<Object>> invokedAfterClassMethods = this.m_classMethodMap.getInvokedAfterClassMethods();
        Set instances = invokedAfterClassMethods.computeIfAbsent(testClass, key -> Sets.newHashSet());
        if (!instances.contains(inst = mi.getInstance())) {
            invokeInstances.add(inst);
        }
        if (RuntimeBehavior.useSymmetricListenerExecution()) {
            this.invokeAfterClassConfigurations(testClass, invokeInstances);
            this.invokeListenersOnAfterClass(testClass, this.m_listeners);
        } else {
            this.invokeListenersOnAfterClass(testClass, this.m_listeners);
            this.invokeAfterClassConfigurations(testClass, invokeInstances);
        }
    }

    private void invokeAfterClassConfigurations(ITestClass testClass, List<Object> invokeInstances) {
        for (Object invokeInstance : invokeInstances) {
            ConfigMethodArguments attributes = new ConfigMethodArguments.Builder().forTestClass(testClass).usingConfigMethodsAs(testClass.getAfterClassMethods()).forSuite(this.m_testContext.getSuite().getXmlSuite()).usingParameters(this.m_parameters).usingInstance(invokeInstance).build();
            this.m_configInvoker.invokeConfigurations(attributes);
        }
    }

    private void invokeListenersOnAfterClass(ITestClass testClass, List<IClassListener> listeners) {
        for (IClassListener listener : listeners) {
            listener.onAfterClass(testClass);
        }
    }

    protected int indexOf(ITestNGMethod tm, ITestNGMethod[] allTestMethods) {
        for (int i = 0; i < allTestMethods.length; ++i) {
            if (allTestMethods[i] != tm) continue;
            return i;
        }
        return -1;
    }

    public List<ITestResult> getTestResults() {
        return this.m_testResults;
    }

    @Override
    public List<ITestNGMethod> getTasks() {
        List<ITestNGMethod> result = Lists.newArrayList();
        for (IMethodInstance m : this.m_methodInstances) {
            result.add(m.getMethod());
        }
        return result;
    }

    @Override
    public int compareTo(@Nonnull IWorker<ITestNGMethod> other) {
        if (this.m_methodInstances.isEmpty()) {
            return 0;
        }
        List<ITestNGMethod> otherTasks = other.getTasks();
        if (otherTasks.isEmpty()) {
            return 0;
        }
        return TestMethodComparator.compareStatic(this.m_methodInstances.get(0).getMethod(), otherTasks.get(0));
    }

    @Override
    public int getPriority() {
        return this.m_methodInstances.size() > 0 ? this.m_methodInstances.get(0).getMethod().getPriority() : 0;
    }

    @Override
    public long getCurrentThreadId() {
        return this.currentThreadId;
    }

    @Override
    public void setThreadIdToRunOn(long threadIdToRunOn) {
        this.threadIdToRunOn = threadIdToRunOn;
    }

    @Override
    public boolean completed() {
        return this.completed;
    }
}

