/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Spliterators;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.testng.collections.Lists;
import org.testng.internal.ClassHelper;
import org.testng.internal.RuntimeBehavior;
import org.testng.internal.Utils;
import org.testng.internal.protocols.Input;
import org.testng.internal.protocols.Processor;
import org.testng.internal.protocols.UnhandledIOException;

public class PackageUtils {
    private static String[] testClassPaths;
    private static final Collection<ClassLoader> classLoaders;

    private PackageUtils() {
    }

    public static String[] findClassesInPackage(String packageName, List<String> included, List<String> excluded) throws IOException {
        String packageNameWithoutWildCards = packageName;
        boolean recursive = packageName.endsWith(".*");
        if (recursive) {
            packageNameWithoutWildCards = packageName.substring(0, packageName.lastIndexOf(".*"));
        }
        String packageDirName = packageNameWithoutWildCards.replace('.', '/') + (packageNameWithoutWildCards.length() > 0 ? "/" : "");
        Input input = Input.Builder.newBuilder().forPackageWithoutWildCards(packageNameWithoutWildCards).withRecursive(recursive).include(included).exclude(excluded).withPackageName(packageName).forPackageDirectory(packageDirName).build();
        List<ClassLoader> allClassLoaders = ClassHelper.appendContextualClassLoaders(Lists.newArrayList(classLoaders));
        return (String[])allClassLoaders.stream().filter(Objects::nonNull).flatMap(PackageUtils.asURLs(packageDirName)).filter(url -> PackageUtils.matchTestClasspath(url, packageDirName, recursive)).flatMap(url -> Processor.newInstance(url.getProtocol()).process(input, (URL)url).stream()).toArray(String[]::new);
    }

    private static String[] getTestClasspath() {
        if (null != testClassPaths) {
            return testClassPaths;
        }
        String testClasspath = RuntimeBehavior.getTestClasspath();
        if (null == testClasspath) {
            return null;
        }
        String[] classpathFragments = Utils.split(testClasspath, File.pathSeparator);
        testClassPaths = new String[classpathFragments.length];
        for (int i = 0; i < classpathFragments.length; ++i) {
            Object path = classpathFragments[i].toLowerCase().endsWith(".jar") || classpathFragments[i].toLowerCase().endsWith(".zip") ? classpathFragments[i] + "!/" : (classpathFragments[i].endsWith(File.separator) ? classpathFragments[i] : classpathFragments[i] + "/");
            PackageUtils.testClassPaths[i] = ((String)path).replace('\\', '/');
        }
        return testClassPaths;
    }

    private static Function<ClassLoader, Stream<URL>> asURLs(String packageDir) {
        return cl -> {
            try {
                Iterator<URL> iterator = cl.getResources(packageDir).asIterator();
                return StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 16), false);
            }
            catch (IOException e) {
                throw new UnhandledIOException(e);
            }
        };
    }

    private static boolean matchTestClasspath(URL url, String lastFragment, boolean recursive) {
        String[] classpathFragments = PackageUtils.getTestClasspath();
        if (null == classpathFragments) {
            return true;
        }
        String fileName = URLDecoder.decode(url.getFile(), StandardCharsets.UTF_8);
        for (String classpathFrag : classpathFragments) {
            String path = classpathFrag + lastFragment;
            int idx = fileName.indexOf(path);
            if (idx == -1 || idx > 0 && fileName.charAt(idx - 1) != '/' || !fileName.endsWith(classpathFrag + lastFragment) && (!recursive || fileName.charAt(idx + path.length()) != '/')) continue;
            return true;
        }
        return false;
    }

    static {
        classLoaders = new ConcurrentLinkedDeque<ClassLoader>();
    }
}

