/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.vale;

import ai.grazie.rules.util.CharUtil;
import ai.grazie.rules.util.YamlParsingUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Pattern;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.languagetool.AnalyzedSentence;
import org.languagetool.JLanguageTool;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.ScalarNode;

public abstract class YamlBasedRule {
    private static final Set<String> trimActions = Set.of("trim", "trim_right", "trim_left");
    public final MetaData meta;
    public final int line;
    public final int column;

    YamlBasedRule(MetaData meta, Node anchorNode) {
        this.meta = meta;
        this.line = anchorNode.getStartMark().getLine();
        this.column = anchorNode.getStartMark().getColumn();
    }

    public abstract List<RuleMatch> check(String var1);

    static List<RuleMatch> checkAnalyzedSentences(JLanguageTool lt, String text, Function<AnalyzedSentence, List<RuleMatch>> checkSentence) {
        List sentences = lt.sentenceTokenize(text);
        ArrayList<RuleMatch> result = new ArrayList<RuleMatch>();
        int offset = 0;
        try {
            for (String sentence : sentences) {
                AnalyzedSentence analyzed = lt.getAnalyzedSentence(sentence);
                for (RuleMatch m : checkSentence.apply(analyzed)) {
                    result.add(new RuleMatch(m.start() + offset, m.end() + offset, m.message(), m.suggestions()));
                }
                offset += sentence.length();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    public String toString() {
        return this.meta.filePath + ":" + this.line + ":" + this.column + (String)(this.meta.description == null ? "" : ":" + this.meta.description);
    }

    private static Function<String, List<String>> actionSuggester(Node actionNode) {
        if (actionNode instanceof MappingNode) {
            Map<String, Node> actionMap = YamlParsingUtil.asMap((MappingNode)actionNode);
            String name = YamlParsingUtil.asScalar(actionMap.get("name"));
            Node paramsNode = actionMap.get("params");
            List<String> params = YamlParsingUtil.getStrings(paramsNode);
            if ("replace".equals(name)) {
                return s -> params;
            }
            if ("remove".equals(name)) {
                return s -> List.of("");
            }
            if ("convert".equals(name)) {
                return s -> List.of(s.toLowerCase(Locale.ROOT).trim().replaceAll("\\W+", " "));
            }
            if ("edit".equals(name)) {
                String kind = params.get(0);
                if ("regex".equals(kind) && params.size() == 3) {
                    Pattern pattern = Pattern.compile(params.get(1));
                    String dst = params.get(2);
                    if (dst != null) {
                        return s -> List.of(pattern.matcher((CharSequence)s).replaceAll(dst));
                    }
                } else {
                    if (trimActions.contains(kind) && params.size() == 2) {
                        String chars = params.get(1);
                        return s -> YamlBasedRule.trimChars(chars, s, kind);
                    }
                    if ("split".equals(kind) && params.size() == 3) {
                        int index = Integer.parseInt(params.get(2));
                        String separator = params.get(1);
                        return s -> {
                            String[] split = s.split(separator);
                            return index < split.length ? List.of(split[index]) : List.of();
                        };
                    }
                }
            }
        }
        return s -> List.of();
    }

    private static List<String> trimChars(String chars, String s, String kind) {
        int start;
        int end = s.length();
        if (!"trim_right".equals(kind)) {
            for (start = 0; start < end && CharUtil.isAnyOf(chars, s.charAt(start)); ++start) {
            }
        }
        if (!"trim_left".equals(kind)) {
            while (start < end - 1 && CharUtil.isAnyOf(chars, s.charAt(end - 1))) {
                --end;
            }
        }
        return List.of(s.substring(start, end));
    }

    public static class MetaData {
        @NotNull
        public final String filePath;
        @Nullable
        public final String description;
        @Nullable
        public final String link;
        @NotNull
        public final List<String> ruleScopes;
        @Nullable
        public final Level level;
        @NotNull
        final Function<String, List<String>> suggester;

        MetaData(@NotNull String filePath, Map<String, Node> asMap) {
            this.filePath = filePath;
            this.description = YamlParsingUtil.asScalar(asMap.get("description"));
            this.link = YamlParsingUtil.asScalar(asMap.get("link"));
            Node scope = asMap.get("scope");
            this.ruleScopes = scope instanceof ScalarNode ? List.of(((ScalarNode)scope).getValue()) : Collections.unmodifiableList(YamlParsingUtil.getStrings(scope));
            String level = YamlParsingUtil.asScalar(asMap.get("level"));
            this.level = StreamEx.of((Object[])Level.values()).findFirst(l -> l.name().equals(level)).orElse(null);
            this.suggester = YamlBasedRule.actionSuggester(asMap.get("action"));
        }
    }

    public record RuleMatch(int start, int end, String message, List<String> suggestions) {
        public static RuleMatch fromLT(org.languagetool.rules.RuleMatch lt, MetaData meta) {
            int start = lt.getFromPos();
            int end = lt.getToPos();
            List replacements = StreamEx.of((Collection)meta.suggester.apply(lt.getSentence().getText().substring(start, end))).append((Collection)lt.getSuggestedReplacements()).toList();
            return new RuleMatch(start, end, lt.getMessage(), replacements);
        }

        @Override
        public String toString() {
            return this.start + ":" + this.end + ":" + this.message + ":" + String.valueOf(this.suggestions);
        }
    }

    public static enum Level {
        error,
        warning,
        suggestion;

    }

    public static abstract class WholeFileRule
    extends YamlBasedRule {
        public WholeFileRule(MetaData meta, Node anchorNode) {
            super(meta, anchorNode);
        }

        @Override
        public List<RuleMatch> check(String text) {
            return this.checkFile(List.of(text)).get(text);
        }

        public abstract Map<String, List<RuleMatch>> checkFile(List<String> var1);
    }
}

