/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.tree;

import ai.grazie.nlp.langs.Language;
import ai.grazie.rules.tree.Node;
import ai.grazie.rules.tree.NodeMatch;
import ai.grazie.rules.tree.NodePattern;
import ai.grazie.rules.tree.PatternSet;
import ai.grazie.rules.tree.Tree;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import kotlin.Pair;
import one.util.streamex.IntStreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class CrazyParseDetector {
    private static final boolean TRACK_USED_PATTERNS = false;
    private final PatternSet wrongParsePatterns;
    private final Set<Integer> used = Collections.synchronizedSet(new HashSet());
    private final int count;
    private final NodePattern[] patterns;

    public CrazyParseDetector(Language language, NodePattern ... wrongParsePatterns) {
        List ids = IntStreamEx.range((int)wrongParsePatterns.length).mapToObj(i -> "CrazyParse" + i).toList();
        this.wrongParsePatterns = new PatternSet(IntStreamEx.range((int)wrongParsePatterns.length).mapToObj(i -> wrongParsePatterns[i].costCenter((String)ids.get(i))).toList(), ids);
        this.count = wrongParsePatterns.length;
        this.patterns = wrongParsePatterns;
    }

    private void printUnusedPatterns(Language language, NodePattern[] wrongParsePatterns) {
        ArrayList<CallSite> unused = new ArrayList<CallSite>();
        for (int i = 0; i < wrongParsePatterns.length; ++i) {
            if (this.used.contains(i)) continue;
            unused.add((CallSite)((Object)(i + ": " + String.valueOf(wrongParsePatterns[i]))));
        }
        if (!unused.isEmpty()) {
            System.out.println(String.valueOf(language) + " has unused crazy-parse patterns:\n" + String.join((CharSequence)"\n", unused));
        }
    }

    @NotNull
    public CrazyParses findCrazyParses(Tree tree) {
        LinkedHashMap<Integer, Entry> map = new LinkedHashMap<Integer, Entry>();
        for (PatternSet.IndexedMatch<NodeMatch> match : this.wrongParsePatterns.matchTree(tree)) {
            if (match.match().preventedBy != null) continue;
            String message = match.match().message();
            if (message == null) {
                throw new IllegalStateException("The crazy parse " + match.index() + "/" + (this.count - 1) + " has no message: " + String.valueOf(this.patterns[match.index()]));
            }
            for (Node touched : match.match().allTouchedNodes()) {
                map.putIfAbsent(touched.index, new Entry(message, match.index()));
            }
        }
        return new CrazyParses(this, map);
    }

    private /* synthetic */ void lambda$new$2(Language language, NodePattern[] wrongParsePatterns) {
        this.printUnusedPatterns(language, wrongParsePatterns);
    }

    private record Entry(String message, int index) {
    }

    public class CrazyParses {
        final LinkedHashMap<Integer, Entry> map;

        CrazyParses(CrazyParseDetector this$0, LinkedHashMap<Integer, Entry> map) {
            this.map = map;
        }

        @Nullable
        public String getCrazyMessage(Node node) {
            Entry entry = this.map.get(node.index);
            if (entry == null) {
                return null;
            }
            return entry.message;
        }

        @TestOnly
        public List<Pair<Node, String>> entries(Tree tree) {
            return this.map.entrySet().stream().map(e -> new Pair((Object)tree.nodes().get((Integer)e.getKey()), (Object)((Entry)e.getValue()).message)).toList();
        }
    }
}

