/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.en;

import ai.grazie.rules.common.CommonPatterns;
import ai.grazie.rules.common.TreeMigration;
import ai.grazie.rules.en.AgreementSet;
import ai.grazie.rules.en.EnglishParameters;
import ai.grazie.rules.en.EnglishTreePatterns;
import ai.grazie.rules.en.EnglishValences;
import ai.grazie.rules.en.Number;
import ai.grazie.rules.en.PluralsInCompounds;
import ai.grazie.rules.en.Questions;
import ai.grazie.rules.en.Semantics;
import ai.grazie.rules.en.SemiModal;
import ai.grazie.rules.en.StyleRules;
import ai.grazie.rules.en.SubjectVerbAgreement;
import ai.grazie.rules.en.TenseChanges;
import ai.grazie.rules.en.ToggleContraction;
import ai.grazie.rules.en.VerbInflectionNumber;
import ai.grazie.rules.tree.Node;
import ai.grazie.rules.tree.NodeCorrector;
import ai.grazie.rules.tree.NodePattern;
import ai.grazie.rules.tree.NodePointer;
import ai.grazie.rules.tree.ReportingKind;
import one.util.streamex.StreamEx;

public class GrammarRules {
    private static final String CONDITIONAL_ISSUES_MESSAGE = "Consider using the present tense in a conditional clause";
    private static final String SECOND_CONDITIONAL_ISSUES_MESSAGE = "Consider using Past Simple in a hypothetical condition";
    private static final String THIRD_CONDITIONAL_ISSUES_MESSAGE = "Consider using Past Perfect in an expired condition";
    private static final String AUXILIARY_VERB_MISSING = "Is the auxiliary verb missing?";
    private static final String WHAT_WHICH_CONFUSION = "Use 'which' to refer to an option from a limited list";
    private static final String LETS_MESSAGE = "Did you mean \"let\u2019s\", as in \"let us\"?";
    public static final String WHAT_THAT_CONFUSION = "Avoid using 'what' as a relative pronoun in clauses that modify a noun or pronoun";
    private static final String FUTURE_IN_SUBORDINATE_MESSAGE = "In subordinate clauses, use present tense to refer to the future";
    private static final String DID_YOU_FORGET_THE_IT_SUBJECT = "Did you forget the 'it' subject?";
    private static final String HOW_WHAT_LOOK_LIKE_CONFUSION = "'Look like what' or 'look how'?";
    private static final String PHRASE_REPETITION_MSG = "Did you accidentally repeat a phrase?";
    private static final String THAT_WITH_PREPOSITION_MSG = "Use 'which' or move the preposition to the end of the relative clause";
    static final NodePattern withWill = NodePattern.N.withDependent("aux", NodePattern.N.lemma("will").noForm(".+d"));
    private static final String PAST_TENSE_SEQUENCE_MSG = "When the main verb has past tense, other verbs often also express a past viewpoint";
    private static final NodePattern noCommasInside = NodePattern.custom(n -> n.phraseStart().nextUntil(n.phraseEnd()).noneMatch(CommonPatterns.comma::matches));
    private static final String FORGET_SUBJECT_MSG = "Did you forget the subject?";
    private static final NodePattern diseaseLaw = NodePattern.N.lemma("disease|law").noLabel("PERSON");
    private static final NodePattern bornWhere = NodePattern.N.form("before|after|in|at|near|next");
    static final NodePattern endsWithS = NodePattern.N.form(".+s");
    static final NodePattern removePluralInProperName = NodePattern.custom((node, match) -> {
        String sgName = node.form().substring(0, node.form().length() - 1);
        if (!node.tree().treeSupport().tagToken(sgName).hasPos("NNP")) {
            return null;
        }
        return match.withCorrector(NodeCorrector.replace(node, sgName).join(NodeCorrector.insertAfter(node, "\u2019s")));
    });

    static NodePattern isBorn() {
        NodePattern withSpecificTimePlace = NodePattern.or(NodePattern.N.withDependent("obl", NodePattern.N.withDependent("case", bornWhere)), NodePattern.N.withDependent("advmod", NodePattern.or(NodePattern.N.inFormSequence(0, "far", "from"), bornWhere)));
        return NodePattern.N.form("born").withDependent("aux:pass", NodePattern.N.lemma("be").pos("VB[ZP]").markAs("Be")).withDependent("nsubj:pass", NodePattern.N.markAs("Subj")).and(withSpecificTimePlace).noDependents("obl:tmod", NodePattern.N.beforeHead()).includeIntoReport(ReportingKind.Hover).and(NodePattern.custom((born, match) -> {
            String past = VerbInflectionNumber.from(born, match.getMarkedNode("Subj")).past(true).inflectBe();
            Node be = match.getMarkedNode("Be");
            String space = EnglishTreePatterns.startsWithApostrophe.matches(be) ? " " : "";
            return match.withCorrector(NodeCorrector.replace(be, space + past)).withMessage("When talking about the past, use '" + past + " born'");
        }));
    }

    static NodePattern letsConfusion() {
        NodePattern vpStart = NodePattern.or(NodePattern.N.pos("VB"), NodePattern.N.pos("RB|DT").andOr(NodePattern.N.withHead(NodePattern.N.pos("VB")), NodePattern.N.withNextSibling(NodePattern.N.pos("VB").withHeadRelation("xcomp"))));
        NodePattern letUsContext = NodePattern.N.noDependents("nsubj(:pass|:outer)?|csubj(:pass)?").noDependents("cc", NodePattern.N.afterHead()).andNot(NodePattern.N.withHead("conj|appos", NodePattern.N.withDependent("nsubj(:pass|:outer)?|csubj(:pass)?"))).noHeadRelation("compound");
        return NodePattern.or(NodePattern.N.form("lets").and(letUsContext).directlyBefore(vpStart).correct(NodeCorrector.replace("let\u2019s")).message(LETS_MESSAGE), EnglishTreePatterns.letS.withNeighbor(2, NodePattern.N.form("us")).withNeighbor(3, vpStart).and(letUsContext).correct(NodeCorrector.replace(NodePointer.neighbor(1), "")).correct(NodeCorrector.replace(NodePointer.neighbor(2), "")).message(LETS_MESSAGE), EnglishTreePatterns.letS.reportEverythingTouched().andNot(NodePattern.N.directlyAfter(NodePattern.PUNCT)).withDependent("nsubj(:pass|:outer)?|csubj(:pass)?", NodePattern.custom(n -> SubjectVerbAgreement.subjectNumber(n, n.head()) == Number.singular).andNot(CommonPatterns.personMentionEnd)).correct(NodeCorrector.replaceNodes(NodePointer.anchor(), NodePointer.neighbor(1), "lets", "let")).message("Did you mean third-person singular \"lets\"?"));
    }

    static NodePattern repetition() {
        NodePattern allowedAsX = NodePattern.or(NodePattern.N.withNeighbor(3, NodePattern.N.withHeadRelation("amod")), NodePattern.N.withNeighbor(4, NodePattern.N.pos("VB.*|MD")));
        NodePattern allowedXAs = NodePattern.N.pos("JJ.*").withNeighbor(3, NodePattern.N.form("as").beforeHead().withHeadRelation("mark"));
        NodePattern javaParameter = NodePattern.N.formCaseSensitive("[a-z]+").directlyAfter(NodePattern.N.formCaseSensitive("[A-Z][a-z]*")).directlyBefore(NodePattern.or(CommonPatterns.comma, CommonPatterns.closingParen)).withNeighbor(-2, NodePattern.or(CommonPatterns.comma, CommonPatterns.openingParen));
        NodePattern excessiveThat = NodePattern.N.form("that").withHeadRelation("mark").directlyBefore(NodePattern.N.withHead("nsubj", NodePattern.N.withHeadRelation("acl:relcl").withDependent("obj")));
        NodePattern duplicateWord = NodePattern.or(NodePattern.N.withHeadRelation("dep|goeswith|punct"), NodePattern.N.directlyBeforeHead().withHeadRelation("compound"), NodePattern.N.directlyBefore(NodePattern.or(NodePattern.N.withHeadRelation("dep|aux.*"), NodePattern.N.directlyAfterHead().withHeadRelation("ccomp|xcomp|conj|parataxis|advcl"))), excessiveThat, NodePattern.N.pos("DT").withHeadRelation("case").directlyBefore(NodePattern.N.withHeadRelation("det")), NodePattern.N.pos("IN").andOr(NodePattern.N.withHead("obl.*", NodePattern.not(EnglishTreePatterns.withToMark)).directlyBefore(NodePattern.N.withHeadRelation("case")).andNot(NodePattern.N.noDependents().withHead("obl", NodePattern.N.withHeadRelation("acl:relcl"))), NodePattern.N.withHeadRelation("nmod").directlyBefore(NodePattern.N.withHeadRelation("mark"))));
        NodePattern excessiveTo = NodePattern.N.form("to").markAs("To1").directlyBefore(NodePattern.N.pos("RB").noPos("VB.*|NN.*").noForm("early|late|t?here").directlyBefore(NodePattern.N.form("to").markAs("To2").directlyBefore(NodePattern.N.pos("VB.*")))).andNot(NodePattern.N.withNeighbor(1, NodePattern.N.form("just")).and(CommonPatterns.afterSkipping(NodePattern.N.pos("PR.*"), NodePattern.N.pos("VB.*"))).trace("I had to just to avoid falling")).andNot(NodePattern.N.withNeighbor(1, CommonPatterns.skipUp("advmod", NodePattern.N.withHead("obl|advcl", NodePattern.N.form("set(ting)?")).trace("set x to y to do smth"))));
        return NodePattern.or(CommonPatterns.repeatedWord((n1, n2) -> n1.headRelation().equalsIgnoreCase(n2.headRelation()) || n1.headRelation().startsWith("det") && n2.headRelation().startsWith("det") || duplicateWord.matches((Node)n1)).noPos("CD").andNot(CommonPatterns.capitalizedMiddle).noPos("RB|UH").andNot(javaParameter).andNot(NodePattern.N.directlyBefore(EnglishTreePatterns.quotations)).andNot(NodePattern.N.withNeighbor(-2, EnglishTreePatterns.quotations)).andNot(NodePattern.N.directlyBefore(NodePattern.N.sameWordAs(1))).andNot(NodePattern.N.markAs("Second").directlyAfter(NodePattern.N.pos("WP").withDependent(".*:relcl", NodePattern.N.withDependent(".*", NodePattern.N.alreadyMarkedAs("Second"))))).andNot(NodePattern.N.form("that").withNextSibling(NodePattern.N.pos("NNP?").withHeadRelation("nsubj.*").noDependents("det|nmod:poss")).trace("say that that X is nice")).message("Did you accidentally repeat '$_'?"), CommonPatterns.repeatedPhrase().noPos("CC").andNot(NodePattern.N.directlyBefore(NodePattern.N.pos("CC"))).noPos("CD").andNot(NodePattern.N.form("as").and(allowedAsX)).andNot(allowedXAs).andNot(NodePattern.N.withNeighbor(2, NodePattern.N.withDependent("case"))).andNot(NodePattern.N.inFormSequence(0, "an?", ".*", "an?").directlyAfter(NodePattern.N.lemma("call"))).andNot(NodePattern.N.directlyAfter(NodePattern.N.form("if|when"))).andNot(NodePattern.N.directlyBefore(NodePattern.N.pos("VB.?")).andOr(NodePattern.N.withNeighbor(-2, NodePattern.N.form("every|any|no")), NodePattern.N.directlyAfter(NodePattern.N.form("(every|any|no).*")))).andNot(CommonPatterns.upperCase.directlyBefore(CommonPatterns.upperCase)).message(PHRASE_REPETITION_MSG), excessiveTo.correct(NodeCorrector.replace(NodePointer.marked("To1"), "")).correct(NodeCorrector.replace(NodePointer.marked("To2"), "")).message("Did you accidentally repeat 'to'?")).and((node, match) -> match.concedingToOtherGrammarCheckers());
    }

    static NodePattern missingSubject() {
        return NodePattern.or(StyleRules.looksSeemsSounds.noDependents("nsubj.*|expl").andNot(StyleRules.beforeLike).message(DID_YOU_FORGET_THE_IT_SUBJECT), NodePattern.N.pos("JJ.*").withDependent("cop", NodePattern.N.beforeHead().noDependents().withPrevSibling(NodePattern.N.withHeadRelation("obl|nsubj").withDependent("case", NodePattern.N.beforeHead().noForm("as|after").markAs("Prep")).noDependents("acl(:relcl)?|appos").noDependents("compound", NodePattern.or(NodePattern.N.before("Prep"), NodePattern.N.withNextSibling(NodePattern.N.withHeadRelation("amod")))).andNot(Questions.whPhrase).and(noCommasInside).markAs("Obl")).andOr(NodePattern.N.form("is|was").includeIntoReport().and(EnglishTreePatterns.ensureWordBefore("it")).message(DID_YOU_FORGET_THE_IT_SUBJECT), NodePattern.N.form("are|were").includeIntoReport().and(EnglishTreePatterns.ensureWordBefore("they")).message(FORGET_SUBJECT_MSG))).noDependents("nsubj(:pass|:outer)?|csubj(:pass)?|expl", NodePattern.not(NodePattern.N.alreadyMarkedAs("Obl")).andNot(NodePattern.N.afterHead().withHeadRelation("csubj"))).trace("missing cop subject after obl"), EnglishTreePatterns.withoutSubject.withDependent("aux", NodePattern.N.inFormSequence(1, "and|but", "['\u2019`\u2018](ll|ve|d)").noSpaceBefore().correct(NodeCorrector.insertBefore(" I")).correct(NodeCorrector.insertBefore(" we")).message(FORGET_SUBJECT_MSG))).noDependents(".*", NodePattern.N.beforeHead().andOr(EnglishTreePatterns.beforeAposOrQuote, EnglishTreePatterns.afterAposOrQuote));
    }

    static NodePattern missingObject() {
        NodePattern objMisparsedAsObl = NodePattern.N.withHeadRelation("obl").andOr(NodePattern.N.noDependents("case"), NodePattern.N.withDependent("case", NodePattern.N.afterHead()), NodePattern.N.withDependent("compound", NodePattern.N.markAs("Compound")).withDependent("case", NodePattern.N.after("Compound")));
        NodePattern couldBeObj = NodePattern.N.potentialPos("VBG|NN.*");
        NodePattern objMisparsedAsSubclause = NodePattern.N.noDependents(NodePattern.N.beforeHead().noHeadRelation("advmod")).andOr(couldBeObj, NodePattern.N.potentialPos("JJ|VBN").directlyBefore(couldBeObj));
        NodePattern objMisparsedAsPredicate = NodePattern.ROOT.withDependent("nsubj", NodePattern.N.directlyBeforeHead().potentialPos("VB.*"));
        NodePattern misparsedCcomp = Questions.whPhrase.withDependent("acl:relcl");
        NodePattern whObject = Questions.whPhrase.withHeadRelation("obj");
        NodePattern longDistanceObject = NodePattern.custom(n -> n.back().anyMatch(whObject::matches));
        NodePattern misparsedRelcl = NodePattern.N.withDependent("obl", NodePattern.N.beforeHead().pos("NN.*").withDependent("det"));
        NodePattern objInQuotes = NodePattern.or(NodePattern.N.withDependent("advmod|xcomp|ccomp", CommonPatterns.insideQuotes.afterHead()), NodePattern.N.withHeadRelation("ccomp").noDependents(NodePattern.N.afterHead()).withNextSibling(CommonPatterns.insideQuotes.afterHead()));
        NodePattern toTypo = NodePattern.N.form("[^t]?o").withHead(NodePattern.N.pos("VB"));
        NodePattern objListedLater = NodePattern.N.withDependent("mark", NodePattern.N.form("that").afterHead());
        return CommonPatterns.possiblyConj(NodePattern.or(NodePattern.N.withHeadRelation("ccomp|parataxis"), NodePattern.ROOT.noPos("NN.*").noPotentialPos("JJ|VBN"), NodePattern.N.withHead("xcomp", NodePattern.N.noPos("JJ.*|VBG")))).noDependents("nsubj:pass|aux:pass|cop|conj|i?obj|flat|goeswith|list").noDependents("obl", NodePattern.or(objMisparsedAsObl, misparsedCcomp)).noDependents("xcomp|ccomp|advcl", NodePattern.or(objMisparsedAsSubclause, NodePattern.N.withDependent("mark", CommonPatterns.firstChildPhrase.and(CommonPatterns.quotedWord)))).withDependent(".*", NodePattern.not(NodePattern.PUNCT)).andNot(objMisparsedAsPredicate).noPos("VBN").andNot(NodePattern.N.pos("VBG").noDependents("cop|aux|aux:pass")).andNot(NodePattern.N.withPrevSibling(Questions.whPhrase.withHeadRelation("i?obj"))).noHeadRelation("conj").andNot(NodePattern.N.withHeadRelation("xcomp").potentialPos("JJ.*")).noDependents("nsubj", Questions.whPhrase.pos("NNS?")).andNot(NodePattern.N.withPrevSibling(NodePattern.N.withHead("nsubj", NodePattern.N.withDependent("i?obj", Questions.whPhrase.pos("NNS?"))))).withOnlyDependents(NodePattern.N.pos(".*")).andNot(NodePattern.N.inPhrase(NodePattern.or(NodePattern.N.withHeadRelation("acl:relcl|advcl"), Questions.question))).andNot(NodePattern.N.directlyBefore(NodePattern.or(CommonPatterns.colon, NodePattern.N.form("all"), CommonPatterns.capitalizedMiddle, toTypo))).andNot(EnglishTreePatterns.withToMark.pos("VB").withHeadRelation("ccomp")).andNot(CommonPatterns.lastToken).andNot(SemiModal.possiblyModalNeed).and(EnglishValences::needsObject).andNot(EnglishTreePatterns.verbsMissingNounPosTags.andOr(CommonPatterns.firstWord.withDependent("nmod"), NodePattern.N.withDependent("amod"))).andNot(NodePattern.N.inFormSequence(0, "rename", "refactoring")).andNot(objInQuotes).andNot(longDistanceObject).andNot(misparsedRelcl).andNot(CommonPatterns.capitalizedMiddle).andNot(NodePattern.N.directlyAfter(NodePattern.N.form("#.*"))).andNot(objListedLater).includeIntoReport().correct(NodeCorrector.insertAfter(" it")).andOptionally(NodePattern.N.markAs("Verb").directlyBefore(NodePattern.N.withHead("case", NodePattern.N.pos("NN.*").noPos("RB.*").withHead("obl", NodePattern.N.alreadyMarkedAs("Verb"))).correct(NodeCorrector.replace("")))).message("Did you forget the object of '$_'?");
    }

    static NodePattern clauseNegation() {
        return NodePattern.N.form("not").includeIntoReport().withHead("advmod", NodePattern.N.pos("VB[ZDN]?").includeIntoReport().markAs("Verb").noLemma("be").noDependents("cop|aux|aux:pass", NodePattern.N).andOr(NodePattern.ROOT.withDependent("nsubj.*", NodePattern.N.markAs("Subj")), NodePattern.N.noDependents("nsubj(:pass|:outer)?|csubj(:pass)?").withHead("parataxis|acl", CommonPatterns.possiblySkipUp("obj", NodePattern.ROOT.potentialPos("NN").noDependents("nsubj.*|cop|det").andNot(EnglishTreePatterns.someAnyEveryNoX).markAs("Subj")))).andNot(NodePattern.N.form("found").directlyAfter(NodePattern.N.form("not").directlyAfter(NodePattern.N.markAs("Something"))).noDependents("nsubj", NodePattern.not(NodePattern.N.alreadyMarkedAs("Something"))).noDependents(".*", NodePattern.N.afterHead().andNot(NodePattern.PUNCT))).noMatchUntil("Subj", NodePattern.PUNCT).andOptionally(NodePattern.N.pos("VB").includeIntoReport())).andNot(NodePattern.N.directlyBefore(NodePattern.N.form("to")).directlyAfter(NodePattern.N.form("to"))).andNot(NodePattern.N.directlyBefore(NodePattern.N.form("only"))).andNot(Number.mistypedClauseNegation).between("Subj", "Verb").message(AUXILIARY_VERB_MISSING).directlyAfter(NodePattern.N.includeIntoReport()).and((not, match) -> {
            Node verb = match.getMarkedNode("Verb");
            Node subj = match.getMarkedNode("Subj");
            String doForm = VerbInflectionNumber.inflectDo(verb, subj);
            String haveForm = VerbInflectionNumber.inflectHave(verb, subj);
            String beFormPresent = VerbInflectionNumber.from(verb, subj).past(false).inflectBe();
            String beFormPast = VerbInflectionNumber.from(verb, subj).past(true).inflectBe();
            boolean contracted = EnglishParameters.suggestContractedForms.matches(subj);
            boolean full = EnglishParameters.suggestFullForms.matches(subj);
            NodeCorrector toBase = NodeCorrector.inflect(verb, "VB.*", "VB");
            if (verb.hasPos("JJ")) {
                if (full) {
                    match = match.withCorrector(NodeCorrector.insertBefore(not, beFormPresent + " "));
                }
                if (contracted) {
                    match = match.withCorrector(NodeCorrector.replace(not, beFormPresent + "n\u2019t"));
                }
            }
            if (verb.hasPos("VBN") && (!verb.hasDependent("obj") || subj.hasHeadRelation("nsubj:pass"))) {
                if (full) {
                    match = match.withCorrector(NodeCorrector.insertBefore(not, beFormPresent + " ")).withCorrector(NodeCorrector.insertBefore(not, beFormPast + " ")).withCorrector(NodeCorrector.insertBefore(not, haveForm + " ").join(NodeCorrector.insertAfter(not, " been")));
                }
                if (contracted) {
                    match = match.withCorrector(NodeCorrector.replace(not, beFormPresent + "n\u2019t", beFormPast + "n\u2019t", haveForm + "n\u2019t been"));
                }
            }
            Node head = verb.head();
            if (!(!full || subj.hasHeadRelation("nsubj:pass") || head != null && head.hasHeadRelation("obj"))) {
                match = match.withCorrector(NodeCorrector.insertBefore(not, doForm + " ").join(toBase));
                if (verb.hasPos("VBN")) {
                    match = match.withCorrector(NodeCorrector.insertBefore(not, haveForm + " "));
                }
            }
            if (!(!contracted || subj.hasHeadRelation("nsubj:pass") || head != null && head.hasHeadRelation("obj"))) {
                match = match.withCorrector(NodeCorrector.replace(not, doForm + "n\u2019t").join(toBase));
                if (verb.hasPos("VBN")) {
                    match = match.withCorrector(NodeCorrector.replace(not, haveForm + "n\u2019t"));
                }
            }
            return match;
        });
    }

    static NodePattern possessiveIssues() {
        NodePattern noTrailingWs = NodePattern.N.noSpaceAfter();
        NodePattern anyApostrophe = EnglishTreePatterns.onlyApos;
        NodeCorrector.Relative insertApostropheS = NodeCorrector.insertAfter(NodePointer.anchor(), "\u2019s");
        NodePattern fixSingularPossessor = NodePattern.N.andOptionally(endsWithS.correct(NodeCorrector.insertAfter("\u2019"))).correct(insertApostropheS);
        NodeCorrector.Relative pluralToSingularPossessor = NodeCorrector.inflect("NN").join(insertApostropheS);
        NodePattern saintAsCompound = NodePattern.or(NodePattern.N.label("EVENT").formCaseSensitive("Valentines?").withHeadRelation("compound"), NodePattern.N.withHeadRelation("compound|flat").directlyAfter(NodePattern.N.formCaseSensitive("St\\.?|Saint").withHeadRelation("compound")).directlyBefore(NodePattern.N.form("day|cathedral|church")).andNot(endsWithS.pos("NNP"))).andOr(endsWithS.and(removePluralInProperName), NodePattern.N.correct(insertApostropheS));
        NodePattern personalNameAsCompound = CommonPatterns.capitalized.andOr(NodePattern.N.directlyBeforeHead().noDependents(".*", NodePattern.N.afterHead()), NodePattern.N.withDependent("flat", NodePattern.N.directlyAfterHead()), NodePattern.N.withHeadRelation("flat").directlyAfterHead()).andOr(saintAsCompound, CommonPatterns.nerPerson.pos("NNP").noPotentialPos("JJ|NNS").withHead("compound", NodePattern.or(Semantics.definitelyUncountableNoun, NodePattern.N.form("idea")).noDependents("nmod:poss", NodePattern.N.withDependent("case")).andNot(CommonPatterns.capitalized)).and(fixSingularPossessor), NodePattern.or(NodePattern.N.directlyBeforeHead().withHead("compound|nmod(:poss)?", diseaseLaw.noHeadRelation("compound")), NodePattern.N.withDependent("flat", diseaseLaw.directlyAfterHead())).noDependents("compound").andOr(endsWithS.and(removePluralInProperName), NodePattern.N.pos("NNP").andOr(NodePattern.N.noPotentialPos("JJ"), NodePattern.N.formCaseSensitive("Graham")).noForm("labou?r").andNot(endsWithS).correct(insertApostropheS))).trace("personalNameAsCompound");
        NodePattern academicDegreeAsCompound = NodePattern.N.lemma("master|bachelor|associate").andOr(endsWithS.andOr(NodePattern.N.withDependent("det", NodePattern.N.form("an?")), CommonPatterns.possiblyConj(NodePattern.N.withHead("compound", NodePattern.N.lemma("degree|qualification|diploma|certificate|program(me)?")))).correct(pluralToSingularPossessor), NodePattern.N.pos("NNP?|JJ").and(CommonPatterns.possiblyConj(NodePattern.N.withHead("compound", NodePattern.N.lemma("degree|qualification|diploma|certificate|program(me)?")))).correct(insertApostropheS));
        NodePattern humanLikeNounAsCompound = NodePattern.or(academicDegreeAsCompound, NodePattern.N.lemma("artist|doctor|musician|reader|hitchhiker|(di)?rector|president|driver|producer|extremist|refugee|farmer|postman|soldier|student|teacher|admin(istrator)?|professor|developer|engineer|programmer|linguist|investor|pala?eontologist|politician|electrician|consultant|writer|painter|blogger|essayist|novelist|portraitist|landscapist|scholar|golfer|worker|researcher|careerist|governor|warden|principal|harbormaster|conductor|officer|captain|foreman|superintendent|senior|official|philosopher|logician|scientist|architect|dean|mayor|specialist|analyst|notary|registrar|chair(wo)?man|clerk|minister|advisor|lecturer|representative|librarian|commandor|CEO|manager|deputy|executive|agent|ambassador|nurse|midwife|secretary|master|bachelor|associate|beginner|amateur|woman|girl(friend)?|dudette|lady|princess|man|boy(friend)?|dude|guy|(lord|prince)(ling)?").directlyBeforeHead().withHead("compound", NodePattern.N.lemma("guide|block")).andOr(NodePattern.N.noForm("admin(istrator)?|developer").pos("NNP?").and(fixSingularPossessor), NodePattern.N.pos("NNS").correct(pluralToSingularPossessor))).trace("humanLikeNounAsCompound");
        NodePattern pronounAsCompound = NodePattern.or(NodePattern.N.form("(some|every|any|no)(thing|body|one)s").and(CommonPatterns.skipConjUp(NodePattern.N.beforeHead().withHead("nmod:poss", NodePattern.N.pos("NN.*")))), NodePattern.N.form("elses").directlyAfter(NodePattern.or(EnglishTreePatterns.someAnyEveryNoAnimate, NodePattern.N.inFormSequence(1, "some|any|every|no", "one|body"))).directlyBefore(NodePattern.N.pos("NN.*")), NodePattern.N.form("ones").withHeadRelation("nmod:poss|compound")).correct(NodeCorrector.regexReplace("(.+)s", "$1\u2019s")).trace("pronounAsCompound");
        return NodePattern.or(anyApostrophe.spaceAfter().noSpaceBefore().includeIntoReport().directlyAfter(NodePattern.N.pos("NN.*").includeIntoReport()).andOr(NodePattern.N.directlyAfter(NodePattern.N.beforeHead().andNot(endsWithS)).andNot(NodePattern.custom(apos -> ((StreamEx)apos.back().skip(1L)).anyMatch(n -> anyApostrophe.matches((Node)n) && noTrailingWs.matches((Node)n)))).andNot(NodePattern.N.directlyBefore(NodePattern.N.form(ToggleContraction.CONTRACTION_SUFFIXES).withHeadRelation("cop|aux|aux:pass"))).noLabel(".*").andNot(NodePattern.N.directlyAfter(CommonPatterns.capitalized).directlyBefore(CommonPatterns.capitalized)).andNot(NodePattern.N.directlyBefore(NodePattern.N.noPos())).andNot(TreeMigration.revise("is the apostrophe tokenization fixed?", NodePattern.N.after(NodePattern.N.form(".+['\u2019`\u2018].+")))).andOr(NodePattern.N.directlyBefore(NodePattern.N.form("s")).and((node, match) -> {
            String nodeForm = node.form();
            String replacement = nodeForm.substring(0, nodeForm.length() - 1) + "\u2019s";
            return match.withCorrector(NodeCorrector.replaceNodes(node, node.neighbor(1), replacement)).withMessage("An extra space before 's'?");
        }), NodePattern.N.message("Unmatched apostrophe?").correct(NodeCorrector.replace("", "\u2019s"))), NodePattern.N.directlyAfter(NodePattern.N.pos("NNS").withHeadRelation("nmod:poss").andOr(NodePattern.N.withDependent("det", AgreementSet.sgRequiringDet), NodePattern.N.withDependent("nummod", Number.one1).andNot(Number.withOneOfNummod))).and((apos, match) -> {
            Node noun = apos.neighbor(-1);
            String singular = PluralsInCompounds.toRegularSingular(noun);
            return singular == null ? null : match.withMessage("Did you mean a single '" + singular + "'?").withCorrector(NodeCorrector.replaceNodes(noun, apos, singular + "\u2019s"));
        })), NodePattern.or(personalNameAsCompound, humanLikeNounAsCompound, pronounAsCompound).noDependents("case", NodePattern.N.afterHead()).andNot(NodePattern.N.directlyBefore(EnglishTreePatterns.apostropheS)).message("Missing a possessive apostrophe?"), EnglishTreePatterns.apostropheS.directlyAfter(noTrailingWs.pos("NNS").and(endsWithS).noPos("NNP?").andNot(CommonPatterns.nerPerson)).message("Plural possessive is formed with an apostrophe only").directlyAfter(NodePattern.N.correct(NodeCorrector.inflect("NNS", "NN"))).correct(NodeCorrector.replace("\u2019")));
    }

    static NodePattern sinceCDtoCD() {
        NodePattern sinceCD2CD = EnglishTreePatterns.singleYearCD.withDependent("case", NodePattern.N.form("since").correct(NodeCorrector.replace("from"))).directlyBefore(NodePattern.N.form("to|till").directlyBefore(EnglishTreePatterns.singleYearCD));
        return sinceCD2CD.message("Use 'from' because the time period is finished");
    }

    static NodePattern conditional() {
        NodePattern polite = NodePattern.or(NodePattern.N.inFormSequence(2, "be", "so", "kind"), NodePattern.N.lemma("prefer").withDependent("nsubj", NodePattern.N.form("you")), NodePattern.N.withDependent("advmod", NodePattern.N.form("rather")));
        return NodePattern.N.form("if").andNot(NodePattern.N.directlyAfter(NodePattern.N.form("as"))).andNot(NodePattern.N.directlyBefore(NodePattern.N.form("only"))).andNot(NodePattern.N.directlyBefore(CommonPatterns.colon.and(CommonPatterns.lastToken)).trace("if-clauses listed in the next sentences")).withHead("mark", NodePattern.N.anyPos().noForm("like").withDependent("aux", NodePattern.N.lemma("will").andNot(NodePattern.N.inFormSequence(0, "would", "otherwise", "be"))).andOr(NodePattern.ROOT.message(CONDITIONAL_ISSUES_MESSAGE).and(TenseChanges::willToPresent), NodePattern.N.withHead("advcl", NodePattern.N.noForm("like|appreciate").noDependents("aux", NodePattern.N.form(".+ll").lemma("will")).and(CommonPatterns.possiblySkipDown("ccomp", NodePattern.N.withDependent("aux", NodePattern.N.form(".+d").lemma("will")).andOr(NodePattern.N.noDependents("aux", NodePattern.N.form("have")).message(SECOND_CONDITIONAL_ISSUES_MESSAGE), NodePattern.N.withDependent("aux", NodePattern.N.form("have")).message(THIRD_CONDITIONAL_ISSUES_MESSAGE))))).and(TenseChanges::nonPastToPast), NodePattern.N.withHeadRelation("advcl").andNot(NodePattern.N.inFormSequence(3, "you", "would", "n[o'\u2019`\u2018]t", ".*").withHead("advcl", EnglishTreePatterns.imperativeVB)).message(CONDITIONAL_ISSUES_MESSAGE).and(TenseChanges::willToPresent)).andNot(NodePattern.N.withHead(NodePattern.or(NodePattern.N.lemma("tell|say|see|wonder|ask|know|decide|determine"), NodePattern.N.form("idk|dunno"), NodePattern.N.pos("JJ").directlyBefore(NodePattern.N.form("if")).noDependents("aux.*")))).andNot(NodePattern.N.afterHead().withHead("advcl", EnglishTreePatterns.imperativeVB)).andNot(polite).andNot(NodePattern.N.withDependent("nsubj.*", NodePattern.N.form("you")).withHead(NodePattern.N.withDependent("aux"))));
    }

    static NodePattern whatOfConfusion() {
        return NodePattern.N.form("what").correct(NodeCorrector.replace("which")).withDependent("nmod", NodePattern.N.pos("NNS|PRP_O3P").withDependent("case", NodePattern.N.form("of"))).withHead("nsubj(:pass|:outer)?|i?obj|obl(:npmod|:tmod)?|nmod|compound", NodePattern.custom(n -> Number.verbNumber(EnglishTreePatterns.findFiniteVerb(n)) == Number.singular)).message(WHAT_WHICH_CONFUSION);
    }

    static NodePattern howWhatLookLikeConfusion() {
        return NodePattern.N.lemma("look").and(CommonPatterns.skipUp("xcomp", NodePattern.or(NodePattern.N.withDependent("mark|advmod|obl", NodePattern.N.form("how").markAs("How")), NodePattern.N.withHead("advcl:relcl", NodePattern.N.form("how").markAs("How"))))).and(NodePattern.markedNodeMatches("How", NodePattern.N.includeIntoReport().correct(NodeCorrector.replace("what")))).withDependent("obl", NodePattern.N.form("like").includeIntoReport().correct(NodeCorrector.replace(""))).message(HOW_WHAT_LOOK_LIKE_CONFUSION);
    }

    static NodePattern whatThat() {
        return NodePattern.N.form("what").markAs("What").andOr(NodePattern.N.withHead("obj", NodePattern.N.withHead("acl:relcl", NodePattern.N.withHeadRelation("nsubj.*").pos("NN.*").reportRangeTo("What", ReportingKind.Hover))).noDependents("acl:relcl").andNot(NodePattern.N.directlyAfter(NodePattern.N.withHeadRelation("mark")).trace("misattached case")).correct(NodeCorrector.replace("")), NodePattern.N.directlyAfter(NodePattern.N.form("all").reportRangeTo("What", ReportingKind.Hover)).withDependent("acl:relcl").andOptionally(NodePattern.N.noDependents("det:predet").correct(NodeCorrector.replace("")))).correct(NodeCorrector.replace("that")).message(WHAT_THAT_CONFUSION);
    }

    static NodePattern thatWithPreposition() {
        return NodePattern.N.markAs("Prep").noForm("of").withHead("case", NodePattern.N.form("that").beforeHead().markAs("That").withHead("obl", NodePattern.N.withHeadRelation("acl:relcl").withPhraseStart(NodePattern.N.sameWordAs("Prep")).noDependents("obl", NodePattern.N.pos("IN").afterHead()).markAs("RelCl").reportRangeTo("Prep", ReportingKind.Hover))).reportRangeTo("That").message(THAT_WITH_PREPOSITION_MSG).and((node, match) -> {
            String preposition = node.form();
            Node that = match.getMarkedNode("That");
            Node relcl = match.getMarkedNode("RelCl");
            if (relcl == relcl.phraseEnd()) {
                match = match.withCorrector(NodeCorrector.replace(node, "").join(NodeCorrector.insertAfter(relcl, " " + preposition)));
            }
            return match.withCorrector(NodeCorrector.replace(that, "which"));
        });
    }

    static NodePattern temporalClauses() {
        NodePattern futureToPresent = NodePattern.or(NodePattern.or(NodePattern.N.form("when|until|before|after|once"), NodePattern.N.inFormSequence(2, "as", "soon", "as")).markAs("Conj").withHead("mark|advmod", withWill.withHead("advcl", NodePattern.or(CommonPatterns.skipUp("advmod", withWill.noDependents("obl", Semantics.timeUnits.afterHead().before("Conj"))), NodePattern.ROOT.pos("VB").noDependents("nsubj(:pass|:outer)?|csubj(:pass)?"))).and(TenseChanges::willToPresent)), NodePattern.or(Semantics.timeUnits.withDependent("det", NodePattern.N.form("the")), NodePattern.N.inFormSequence(2, "by", "the", "time")).withHead("obl.*", withWill).withDependent("acl:relcl", withWill.and(TenseChanges::willToPresent))).message(FUTURE_IN_SUBORDINATE_MESSAGE);
        NodePattern whileWithProgressive = NodePattern.N.pos("VBD").lemma("go|walk|drive|sleep|live|work|store|expand|run|study|practice|research|prepare|clean|pack|paint|play|fix|repair|install|download|upload|keep|save|watch|avoid|recommend|learn|store|sit|stand|lie|lean|hunch|kneel|crouch").noDependents("cop|aux|aux:pass").withDependent("mark", NodePattern.N.form("while").andNot(NodePattern.N.directlyAfter(CommonPatterns.comma)).includeIntoReport(ReportingKind.Hover)).afterHead().withHead("advcl", NodePattern.N.noDependents("cop|aux|aux:pass").andOr(Semantics.singleActionInThePast, NodePattern.N.pos("VBD").withDependent("advmod|compound:prt", NodePattern.N.pos("RB").directlyAfterHead()))).and((node, match) -> TenseChanges.simpleToProgressive(node, match)).message("Use Past Progressive with 'while' to denote an ongoing action in the past");
        return NodePattern.or(futureToPresent, whileWithProgressive);
    }

    static NodePattern universalRelativeClause() {
        return withWill.withHead("acl:relcl", NodePattern.or(NodePattern.N.form("(any|every)(one|body|thing)"), NodePattern.N.withDependent("det", NodePattern.N.form("(any|every)"))).withHead("nsubj(:pass|:outer)?|i?obj|obl(:npmod|:tmod)?|nmod|compound", NodePattern.or(withWill, NodePattern.N.pos("JJ").withDependent("cop", NodePattern.N.pos("VB[ZP]?"))))).withDependent("nsubj|obj", NodePattern.N.pos("WP").noForm("what")).and(TenseChanges::willToPresent).message(FUTURE_IN_SUBORDINATE_MESSAGE);
    }

    static NodePattern sequenceOfTenses() {
        NodePattern presentVerb = NodePattern.or(NodePattern.N.pos("VB[ZP]"), NodePattern.N.form("can?|wo|will|['\u2019`\u2018]ll"));
        NodePattern pastVerb = NodePattern.N.pos("VBD").andOr(NodePattern.N.noPos("VBP?|MD"), NodePattern.N.form("found").withDependent("nsubj"));
        NodePattern mainClause = NodePattern.ROOT.lemma("know|aware|think|believe|wish|hope|allege").and(EnglishTreePatterns.addAuxVerbs(pastVerb.markAs("Past").includeIntoReport(ReportingKind.Hover).andOptionally(NodePattern.N.noSpaceAfter().directlyBefore(EnglishTreePatterns.negation.includeIntoReport(ReportingKind.Hover))))).andNot(NodePattern.N.inFormSequence(2, "did", "you", "know")).markAs("MainClause");
        return EnglishTreePatterns.addAuxVerbs(presentVerb.markAs("Present")).andOr(NodePattern.N.afterHead().withHead("ccomp", mainClause).withDependent("nsubj(:pass|:outer)?|csubj(:pass)?|expl"), NodePattern.N.withHead("acl:relcl", NodePattern.N.pos("WP").withHead("i?obj|obl", mainClause))).noMatchUntil("MainClause", EnglishTreePatterns.quotations).noDependents("mark", NodePattern.N.form("to")).andNot(NodePattern.N.withPhraseStart(NodePattern.N.directlyAfter(NodePattern.or(CommonPatterns.colon, EnglishTreePatterns.dashes)))).andOr(NodePattern.markedNodeMatches("Present", NodePattern.or(NodePattern.N.form("will|wo").correct(NodeCorrector.replace("would")), NodePattern.N.form(".ll").correct(NodeCorrector.regexReplace("(.)ll", "$1d")))), NodePattern.custom(TenseChanges::nonPastToPast)).andNot(Semantics.generalTruth).noDependents("nsubj(:pass|:outer)?|csubj(:pass)?", NodePattern.N.withDependent("det|amod", NodePattern.N.form("any|every|no|all"))).message(PAST_TENSE_SEQUENCE_MSG);
    }
}

