/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.document;

import ai.grazie.gec.model.problem.ProblemFix;
import ai.grazie.rules.Rule;
import ai.grazie.rules.RuleMatch;
import ai.grazie.rules.document.Delimiter;
import ai.grazie.rules.document.DocumentSentence;
import ai.grazie.rules.document.Metadata;
import ai.grazie.rules.tree.ActionSuggestion;
import ai.grazie.rules.tree.Node;
import ai.grazie.rules.tree.NodeMatch;
import ai.grazie.rules.tree.NodePattern;
import ai.grazie.rules.tree.TextChange;
import ai.grazie.rules.tree.TextRange;
import ai.grazie.rules.tree.Tree;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import one.util.streamex.StreamEx;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.jetbrains.annotations.Nullable;

public abstract class ConsistencyChecker<T extends Enum<T>> {
    private final Metadata.Key<List<StyledNode<T>>> key;

    public ConsistencyChecker(final Class<T> enumClass, Metadata.KeyId keyId) {
        this.key = new Metadata.Key<List<StyledNode<T>>>(this, keyId){

            @Override
            protected void serialize(DataOutput out, List<StyledNode<T>> value) throws IOException {
                out.writeVInt(value.size());
                for (StyledNode d : value) {
                    out.writeVInt((int)((byte)d.nodeIndex));
                    out.writeByte((byte)((Enum)d.style).ordinal());
                }
            }

            @Override
            protected List<StyledNode<T>> deserialize(DataInput in) throws IOException {
                int size = in.readVInt();
                ArrayList result = new ArrayList();
                for (int i = 0; i < size; ++i) {
                    result.add(new StyledNode<Enum>(in.readVInt(), ((Enum[])enumClass.getEnumConstants())[in.readByte()]));
                }
                return result;
            }

            @Override
            protected List<StyledNode<T>> mergeValues(List<StyledNode<T>> t1, List<StyledNode<T>> t2) {
                return StreamEx.of(t1).append(t2).toList();
            }

            @Override
            protected int fingerprint() {
                return Arrays.stream((Enum[])enumClass.getEnumConstants()).map(s -> s.name()).toList().hashCode();
            }
        };
    }

    @Nullable
    protected abstract SingleFix correctStyle(T var1, Node var2);

    protected abstract String quickFixMessage(T var1);

    public NodePattern record(T style) {
        return NodePattern.custom((node, match) -> match.withMetadata(this.key, List.of(new StyledNode<Enum>(match.anchor().index, (Enum)style))));
    }

    public List<RuleMatch> checkConsistency(List<DocumentSentence.Analyzed> sentences, Rule rule, String message) {
        List<DocumentSentence.Analyzed> filtered = ConsistencyChecker.onlyConsistencyEnabledDomains(sentences);
        HashSet<Enum> allStyles = new HashSet<Enum>();
        for (DocumentSentence.Analyzed sentence : filtered) {
            List<StyledNode<T>> meta = sentence.metadata.get(this.key);
            if (meta == null) continue;
            allStyles.addAll(meta.stream().map(StyledNode::style).toList());
        }
        if (allStyles.size() <= 1) {
            return List.of();
        }
        ArrayList<RuleMatch> result = new ArrayList<RuleMatch>();
        final ArrayList<TextRange> hoverReportedRanges = new ArrayList<TextRange>();
        final ArrayList<ProblemFix> fixes = new ArrayList<ProblemFix>();
        for (Enum style : allStyles.stream().sorted().toList()) {
            ArrayList<TextChange> changes = new ArrayList<TextChange>();
            for (DocumentSentence.Analyzed sentence : filtered) {
                List<StyledNode<T>> styledNodes = sentence.metadata.get(this.key);
                if (styledNodes == null) continue;
                for (StyledNode<T> styled : styledNodes) {
                    Tree tree;
                    SingleFix change;
                    if (styled.style == style || (change = this.correctStyle(style, (tree = Objects.requireNonNull(sentence.tree)).nodes().get(styled.nodeIndex))) == null || sentence.suppressions.contains(TextRange.spanRanges(change.reportedRanges().stream()).shiftLeft(tree.startOffset()))) continue;
                    changes.add(change.change);
                    result.add(new RuleMatch(this, rule, message){

                        @Override
                        public List<ProblemFix> problemFixes() {
                            return fixes;
                        }

                        @Override
                        public List<TextRange> reportedRanges() {
                            return change.reportedRanges;
                        }

                        @Override
                        public List<TextRange> hoverReportedRanges() {
                            return ((StreamEx)StreamEx.of((Collection)hoverReportedRanges).sortedByInt(TextRange::start)).toList();
                        }

                        @Override
                        public List<ActionSuggestion> actions() {
                            return change.actions();
                        }
                    });
                    hoverReportedRanges.addAll(change.reportedRanges);
                    hoverReportedRanges.addAll(change.hoverReportedRanges);
                }
            }
            if (changes.isEmpty()) {
                return List.of();
            }
            fixes.add(new ProblemFix((ProblemFix.Part[])StreamEx.of(changes).flatCollection(TextChange::changes).map(TextChange.Replacement::toProblemChange).toArray(ProblemFix.Part[]::new), null, this.quickFixMessage(style)));
        }
        return result;
    }

    public static List<DocumentSentence.Analyzed> onlyConsistencyEnabledDomains(List<DocumentSentence.Analyzed> sentences) {
        return ((StreamEx)StreamEx.of(DocumentSentence.fragments(sentences)).filter(f -> !((DocumentSentence.Analyzed)f.get((int)0)).intro.contains((Object)Delimiter.codeCommentStart))).toFlatList(Function.identity());
    }

    private record StyledNode<T extends Enum<T>>(int nodeIndex, T style) {
    }

    public record SingleFix(TextChange change, List<TextRange> reportedRanges, List<TextRange> hoverReportedRanges, List<ActionSuggestion> actions) {
        public SingleFix {
            assert (!reportedRanges.isEmpty());
            assert (!hoverReportedRanges.isEmpty());
        }

        public SingleFix(TextChange change, TextRange reportedRange) {
            this(change, List.of(reportedRange), List.of(reportedRange), List.of());
        }

        @Nullable
        public static SingleFix from(NodeMatch match) {
            if (match == null) {
                return null;
            }
            List<TextChange> changes = match.calcCorrectionChanges();
            return changes.size() != 1 ? null : new SingleFix(changes.get(0), match.reportedRanges(), match.hoverReportedRanges(), List.of());
        }
    }
}

