/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.lw;

import com.intellij.uiDesigner.compiler.UnexpectedFormElementException;
import com.intellij.uiDesigner.lw.LwComponent;
import com.intellij.uiDesigner.lw.LwContainer;
import com.intellij.uiDesigner.lw.LwXmlReader;
import com.intellij.uiDesigner.lw.PropertiesProvider;
import java.awt.LayoutManager;
import org.jdom.Element;

public final class LwSplitPane
extends LwContainer {
    public static final String POSITION_LEFT = "left";
    public static final String POSITION_RIGHT = "right";

    LwSplitPane(String className) {
        super(className);
    }

    @Override
    protected LayoutManager createInitialLayout() {
        return null;
    }

    @Override
    public void read(Element element, PropertiesProvider provider) throws Exception {
        this.readNoLayout(element, provider);
    }

    @Override
    protected void readConstraintsForChild(Element element, LwComponent component) {
        Element constraintsElement = LwXmlReader.getRequiredChild(element, "constraints");
        Element splitterChild = LwXmlReader.getRequiredChild(constraintsElement, "splitpane");
        String position = LwXmlReader.getRequiredString(splitterChild, "position");
        if (POSITION_LEFT.equals(position)) {
            component.setCustomLayoutConstraints(POSITION_LEFT);
        } else if (POSITION_RIGHT.equals(position)) {
            component.setCustomLayoutConstraints(POSITION_RIGHT);
        } else {
            throw new UnexpectedFormElementException("unexpected position: " + position);
        }
    }
}

