/*
 * Decompiled with CFR 0.152.
 */
package com.theoryinpractice.testng.model;

import com.intellij.execution.ExternalizablePath;
import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.Location;
import com.intellij.execution.junit2.info.MethodLocation;
import com.intellij.execution.testframework.TestSearchScope;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.theoryinpractice.testng.model.TestType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestData
implements Cloneable {
    public String SUITE_NAME;
    public String PACKAGE_NAME;
    @NlsSafe
    public String MAIN_CLASS_NAME;
    public String METHOD_NAME;
    @NlsSafe
    public String GROUP_NAME;
    public String TEST_OBJECT;
    public String VM_PARAMETERS = "-ea";
    public String PARAMETERS;
    public String WORKING_DIRECTORY = "$MODULE_WORKING_DIR$";
    public String OUTPUT_DIRECTORY;
    private Map<String, String> ENVS = new LinkedHashMap<String, String>();
    public boolean PASS_PARENT_ENVS = true;
    public TestSearchScope.Wrapper TEST_SEARCH_SCOPE;
    public Map<String, String> TEST_PROPERTIES = new HashMap<String, String>();
    public List<String> TEST_LISTENERS = new ArrayList<String>();
    public boolean USE_DEFAULT_REPORTERS = false;
    public String PROPERTIES_FILE;
    private LinkedHashSet<String> myPatterns = new LinkedHashSet();
    private String myChangeList;

    public TestData() {
        this.TEST_OBJECT = TestType.CLASS.getType();
        this.TEST_SEARCH_SCOPE = new TestSearchScope.Wrapper();
    }

    public TestSearchScope getScope() {
        return this.TEST_SEARCH_SCOPE.getScope();
    }

    public void setScope(TestSearchScope testseachscope) {
        this.TEST_SEARCH_SCOPE.setScope(testseachscope);
    }

    @NlsSafe
    public String getPackageName() {
        return this.PACKAGE_NAME == null ? "" : this.PACKAGE_NAME;
    }

    @NlsSafe
    public String getGroupName() {
        return this.GROUP_NAME == null ? "" : this.GROUP_NAME;
    }

    @NotNull
    @NlsSafe
    public String getMethodName() {
        String string = this.METHOD_NAME == null ? "" : this.METHOD_NAME;
        if (string == null) {
            TestData.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    @NlsSafe
    public String getSuiteName() {
        String string = this.SUITE_NAME == null ? "" : this.SUITE_NAME;
        if (string == null) {
            TestData.$$$reportNull$$$0(1);
        }
        return string;
    }

    public String getPropertiesFile() {
        return this.PROPERTIES_FILE == null ? "" : this.PROPERTIES_FILE;
    }

    public String getOutputDirectory() {
        return this.OUTPUT_DIRECTORY == null ? "" : this.OUTPUT_DIRECTORY;
    }

    public void setVMParameters(@Nullable String value) {
        this.VM_PARAMETERS = StringUtil.nullize((String)value);
    }

    public String getVMParameters() {
        return this.VM_PARAMETERS;
    }

    public void setProgramParameters(String value) {
        this.PARAMETERS = value;
    }

    public String getProgramParameters() {
        return this.PARAMETERS;
    }

    public void setWorkingDirectory(String value) {
        this.WORKING_DIRECTORY = StringUtil.isEmptyOrSpaces((String)value) ? "" : FileUtilRt.toSystemIndependentName((String)value.trim());
    }

    public String getWorkingDirectory() {
        return ExternalizablePath.localPathValue((String)this.WORKING_DIRECTORY);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TestData)) {
            return false;
        }
        TestData data = (TestData)obj;
        return Objects.equals(this.TEST_OBJECT, data.TEST_OBJECT) && Objects.equals(this.getMainClassName(), data.getMainClassName()) && Objects.equals(this.getPackageName(), data.getPackageName()) && Objects.equals(this.getSuiteName(), data.getSuiteName()) && Objects.equals(this.getMethodName(), data.getMethodName()) && Objects.equals(this.WORKING_DIRECTORY, data.WORKING_DIRECTORY) && Objects.equals(this.OUTPUT_DIRECTORY, data.OUTPUT_DIRECTORY) && Objects.equals(this.VM_PARAMETERS, data.VM_PARAMETERS) && Objects.equals(this.PARAMETERS, data.PARAMETERS) && Comparing.equal(this.myPatterns, data.myPatterns) && this.USE_DEFAULT_REPORTERS == data.USE_DEFAULT_REPORTERS;
    }

    public int hashCode() {
        return Comparing.hashcode((Object)this.getMainClassName()) ^ Comparing.hashcode((Object)this.getMethodName()) ^ Comparing.hashcode((Object)this.getGroupName()) ^ Comparing.hashcode((Object)this.getSuiteName()) ^ Comparing.hashcode((Object)this.TEST_OBJECT) ^ Comparing.hashcode((Object)this.WORKING_DIRECTORY) ^ Comparing.hashcode((Object)this.OUTPUT_DIRECTORY) ^ Comparing.hashcode((Object)this.VM_PARAMETERS) ^ Comparing.hashcode((Object)this.PARAMETERS) ^ Comparing.hashcode((Object)this.USE_DEFAULT_REPORTERS) ^ Comparing.hashcode(this.myPatterns);
    }

    public TestData clone() {
        TestData data;
        try {
            data = (TestData)super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            data = new TestData();
        }
        data.TEST_SEARCH_SCOPE = new TestSearchScope.Wrapper();
        data.TEST_PROPERTIES = new HashMap<String, String>();
        data.TEST_PROPERTIES.putAll(this.TEST_PROPERTIES);
        data.TEST_LISTENERS = new ArrayList<String>();
        data.TEST_LISTENERS.addAll(this.TEST_LISTENERS);
        data.USE_DEFAULT_REPORTERS = this.USE_DEFAULT_REPORTERS;
        data.ENVS = new LinkedHashMap<String, String>(this.ENVS);
        data.myPatterns = new LinkedHashSet();
        data.myPatterns.addAll(this.myPatterns);
        data.setScope(this.getScope());
        return data;
    }

    public String getMainClassName() {
        return this.MAIN_CLASS_NAME == null ? "" : this.MAIN_CLASS_NAME;
    }

    public Module setTestMethod(Location<PsiMethod> location) {
        PsiMethod method = (PsiMethod)location.getPsiElement();
        this.METHOD_NAME = method.getName();
        this.TEST_OBJECT = TestType.METHOD.getType();
        return this.setMainClass(location instanceof MethodLocation ? ((MethodLocation)location).getContainingClass() : method.getContainingClass());
    }

    public Module setPackage(PsiPackage pkg) {
        this.PACKAGE_NAME = pkg.getQualifiedName();
        return null;
    }

    public Module setMainClass(PsiClass psiclass) {
        this.MAIN_CLASS_NAME = JavaExecutionUtil.getRuntimeQualifiedName((PsiClass)psiclass);
        this.PACKAGE_NAME = StringUtil.getPackageName((String)Objects.requireNonNull(psiclass.getQualifiedName()));
        return JavaExecutionUtil.findModule((PsiClass)psiclass);
    }

    public Map<String, String> getEnvs() {
        return this.ENVS;
    }

    public void setEnvs(Map<String, String> envs) {
        this.ENVS = envs;
    }

    public Set<String> getPatterns() {
        return this.myPatterns;
    }

    public void setPatterns(LinkedHashSet<String> set) {
        this.myPatterns = set;
    }

    public String getChangeList() {
        return this.myChangeList;
    }

    public void setChangeList(String changeList) {
        this.myChangeList = changeList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/theoryinpractice/testng/model/TestData";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethodName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuiteName";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

