/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.rmi.ssl;

import com.intellij.execution.rmi.ssl.DelegateKeyStore;
import com.intellij.execution.rmi.ssl.SslUtil;
import com.intellij.openapi.util.Pair;
import java.io.IOException;
import java.io.InputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SslKeyStore
extends DelegateKeyStore {
    public static final String SSL_DEFERRED_KEY_LOADING = "sslDeferredKeyLoading";
    public static final String SSL_DEFERRED_CA_LOADING = "sslDeferredCaLoading";
    private static final String NAME = "idea-key-store";
    private static final List<KeyEntry> ourAdded = new ArrayList<KeyEntry>();
    private int myAdded;

    public SslKeyStore() {
        super("PKCS12");
    }

    public static KeyStore getInstance() throws KeyStoreException {
        return KeyStore.getInstance(NAME);
    }

    public static void setDefault() {
        System.setProperty("javax.net.ssl.keyStoreType", NAME);
        if (System.getProperty("javax.net.ssl.keyStore") == null) {
            System.setProperty("javax.net.ssl.keyStore", SslKeyStore.getDefaultKeyStorePath());
        }
    }

    @Nullable
    public static Key getUserKey() {
        return ourAdded.isEmpty() ? null : ourAdded.get(0).key;
    }

    public static void loadKey(@NotNull String alias, @NotNull String clientKeyPath, @Nullable String clientCertPath, char @Nullable [] password) {
        if (alias == null) {
            SslKeyStore.$$$reportNull$$$0(0);
        }
        if (clientKeyPath == null) {
            SslKeyStore.$$$reportNull$$$0(1);
        }
        try {
            Pair<PrivateKey, List<X509Certificate>> keyAndCerts = SslUtil.readPrivateKeyAndCertificate(clientKeyPath, password);
            List certificates = clientCertPath == null ? (List)keyAndCerts.second : SslUtil.loadCertificates(clientCertPath);
            ourAdded.add(new KeyEntry(alias, (Key)keyAndCerts.first, certificates == null ? null : certificates.toArray(new Certificate[0])));
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    protected void validate(KeyStore keyStore) {
        super.validate(keyStore);
        int sz = ourAdded.size();
        for (int i = this.myAdded; i < sz; ++i) {
            KeyEntry entry = ourAdded.get(i);
            if (entry.certChain != null) {
                try {
                    keyStore.setKeyEntry(entry.alias, entry.key, null, entry.certChain);
                }
                catch (KeyStoreException e) {
                    throw new IllegalStateException(e);
                }
            }
            this.myAdded = i + 1;
        }
    }

    @Override
    public void engineLoad(InputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        super.engineLoad(null, null);
    }

    public static int appendUserKeyStore(@NotNull String path, char[] password) {
        if (path == null) {
            SslKeyStore.$$$reportNull$$$0(2);
        }
        try {
            KeyStore tmpStore = SslKeyStore.loadKeyStore(path, password);
            if (tmpStore == null) {
                return 0;
            }
            int cnt = 0;
            Enumeration<String> aliases = tmpStore.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                Key key = tmpStore.getKey(alias, null);
                if (key == null) continue;
                Certificate[] certChain = tmpStore.getCertificateChain(alias);
                ourAdded.add(new KeyEntry(alias, key, certChain));
                ++cnt;
            }
            return cnt;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    static {
        ourProvider.setProperty("KeyStore.idea-key-store", SslKeyStore.class.getName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alias";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clientKeyPath";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        objectArray2[1] = "com/intellij/execution/rmi/ssl/SslKeyStore";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "loadKey";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "appendUserKeyStore";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class KeyEntry {
        private final String alias;
        private final Key key;
        private final Certificate[] certChain;

        private KeyEntry(@NotNull String alias, @NotNull Key key, Certificate @Nullable [] certChain) {
            if (alias == null) {
                KeyEntry.$$$reportNull$$$0(0);
            }
            if (key == null) {
                KeyEntry.$$$reportNull$$$0(1);
            }
            this.alias = alias;
            this.key = key;
            this.certChain = certChain;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "alias";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "key";
                    break;
                }
            }
            objectArray[1] = "com/intellij/execution/rmi/ssl/SslKeyStore$KeyEntry";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

