/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.images.scientific.utils;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import javax.imageio.ImageIO;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u001a\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0080@\u00a2\u0006\u0004\b\u0011\u0010\u0012J \u0010\u0013\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0080@\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0018\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u0010H\u0080@\u00a2\u0006\u0004\b\u0019\u0010\u001aJ \u0010\u001b\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u0015H\u0080@\u00a2\u0006\u0004\b\u001d\u0010\u0017J\u0018\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u0010H\u0080@\u00a2\u0006\u0004\b\u001f\u0010\u001aJ\u0018\u0010 \u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u0010H\u0080@\u00a2\u0006\u0004\b!\u0010\u001aJ \u0010\"\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010#\u001a\u00020\u0015H\u0080@\u00a2\u0006\u0004\b$\u0010\u0017J\u0018\u0010%\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u0010H\u0080@\u00a2\u0006\u0004\b&\u0010\u001aJ \u0010'\u001a\u00020\u00152\u0006\u0010(\u001a\u00020\u00152\u0006\u0010)\u001a\u00020\u00152\u0006\u0010*\u001a\u00020\u0015H\u0002J \u0010+\u001a\u00020\u00152\u0006\u0010,\u001a\u00020\u00152\u0006\u0010-\u001a\u00020\u00152\u0006\u0010.\u001a\u00020\u0015H\u0002R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lorg/intellij/images/scientific/utils/ScientificUtils;", "", "<init>", "()V", "SCIENTIFIC_MODE_KEY", "Lcom/intellij/openapi/util/Key;", "", "DATA_TYPE_KEY", "", "getDATA_TYPE_KEY", "()Lcom/intellij/openapi/util/Key;", "DEFAULT_IMAGE_FORMAT", "saveImageToFile", "imageFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "image", "Ljava/awt/image/BufferedImage;", "saveImageToFile$intellij_platform_images", "(Lcom/intellij/openapi/vfs/VirtualFile;Ljava/awt/image/BufferedImage;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "rotateImage", "angle", "", "rotateImage$intellij_platform_images", "(Ljava/awt/image/BufferedImage;ILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "applyGrayscale", "applyGrayscale$intellij_platform_images", "(Ljava/awt/image/BufferedImage;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "displaySingleChannel", "channelIndex", "displaySingleChannel$intellij_platform_images", "applyInvertChannels", "applyInvertChannels$intellij_platform_images", "applyReverseChannelsOrder", "applyReverseChannelsOrder$intellij_platform_images", "applyBinarization", "threshold", "applyBinarization$intellij_platform_images", "normalizeImage", "normalizeImage$intellij_platform_images", "normalizeChannel", "value", "min", "max", "calculateBrightness", "r", "g", "b", "intellij.platform.images"})
public final class ScientificUtils {
    @NotNull
    public static final ScientificUtils INSTANCE = new ScientificUtils();
    @JvmField
    @NotNull
    public static final Key<Unit> SCIENTIFIC_MODE_KEY = new Key("SCIENTIFIC_MODE");
    @NotNull
    private static final Key<String> DATA_TYPE_KEY = new Key("DATA_TYPE");
    @NotNull
    public static final String DEFAULT_IMAGE_FORMAT = "png";

    private ScientificUtils() {
    }

    @NotNull
    public final Key<String> getDATA_TYPE_KEY() {
        return DATA_TYPE_KEY;
    }

    @Nullable
    public final Object saveImageToFile$intellij_platform_images(@NotNull VirtualFile imageFile, @NotNull BufferedImage image, @NotNull Continuation<? super Unit> $completion) {
        Object object = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(image, imageFile, null){
            int label;
            final /* synthetic */ BufferedImage $image;
            final /* synthetic */ VirtualFile $imageFile;
            {
                this.$image = $image;
                this.$imageFile = $imageFile;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        Closeable closeable = new ByteArrayOutputStream();
                        BufferedImage bufferedImage = this.$image;
                        VirtualFile virtualFile = this.$imageFile;
                        Throwable throwable = null;
                        try {
                            ByteArrayOutputStream outputStream = (ByteArrayOutputStream)closeable;
                            boolean bl = false;
                            ImageIO.write((RenderedImage)bufferedImage, "png", outputStream);
                            byte[] byArray = outputStream.toByteArray();
                            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
                            VirtualFileUtil.writeBytes((VirtualFile)virtualFile, (byte[])byArray);
                            Unit unit = Unit.INSTANCE;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public final Object rotateImage$intellij_platform_images(@NotNull BufferedImage image, int angle, @NotNull Continuation<? super BufferedImage> $completion) {
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super BufferedImage>, Object>(angle, image, null){
            int label;
            final /* synthetic */ int $angle;
            final /* synthetic */ BufferedImage $image;
            {
                this.$angle = $angle;
                this.$image = $image;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        Graphics2D graphics2D;
                        ResultKt.throwOnFailure((Object)$result);
                        int angle = this.$angle % 360;
                        if (angle < 0) {
                            angle += 360;
                        }
                        int width = this.$image.getWidth();
                        int height = this.$image.getHeight();
                        boolean isRightAngle = angle % 180 == 90;
                        int targetWidth = isRightAngle ? height : width;
                        int targetHeight = isRightAngle ? width : height;
                        AffineTransform transform = new AffineTransform();
                        transform.translate((double)targetWidth / 2.0, (double)targetHeight / 2.0);
                        transform.rotate(Math.toRadians(angle));
                        transform.translate((double)(-width) / 2.0, (double)(-height) / 2.0);
                        BufferedImage bufferedImage = new BufferedImage(targetWidth, targetHeight, this.$image.getType());
                        BufferedImage bufferedImage2 = this.$image;
                        BufferedImage rotatedImage = bufferedImage;
                        boolean bl = false;
                        Graphics2D $this$invokeSuspend_u24lambda_u240_u240 = graphics2D = rotatedImage.createGraphics();
                        boolean bl2 = false;
                        $this$invokeSuspend_u24lambda_u240_u240.setTransform(transform);
                        $this$invokeSuspend_u24lambda_u240_u240.drawImage((Image)bufferedImage2, 0, 0, null);
                        $this$invokeSuspend_u24lambda_u240_u240.dispose();
                        return bufferedImage;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super BufferedImage> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    @Nullable
    public final Object applyGrayscale$intellij_platform_images(@NotNull BufferedImage image, @NotNull Continuation<? super BufferedImage> $completion) {
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super BufferedImage>, Object>(image, null){
            int label;
            final /* synthetic */ BufferedImage $image;
            {
                this.$image = $image;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        Graphics2D graphics2D;
                        ResultKt.throwOnFailure((Object)$result);
                        BufferedImage bufferedImage = new BufferedImage(this.$image.getWidth(), this.$image.getHeight(), 10);
                        BufferedImage bufferedImage2 = this.$image;
                        BufferedImage grayscaleImage = bufferedImage;
                        boolean bl = false;
                        Graphics2D $this$invokeSuspend_u24lambda_u240_u240 = graphics2D = grayscaleImage.createGraphics();
                        boolean bl2 = false;
                        $this$invokeSuspend_u24lambda_u240_u240.drawImage((Image)bufferedImage2, 0, 0, null);
                        $this$invokeSuspend_u24lambda_u240_u240.dispose();
                        return bufferedImage;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super BufferedImage> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    @Nullable
    public final Object displaySingleChannel$intellij_platform_images(@NotNull BufferedImage image, int channelIndex, @NotNull Continuation<? super BufferedImage> $completion) {
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super BufferedImage>, Object>(image, channelIndex, null){
            int label;
            final /* synthetic */ BufferedImage $image;
            final /* synthetic */ int $channelIndex;
            {
                this.$image = $image;
                this.$channelIndex = $channelIndex;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        WritableRaster inRaster = this.$image.getRaster();
                        BufferedImage bufferedImage = new BufferedImage(this.$image.getWidth(), this.$image.getHeight(), 10);
                        BufferedImage bufferedImage2 = this.$image;
                        int n = this.$channelIndex;
                        BufferedImage channelImage = bufferedImage;
                        boolean bl = false;
                        WritableRaster outRaster = channelImage.getRaster();
                        int n2 = bufferedImage2.getHeight();
                        for (int y = 0; y < n2; ++y) {
                            int n3 = bufferedImage2.getWidth();
                            for (int x = 0; x < n3; ++x) {
                                outRaster.setSample(x, y, 0, inRaster.getSample(x, y, n));
                            }
                        }
                        return bufferedImage;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super BufferedImage> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    @Nullable
    public final Object applyInvertChannels$intellij_platform_images(@NotNull BufferedImage image, @NotNull Continuation<? super BufferedImage> $completion) {
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super BufferedImage>, Object>(image, null){
            int label;
            final /* synthetic */ BufferedImage $image;
            {
                this.$image = $image;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        BufferedImage bufferedImage;
                        ResultKt.throwOnFailure((Object)$result);
                        int width = this.$image.getWidth();
                        int height = this.$image.getHeight();
                        int numBands = this.$image.getRaster().getNumBands();
                        int[] pixel = new int[numBands];
                        WritableRaster inRaster = this.$image.getRaster();
                        BufferedImage invertedImage = bufferedImage = new BufferedImage(width, height, this.$image.getType());
                        boolean bl = false;
                        WritableRaster outRaster = invertedImage.getRaster();
                        for (int y = 0; y < height; ++y) {
                            for (int x = 0; x < width; ++x) {
                                inRaster.getPixel(x, y, pixel);
                                int[] nArray = new int[numBands];
                                for (int i = 0; i < numBands; ++i) {
                                    int n = i;
                                    nArray[n] = numBands == 4 && n == 0 ? pixel[0] : 255 - pixel[n];
                                }
                                int[] invertedPixel = nArray;
                                outRaster.setPixel(x, y, invertedPixel);
                            }
                        }
                        return bufferedImage;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super BufferedImage> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    @Nullable
    public final Object applyReverseChannelsOrder$intellij_platform_images(@NotNull BufferedImage image, @NotNull Continuation<? super BufferedImage> $completion) {
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super BufferedImage>, Object>(image, null){
            int label;
            final /* synthetic */ BufferedImage $image;
            {
                this.$image = $image;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        BufferedImage bufferedImage;
                        ResultKt.throwOnFailure((Object)$result);
                        int width = this.$image.getWidth();
                        int height = this.$image.getHeight();
                        int numBands = this.$image.getRaster().getNumBands();
                        int[] pixel = new int[numBands];
                        WritableRaster inRaster = this.$image.getRaster();
                        BufferedImage reversedImage = bufferedImage = new BufferedImage(width, height, this.$image.getType());
                        boolean bl = false;
                        WritableRaster outRaster = reversedImage.getRaster();
                        for (int y = 0; y < height; ++y) {
                            for (int x = 0; x < width; ++x) {
                                inRaster.getPixel(x, y, pixel);
                                int[] reversedPixel = switch (numBands) {
                                    case 4 -> {
                                        int[] var13_13 = new int[]{pixel[0], pixel[3], pixel[2], pixel[1]};
                                        yield var13_13;
                                    }
                                    case 3 -> {
                                        int[] var13_13 = new int[]{pixel[2], pixel[1], pixel[0]};
                                        yield var13_13;
                                    }
                                    default -> pixel;
                                };
                                outRaster.setPixel(x, y, reversedPixel);
                            }
                        }
                        return bufferedImage;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super BufferedImage> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    @Nullable
    public final Object applyBinarization$intellij_platform_images(@NotNull BufferedImage image, int threshold, @NotNull Continuation<? super BufferedImage> $completion) {
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super BufferedImage>, Object>(image, threshold, null){
            int label;
            final /* synthetic */ BufferedImage $image;
            final /* synthetic */ int $threshold;
            {
                this.$image = $image;
                this.$threshold = $threshold;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        int width = this.$image.getWidth();
                        int height = this.$image.getHeight();
                        WritableRaster inRaster = this.$image.getRaster();
                        int numBands = inRaster.getNumBands();
                        int[] pixel = new int[numBands];
                        BufferedImage bufferedImage = new BufferedImage(width, height, 12);
                        int n = this.$threshold;
                        BufferedImage binarizedImage = bufferedImage;
                        boolean bl = false;
                        WritableRaster outRaster = binarizedImage.getRaster();
                        for (int y = 0; y < height; ++y) {
                            for (int x = 0; x < width; ++x) {
                                inRaster.getPixel(x, y, pixel);
                                int brightness = switch (numBands) {
                                    case 4 -> ScientificUtils.access$calculateBrightness(ScientificUtils.INSTANCE, pixel[1], pixel[2], pixel[3]);
                                    case 3 -> ScientificUtils.access$calculateBrightness(ScientificUtils.INSTANCE, pixel[0], pixel[1], pixel[2]);
                                    default -> pixel[0];
                                };
                                int binaryValue = brightness < n ? 0 : 1;
                                outRaster.setSample(x, y, 0, binaryValue);
                            }
                        }
                        return bufferedImage;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super BufferedImage> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    @Nullable
    public final Object normalizeImage$intellij_platform_images(@NotNull BufferedImage image, @NotNull Continuation<? super BufferedImage> $completion) {
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super BufferedImage>, Object>(image, null){
            int label;
            final /* synthetic */ BufferedImage $image;
            {
                this.$image = $image;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        BufferedImage bufferedImage;
                        ResultKt.throwOnFailure((Object)$result);
                        int width = this.$image.getWidth();
                        int height = this.$image.getHeight();
                        int numBands = this.$image.getRaster().getNumBands();
                        int[] pixel = new int[numBands];
                        WritableRaster inRaster = this.$image.getRaster();
                        int n = 0;
                        int[] nArray = new int[numBands];
                        while (n < numBands) {
                            int n2 = n++;
                            nArray[n2] = 255;
                        }
                        int[] mins = nArray;
                        int n3 = 0;
                        int[] nArray2 = new int[numBands];
                        while (n3 < numBands) {
                            int n4 = n3++;
                            nArray2[n4] = 0;
                        }
                        int[] maxs = nArray2;
                        for (int y = 0; y < height; ++y) {
                            for (int x = 0; x < width; ++x) {
                                inRaster.getPixel(x, y, pixel);
                                for (int i = 0; i < numBands; ++i) {
                                    if (pixel[i] < mins[i]) {
                                        mins[i] = pixel[i];
                                    }
                                    if (pixel[i] <= maxs[i]) continue;
                                    maxs[i] = pixel[i];
                                }
                            }
                        }
                        BufferedImage normalizedImage = bufferedImage = new BufferedImage(width, height, this.$image.getType());
                        boolean bl = false;
                        WritableRaster outRaster = normalizedImage.getRaster();
                        for (int y = 0; y < height; ++y) {
                            for (int x = 0; x < width; ++x) {
                                inRaster.getPixel(x, y, pixel);
                                int[] nArray3 = new int[numBands];
                                for (int i = 0; i < numBands; ++i) {
                                    int n5 = i;
                                    nArray3[n5] = numBands == 4 && n5 == 0 ? pixel[0] : ScientificUtils.access$normalizeChannel(ScientificUtils.INSTANCE, pixel[n5], mins[n5], maxs[n5]);
                                }
                                int[] normalizedPixel = nArray3;
                                outRaster.setPixel(x, y, normalizedPixel);
                            }
                        }
                        return bufferedImage;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super BufferedImage> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    private final int normalizeChannel(int value, int min, int max) {
        return max > min ? RangesKt.coerceIn((int)((value - min) * 255 / (max - min)), (int)0, (int)255) : value;
    }

    private final int calculateBrightness(int r, int g, int b) {
        return (int)(0.2126 * (double)r + 0.7152 * (double)g + 0.0722 * (double)b);
    }

    public static final /* synthetic */ int access$calculateBrightness(ScientificUtils $this, int r, int g, int b) {
        return $this.calculateBrightness(r, g, b);
    }

    public static final /* synthetic */ int access$normalizeChannel(ScientificUtils $this, int value, int min, int max) {
        return $this.normalizeChannel(value, min, max);
    }
}

