/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.markdown.backend.services;

import com.intellij.ide.BrowserUtil;
import com.intellij.ide.vfs.VirtualFileId;
import com.intellij.ide.vfs.VirtualFileIdKt;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.platform.project.ProjectIdKt;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.UriUtil;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.intellij.plugins.markdown.dto.MarkdownHeaderInfo;
import org.intellij.plugins.markdown.dto.MarkdownLinkNavigationData;
import org.intellij.plugins.markdown.lang.index.HeaderAnchorIndex;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownHeader;
import org.intellij.plugins.markdown.mapper.MarkdownHeaderMapper;
import org.intellij.plugins.markdown.service.MarkdownLinkOpenerRemoteApi;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0096@\u00a2\u0006\u0002\u0010\nJ\u001c\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002J(\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000e2\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u00a8\u0006\u0015"}, d2={"Lcom/intellij/markdown/backend/services/MarkdownLinkOpenerRemoteApiImpl;", "Lorg/intellij/plugins/markdown/service/MarkdownLinkOpenerRemoteApi;", "<init>", "()V", "fetchLinkNavigationData", "Lorg/intellij/plugins/markdown/dto/MarkdownLinkNavigationData;", "link", "", "virtualFileId", "Lcom/intellij/ide/vfs/VirtualFileId;", "(Ljava/lang/String;Lcom/intellij/ide/vfs/VirtualFileId;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "resolveLinkAsFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "collectHeaders", "", "Lorg/intellij/plugins/markdown/dto/MarkdownHeaderInfo;", "anchor", "targetFile", "project", "Lcom/intellij/openapi/project/Project;", "Companion", "intellij.markdown.backend"})
@SourceDebugExtension(value={"SMAP\nMarkdownLinkOpenerRemoteApiImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MarkdownLinkOpenerRemoteApiImpl.kt\ncom/intellij/markdown/backend/services/MarkdownLinkOpenerRemoteApiImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,122:1\n1563#2:123\n1634#2,3:124\n*S KotlinDebug\n*F\n+ 1 MarkdownLinkOpenerRemoteApiImpl.kt\ncom/intellij/markdown/backend/services/MarkdownLinkOpenerRemoteApiImpl\n*L\n119#1:123\n119#1:124,3\n*E\n"})
public final class MarkdownLinkOpenerRemoteApiImpl
implements MarkdownLinkOpenerRemoteApi {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger logger;

    @Nullable
    public Object fetchLinkNavigationData(@NotNull String link, @Nullable VirtualFileId virtualFileId, @NotNull Continuation<? super MarkdownLinkNavigationData> $completion) {
        VirtualFile virtualFile = this.resolveLinkAsFile(link, virtualFileId);
        if (virtualFile == null) {
            return new MarkdownLinkNavigationData(link, null, null, null);
        }
        VirtualFile file = virtualFile;
        String string = file.getUrl();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUrl(...)");
        Object path = string;
        Project project = ProjectUtil.guessProjectForFile((VirtualFile)file);
        if (project == null) {
            return new MarkdownLinkNavigationData((String)path, VirtualFileIdKt.rpcId((VirtualFile)file), null, null);
        }
        Project project2 = project;
        String anchor = MarkdownLinkOpenerRemoteApiImpl.Companion.extractAnchor(link);
        if (((CharSequence)anchor).length() == 0) {
            return new MarkdownLinkNavigationData((String)path, VirtualFileIdKt.rpcId((VirtualFile)file), ProjectIdKt.projectId((Project)project2), null);
        }
        path = (String)path + "#" + anchor;
        List<MarkdownHeaderInfo> headers = this.collectHeaders(anchor, file, project2);
        return new MarkdownLinkNavigationData((String)path, VirtualFileIdKt.rpcId((VirtualFile)file), ProjectIdKt.projectId((Project)project2), headers);
    }

    private final VirtualFile resolveLinkAsFile(String link, VirtualFileId virtualFileId) {
        VirtualFile virtualFile;
        URI uri;
        if (BrowserUtil.isAbsoluteURL((String)link) && (uri = MarkdownLinkOpenerRemoteApiImpl.Companion.createUri(link)) != null && Intrinsics.areEqual((Object)uri.getScheme(), (Object)"file")) {
            return MarkdownLinkOpenerRemoteApiImpl.Companion.findVirtualFile(uri);
        }
        VirtualFileId virtualFileId2 = virtualFileId;
        if (virtualFileId2 == null || (virtualFileId2 = VirtualFileIdKt.virtualFile((VirtualFileId)virtualFileId2)) == null || (virtualFileId2 = virtualFileId2.getParent()) == null) {
            return null;
        }
        VirtualFileId containingFile = virtualFileId2;
        try {
            virtualFile = VirtualFileUtil.findFile((VirtualFile)containingFile, (String)MarkdownLinkOpenerRemoteApiImpl.Companion.trimAnchor(link));
        }
        catch (IOException iOException) {
            virtualFile = null;
        }
        catch (InvalidPathException invalidPathException) {
            virtualFile = null;
        }
        return virtualFile;
    }

    private final List<MarkdownHeaderInfo> collectHeaders(String anchor, VirtualFile targetFile, Project project) {
        return (List)ActionsKt.runReadAction(() -> MarkdownLinkOpenerRemoteApiImpl.collectHeaders$lambda$0(project, targetFile, anchor));
    }

    /*
     * WARNING - void declaration
     */
    private static final List collectHeaders$lambda$0(Project $project, VirtualFile $targetFile, String $anchor) {
        void $this$mapTo$iv$iv;
        if (DumbService.Companion.isDumb($project)) {
            return CollectionsKt.emptyList();
        }
        PsiFile file = PsiManager.getInstance((Project)$project).findFile($targetFile);
        GlobalSearchScope scope = file == null ? GlobalSearchScope.EMPTY_SCOPE : GlobalSearchScope.fileScope((PsiFile)file);
        Intrinsics.checkNotNull((Object)scope);
        Iterable $this$map$iv = HeaderAnchorIndex.Companion.collectHeaders($project, scope, $anchor);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            MarkdownHeader markdownHeader = (MarkdownHeader)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(MarkdownHeaderMapper.map((MarkdownHeader)p0));
        }
        return (List)destination$iv$iv;
    }

    static {
        Logger logger = Logger.getInstance(MarkdownLinkOpenerRemoteApiImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        MarkdownLinkOpenerRemoteApiImpl.logger = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0002J\f\u0010\t\u001a\u00020\u0007*\u00020\u0007H\u0002J\u000e\u0010\n\u001a\u0004\u0018\u00010\u000b*\u00020\fH\u0002J\u0012\u0010\r\u001a\u0004\u0018\u00010\f2\u0006\u0010\b\u001a\u00020\u0007H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/markdown/backend/services/MarkdownLinkOpenerRemoteApiImpl$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "extractAnchor", "", "link", "trimAnchor", "findVirtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "Ljava/net/URI;", "createUri", "intellij.markdown.backend"})
    public static final class Companion {
        private Companion() {
        }

        private final String extractAnchor(String link) {
            int lastHashIndex = StringsKt.lastIndexOf$default((CharSequence)link, (char)'#', (int)0, (boolean)false, (int)6, null);
            if (lastHashIndex == -1) {
                return "";
            }
            String string = link.substring(lastHashIndex + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String potentialAnchor = string;
            if (StringsKt.contains$default((CharSequence)potentialAnchor, (CharSequence)"/", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)potentialAnchor, (CharSequence)"\\", (boolean)false, (int)2, null)) {
                return "";
            }
            return potentialAnchor;
        }

        private final String trimAnchor(String $this$trimAnchor) {
            String string;
            int anchorIndex = StringsKt.lastIndexOf$default((CharSequence)$this$trimAnchor, (char)'#', (int)0, (boolean)false, (int)6, null);
            if (anchorIndex == -1) {
                string = $this$trimAnchor;
            } else {
                String string2 = $this$trimAnchor.substring(0, anchorIndex);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            }
            return string;
        }

        private final VirtualFile findVirtualFile(URI $this$findVirtualFile) {
            String actualPath = SystemInfo.isWindows ? UriUtil.trimLeadingSlashes((String)$this$findVirtualFile.getPath()) : $this$findVirtualFile.getPath();
            Path path = Path.of(actualPath, new String[0]);
            return VfsUtil.findFile((Path)path, (boolean)true);
        }

        private final URI createUri(String link) {
            URI uRI;
            try {
                uRI = new URI(link);
            }
            catch (URISyntaxException exception) {
                logger.warn((Throwable)exception);
                uRI = null;
            }
            return uRI;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

