/*
 * Decompiled with CFR 0.152.
 */
package edu.washington.cs.knowitall.logic;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import edu.washington.cs.knowitall.logic.Expression;
import edu.washington.cs.knowitall.logic.LogicException;
import edu.washington.cs.knowitall.logic.LogicExpressionParser;
import edu.washington.cs.knowitall.logic.LogicExpressionParsers;
import java.util.ArrayList;
import java.util.EmptyStackException;
import java.util.LinkedList;
import java.util.List;
import java.util.Scanner;
import java.util.Stack;

public class LogicExpression<E>
implements Predicate<E> {
    private final Expression.Apply<E> expression;

    protected LogicExpression(List<Expression<E>> expressions) throws LogicException.TokenizeLogicException, LogicException.CompileLogicException {
        List<Expression<E>> rpn = this.rpn(expressions);
        this.expression = LogicExpression.buildAst(rpn);
    }

    public static <E> LogicExpression<E> compile(List<Expression<E>> expressions) {
        return new LogicExpression<E>(expressions);
    }

    public static <E> LogicExpression<E> compile(String input, final Function<String, Expression.Arg<E>> factoryDelegate) {
        return new LogicExpressionParser<E>(){

            @Override
            public Expression.Arg<E> factory(String argument) {
                return (Expression.Arg)factoryDelegate.apply((Object)argument);
            }
        }.parse(input);
    }

    public String toString() {
        if (this.isEmpty()) {
            return "(empty)";
        }
        return this.expression.toString();
    }

    public boolean isEmpty() {
        return this.expression == null;
    }

    public boolean apply(E entity) {
        if (this.isEmpty()) {
            return true;
        }
        return this.expression.apply(entity);
    }

    public static <E> Expression.Apply<E> buildAst(List<Expression<E>> rpn) {
        if (rpn.isEmpty()) {
            return null;
        }
        Stack<Expression.Apply> stack = new Stack<Expression.Apply>();
        for (Expression<E> tok : rpn) {
            if (tok instanceof Expression.Arg) {
                stack.push((Expression.Arg)tok);
                continue;
            }
            if (!(tok instanceof Expression.Op)) continue;
            try {
                if (tok instanceof Expression.Op.Mon) {
                    Expression.Apply sub = (Expression.Apply)stack.pop();
                    Expression.Op.Mon mon = (Expression.Op.Mon)tok;
                    mon.sub = sub;
                    stack.push(mon);
                }
                if (!(tok instanceof Expression.Op.Bin)) continue;
                Expression.Apply arg2 = (Expression.Apply)stack.pop();
                Expression.Apply arg1 = (Expression.Apply)stack.pop();
                Expression.Op.Bin bin = (Expression.Op.Bin)tok;
                bin.left = arg1;
                bin.right = arg2;
                stack.push(bin);
            }
            catch (EmptyStackException e) {
                throw new LogicException.CompileLogicException("No argument for operator (stack empty): " + tok.toString());
            }
        }
        if (stack.size() > 1) {
            throw new LogicException.ApplyLogicException("Stack has multiple elements after apply: " + stack.toString());
        }
        if (stack.size() == 0) {
            throw new LogicException.ApplyLogicException("Stack has zero elements after apply.");
        }
        if (!(stack.peek() instanceof Expression.Apply)) {
            throw new LogicException.ApplyLogicException("Stack contains non-appliable tokens after apply: " + stack.toString());
        }
        return (Expression.Apply)stack.pop();
    }

    public List<String> getArgs() {
        ArrayList<String> args = new ArrayList<String>();
        this.getArgs(this.expression, args);
        return args;
    }

    private void getArgs(Expression.Apply<?> apply, List<String> args) {
        if (apply instanceof Expression.Op.Bin) {
            Expression.Op.Bin bin = (Expression.Op.Bin)apply;
            this.getArgs(bin.left, args);
            this.getArgs(bin.right, args);
        } else if (apply instanceof Expression.Arg.Pred) {
            args.add(((Expression.Arg.Pred)apply).getDescription());
        }
    }

    public List<Expression<E>> rpn(List<Expression<E>> tokens) throws LogicException.CompileLogicException {
        Stack<Expression<E>> stack = new Stack<Expression<E>>();
        LinkedList<Expression<Expression>> output = new LinkedList<Expression<Expression>>();
        for (Expression<E> tok : tokens) {
            if (tok instanceof Expression.Paren.L) {
                stack.push(tok);
                continue;
            }
            if (tok instanceof Expression.Paren.R) {
                Expression top;
                do {
                    if ((top = (Expression)stack.pop()) instanceof Expression.Paren.L) continue;
                    output.offer(top);
                } while (!(top instanceof Expression.Paren.L));
                continue;
            }
            if (tok instanceof Expression.Op.Mon) {
                stack.push(tok);
                continue;
            }
            if (tok instanceof Expression.Op.Bin) {
                while (!stack.isEmpty() && stack.peek() instanceof Expression.Op && ((Expression.Op)stack.peek()).preceeds((Expression.Op)tok)) {
                    output.offer((Expression<Expression>)stack.pop());
                }
                stack.push(tok);
                continue;
            }
            if (!(tok instanceof Expression.Arg)) continue;
            output.offer(tok);
        }
        while (!stack.isEmpty()) {
            Expression top = (Expression)stack.pop();
            if (top instanceof Expression.Paren.L || top instanceof Expression.Paren.R) {
                throw new LogicException.CompileLogicException("Unbalanced parentheses.");
            }
            output.offer(top);
        }
        return output;
    }

    public static void main(String[] args) {
        Scanner scan = new Scanner(System.in);
        while (scan.hasNextLine()) {
            String line = scan.nextLine();
            LogicExpression<String> expr = LogicExpressionParsers.trivial.parse(line);
            System.out.println("string: " + expr.toString());
            System.out.println("value:  " + expr.apply(null));
            System.out.println();
        }
        scan.close();
    }
}

