/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.config;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageOrApiVersion;
import org.jetbrains.kotlin.config.LanguageVersion;
import org.jetbrains.kotlin.utils.DescriptionAware;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \n2\u00020\u0001:\u0003\b\t\nB\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0012\u0010\u0004\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u0082\u0001\u0002\u000b\f\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/config/VersionView;", "Lorg/jetbrains/kotlin/utils/DescriptionAware;", "<init>", "()V", "version", "Lorg/jetbrains/kotlin/config/LanguageOrApiVersion;", "getVersion", "()Lorg/jetbrains/kotlin/config/LanguageOrApiVersion;", "LatestStable", "Specific", "Companion", "Lorg/jetbrains/kotlin/config/VersionView$LatestStable;", "Lorg/jetbrains/kotlin/config/VersionView$Specific;", "jps-common"})
public abstract class VersionView
implements DescriptionAware {
    @NotNull
    public static final Companion Companion = new Companion(null);

    private VersionView() {
    }

    @NotNull
    public abstract LanguageOrApiVersion getVersion();

    public /* synthetic */ VersionView(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/config/VersionView$Companion;", "", "<init>", "()V", "deserialize", "Lorg/jetbrains/kotlin/config/VersionView;", "value", "", "isAutoAdvance", "", "jps-common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final VersionView deserialize(@Nullable String value, boolean isAutoAdvance) {
            if (isAutoAdvance) {
                return LatestStable.INSTANCE;
            }
            LanguageVersion languageVersion = LanguageVersion.Companion.fromVersionString(value);
            return languageVersion != null ? (VersionView)new Specific((LanguageOrApiVersion)languageVersion) : (VersionView)LatestStable.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/config/VersionView$LatestStable;", "Lorg/jetbrains/kotlin/config/VersionView;", "<init>", "()V", "version", "Lorg/jetbrains/kotlin/config/LanguageVersion;", "getVersion", "()Lorg/jetbrains/kotlin/config/LanguageVersion;", "description", "", "getDescription", "()Ljava/lang/String;", "jps-common"})
    public static final class LatestStable
    extends VersionView {
        @NotNull
        public static final LatestStable INSTANCE = new LatestStable();
        @NotNull
        private static final LanguageVersion version = LanguageVersion.LATEST_STABLE;

        private LatestStable() {
            super(null);
        }

        @NotNull
        public LanguageVersion getVersion() {
            return version;
        }

        @NotNull
        public String getDescription() {
            return "Latest stable (" + this.getVersion().getVersionString() + ')';
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0096\u0082\u0004J\n\u0010\u0010\u001a\u00020\u0011H\u0096\u0080\u0004R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/config/VersionView$Specific;", "Lorg/jetbrains/kotlin/config/VersionView;", "version", "Lorg/jetbrains/kotlin/config/LanguageOrApiVersion;", "<init>", "(Lorg/jetbrains/kotlin/config/LanguageOrApiVersion;)V", "getVersion", "()Lorg/jetbrains/kotlin/config/LanguageOrApiVersion;", "description", "", "getDescription", "()Ljava/lang/String;", "equals", "", "other", "", "hashCode", "", "jps-common"})
    public static final class Specific
    extends VersionView {
        @NotNull
        private final LanguageOrApiVersion version;

        public Specific(@NotNull LanguageOrApiVersion version) {
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            super(null);
            this.version = version;
        }

        @Override
        @NotNull
        public LanguageOrApiVersion getVersion() {
            return this.version;
        }

        @NotNull
        public String getDescription() {
            return this.getVersion().getDescription();
        }

        public boolean equals(@Nullable Object other) {
            return other instanceof Specific && Intrinsics.areEqual((Object)this.getVersion(), (Object)((Specific)other).getVersion());
        }

        public int hashCode() {
            return this.getVersion().hashCode();
        }
    }
}

