/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.jetbrains.java.decompiler.util.VBStyleCollection;

public class FastFixedSetFactory<E> {
    private final VBStyleCollection<int[], E> colValuesInternal = new VBStyleCollection();
    private final int dataLength;

    public FastFixedSetFactory(Collection<E> set) {
        this.dataLength = set.size() / 32 + 1;
        int index = 0;
        int mask = 1;
        for (E element : set) {
            int block = index / 32;
            if (index % 32 == 0) {
                mask = 1;
            }
            this.colValuesInternal.putWithKey(new int[]{block, mask}, (int[])element);
            ++index;
            mask <<= 1;
        }
    }

    public FastFixedSet<E> spawnEmptySet() {
        return new FastFixedSet(this);
    }

    private int getDataLength() {
        return this.dataLength;
    }

    private VBStyleCollection<int[], E> getInternalValuesCollection() {
        return this.colValuesInternal;
    }

    public static final class FastFixedSet<E>
    implements Iterable<E> {
        private final FastFixedSetFactory<E> factory;
        private final VBStyleCollection<int[], E> colValuesInternal;
        private int[] data;

        private FastFixedSet(FastFixedSetFactory<E> factory) {
            this.factory = factory;
            this.colValuesInternal = factory.getInternalValuesCollection();
            this.data = new int[factory.getDataLength()];
        }

        public FastFixedSet<E> getCopy() {
            FastFixedSet<E> copy = new FastFixedSet<E>(this.factory);
            int arrlength = this.data.length;
            int[] cpdata = Arrays.copyOf(this.data, arrlength);
            copy.setData(cpdata);
            return copy;
        }

        public void setAllElements() {
            int[] lastindex = (int[])this.colValuesInternal.get(this.colValuesInternal.size() - 1);
            for (int i = lastindex[0] - 1; i >= 0; --i) {
                this.data[i] = -1;
            }
            this.data[lastindex[0]] = lastindex[1] | lastindex[1] - 1;
        }

        public void add(E element) {
            int[] index = this.colValuesInternal.getWithKey(element);
            int n = index[0];
            this.data[n] = this.data[n] | index[1];
        }

        public void addAll(Collection<E> set) {
            for (E element : set) {
                this.add(element);
            }
        }

        public void remove(E element) {
            int[] index = this.colValuesInternal.getWithKey(element);
            int n = index[0];
            this.data[n] = this.data[n] & ~index[1];
        }

        public boolean contains(E element) {
            int[] index = this.colValuesInternal.getWithKey(element);
            return (this.data[index[0]] & index[1]) != 0;
        }

        public boolean contains(FastFixedSet<E> set) {
            int[] extdata = set.getData();
            int[] intdata = this.data;
            for (int i = intdata.length - 1; i >= 0; --i) {
                if ((extdata[i] & ~intdata[i]) == 0) continue;
                return false;
            }
            return true;
        }

        public void union(FastFixedSet<E> set) {
            int[] extdata = set.getData();
            int[] intdata = this.data;
            for (int i = intdata.length - 1; i >= 0; --i) {
                int n = i;
                intdata[n] = intdata[n] | extdata[i];
            }
        }

        public void intersection(FastFixedSet<E> set) {
            int[] extdata = set.getData();
            int[] intdata = this.data;
            for (int i = intdata.length - 1; i >= 0; --i) {
                int n = i;
                intdata[n] = intdata[n] & extdata[i];
            }
        }

        public void complement(FastFixedSet<E> set) {
            int[] extdata = set.getData();
            int[] intdata = this.data;
            for (int i = intdata.length - 1; i >= 0; --i) {
                int n = i;
                intdata[n] = intdata[n] & ~extdata[i];
            }
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FastFixedSet)) {
                return false;
            }
            int[] extdata = ((FastFixedSet)o).getData();
            int[] intdata = this.data;
            for (int i = intdata.length - 1; i >= 0; --i) {
                if (intdata[i] == extdata[i]) continue;
                return false;
            }
            return true;
        }

        public boolean isEmpty() {
            int[] intdata = this.data;
            for (int i = intdata.length - 1; i >= 0; --i) {
                if (intdata[i] == 0) continue;
                return false;
            }
            return true;
        }

        @Override
        public Iterator<E> iterator() {
            return new FastFixedSetIterator(this);
        }

        public Set<E> toPlainSet() {
            return this.toPlainCollection(new HashSet());
        }

        private <T extends Collection<E>> T toPlainCollection(T cl) {
            int[] intdata = this.data;
            for (int bindex = 0; bindex < intdata.length; ++bindex) {
                int block = intdata[bindex];
                if (block == 0) continue;
                int index = bindex << 5;
                for (int i = 31; i >= 0; --i) {
                    if ((block & 1) != 0) {
                        cl.add(this.colValuesInternal.getKey(index));
                    }
                    ++index;
                    block >>>= 1;
                }
            }
            return cl;
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder("{");
            int[] intdata = this.data;
            boolean first = true;
            for (int i = this.colValuesInternal.size() - 1; i >= 0; --i) {
                int[] index = (int[])this.colValuesInternal.get(i);
                if ((intdata[index[0]] & index[1]) == 0) continue;
                if (first) {
                    first = false;
                } else {
                    buffer.append(",");
                }
                buffer.append(this.colValuesInternal.getKey(i));
            }
            buffer.append("}");
            return buffer.toString();
        }

        private int[] getData() {
            return this.data;
        }

        private void setData(int[] data) {
            this.data = data;
        }

        public FastFixedSetFactory<E> getFactory() {
            return this.factory;
        }
    }

    public static final class FastFixedSetIterator<E>
    implements Iterator<E> {
        private final VBStyleCollection<int[], E> colValuesInternal;
        private final int[] data;
        private final int size;
        private int pointer = -1;
        private int next_pointer = -1;

        private FastFixedSetIterator(FastFixedSet<E> set) {
            this.colValuesInternal = set.getFactory().getInternalValuesCollection();
            this.data = set.getData();
            this.size = this.colValuesInternal.size();
        }

        private int getNextIndex(int index) {
            int ret = ++index;
            int dindex = index % 32;
            for (int bindex = index / 32; bindex < this.data.length; ++bindex) {
                int block = this.data[bindex];
                if (block != 0) {
                    block >>>= dindex;
                    while (dindex < 32) {
                        if ((block & 1) != 0) {
                            return ret;
                        }
                        block >>>= 1;
                        ++dindex;
                        ++ret;
                    }
                } else {
                    ret += 32 - dindex;
                }
                dindex = 0;
            }
            return -1;
        }

        @Override
        public boolean hasNext() {
            this.next_pointer = this.getNextIndex(this.pointer);
            return this.next_pointer >= 0;
        }

        @Override
        public E next() {
            if (this.next_pointer >= 0) {
                this.pointer = this.next_pointer;
            } else {
                this.pointer = this.getNextIndex(this.pointer);
                if (this.pointer == -1) {
                    this.pointer = this.size;
                }
            }
            this.next_pointer = -1;
            return this.pointer < this.size ? (E)this.colValuesInternal.getKey(this.pointer) : null;
        }

        @Override
        public void remove() {
            int[] index = (int[])this.colValuesInternal.get(this.pointer);
            int n = index[0];
            this.data[n] = this.data[n] & ~index[1];
        }
    }
}

