/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.renamer;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.jetbrains.java.decompiler.main.extern.IMemberIdentifierRenamer;

public class MemberConverterHelper
implements IMemberIdentifierRenamer {
    private static final Set<String> KEYWORDS = new HashSet<String>(Arrays.asList("abstract", "do", "if", "package", "synchronized", "boolean", "double", "implements", "private", "this", "break", "else", "import", "protected", "throw", "byte", "extends", "instanceof", "public", "throws", "case", "false", "int", "return", "transient", "catch", "final", "interface", "short", "true", "char", "finally", "long", "static", "try", "class", "float", "native", "strictfp", "void", "const", "for", "new", "super", "volatile", "continue", "goto", "null", "switch", "while", "default", "assert", "enum"));
    private static final Set<String> RESERVED_WINDOWS_NAMESPACE = new HashSet<String>(Arrays.asList("con", "prn", "aux", "nul", "com1", "com2", "com3", "com4", "com5", "com6", "com7", "com8", "com9", "lpt1", "lpt2", "lpt3", "lpt4", "lpt5", "lpt6", "lpt7", "lpt8", "lpt9"));
    private int classCounter = 0;
    private int fieldCounter = 0;
    private int methodCounter = 0;
    private final Set<String> setNonStandardClassNames = new HashSet<String>();

    @Override
    public boolean toBeRenamed(IMemberIdentifierRenamer.Type elementType, String className, String element, String descriptor) {
        String value;
        String string = value = elementType == IMemberIdentifierRenamer.Type.ELEMENT_CLASS ? className : element;
        return value == null || value.length() <= 2 || !MemberConverterHelper.isValidIdentifier(elementType == IMemberIdentifierRenamer.Type.ELEMENT_METHOD, value) || KEYWORDS.contains(value) || elementType == IMemberIdentifierRenamer.Type.ELEMENT_CLASS && (RESERVED_WINDOWS_NAMESPACE.contains(value.toLowerCase(Locale.ENGLISH)) || value.length() > 255 - ".class".length());
    }

    private static boolean isValidIdentifier(boolean isMethod, String identifier) {
        assert (identifier != null) : "Null identifier passed to the isValidIdentifier() method.";
        assert (!identifier.isEmpty()) : "Empty identifier passed to the isValidIdentifier() method.";
        if (isMethod && (identifier.equals("<init>") || identifier.equals("<clinit>"))) {
            return true;
        }
        if (!Character.isJavaIdentifierStart(identifier.charAt(0))) {
            return false;
        }
        char[] chars = identifier.toCharArray();
        for (int i = 1; i < chars.length; ++i) {
            char ch = chars[i];
            if (Character.isJavaIdentifierPart(ch) && !Character.isIdentifierIgnorable(ch)) continue;
            return false;
        }
        return true;
    }

    @Override
    public String getNextClassName(String fullName, String shortName) {
        int index;
        if (shortName == null) {
            return "class_" + this.classCounter++;
        }
        for (index = 0; index < shortName.length() && Character.isDigit(shortName.charAt(index)); ++index) {
        }
        if (index == 0 || index == shortName.length()) {
            return "class_" + this.classCounter++;
        }
        String name = shortName.substring(index);
        if (this.setNonStandardClassNames.contains(name)) {
            return "Inner" + name + "_" + this.classCounter++;
        }
        this.setNonStandardClassNames.add(name);
        return "Inner" + name;
    }

    @Override
    public String getNextFieldName(String className, String field, String descriptor) {
        return "field_" + this.fieldCounter++;
    }

    @Override
    public String getNextMethodName(String className, String method, String descriptor) {
        return "method_" + this.methodCounter++;
    }

    public static String getSimpleClassName(String fullName) {
        return fullName.substring(fullName.lastIndexOf(47) + 1);
    }

    public static String replaceSimpleClassName(String fullName, String newName) {
        return fullName.substring(0, fullName.lastIndexOf(47) + 1) + newName;
    }
}

