/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.utils;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityStateListener;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorEventMulticaster;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.util.Alarm;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JComponent;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.utils.MavenUtil;

public final class MavenMergingUpdateQueue
extends MergingUpdateQueue {
    private static final Logger LOG = Logger.getInstance(MavenMergingUpdateQueue.class);
    private final AtomicInteger mySuspendCounter;

    public MavenMergingUpdateQueue(String name, int mergingTimeSpan, boolean isActive, @NotNull CoroutineScope coroutineScope) {
        if (coroutineScope == null) {
            MavenMergingUpdateQueue.$$$reportNull$$$0(0);
        }
        super(name, mergingTimeSpan, isActive, ANY_COMPONENT, null, null, Alarm.ThreadToUse.POOLED_THREAD, coroutineScope);
        this.mySuspendCounter = new AtomicInteger(0);
    }

    public MavenMergingUpdateQueue(String name, int mergingTimeSpan, boolean isActive, @NotNull Disposable disposable) {
        if (disposable == null) {
            MavenMergingUpdateQueue.$$$reportNull$$$0(1);
        }
        super(name, mergingTimeSpan, isActive, ANY_COMPONENT, disposable, null, Alarm.ThreadToUse.POOLED_THREAD, null);
        this.mySuspendCounter = new AtomicInteger(0);
    }

    public MavenMergingUpdateQueue(String name, int mergingTimeSpan, boolean isActive, JComponent modalityStateComponent, Disposable parent) {
        super(name, mergingTimeSpan, isActive, modalityStateComponent, parent, null, false);
        this.mySuspendCounter = new AtomicInteger(0);
    }

    public void queue(@NotNull Update update2) {
        if (update2 == null) {
            MavenMergingUpdateQueue.$$$reportNull$$$0(2);
        }
        boolean passThrough = false;
        if (MavenUtil.isMavenUnitTestModeEnabled()) {
            passThrough = this.isPassThrough();
        }
        if (passThrough) {
            update2.run();
            return;
        }
        super.queue(update2);
    }

    public void makeUserAware(Project project) {
        EditorEventMulticaster multicaster = EditorFactory.getInstance().getEventMulticaster();
        multicaster.addCaretListener(new CaretListener(){

            public void caretPositionChanged(@NotNull CaretEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                MavenMergingUpdateQueue.this.restartTimer();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/idea/maven/utils/MavenMergingUpdateQueue$1", "caretPositionChanged"));
            }
        }, (Disposable)this);
        multicaster.addDocumentListener(new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                MavenMergingUpdateQueue.this.restartTimer();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/idea/maven/utils/MavenMergingUpdateQueue$2", "documentChanged"));
            }
        }, (Disposable)this);
        project.getMessageBus().connect((Disposable)this).subscribe(ModuleRootListener.TOPIC, (Object)new ModuleRootListener(){
            int beforeCalled;

            public void beforeRootsChange(@NotNull ModuleRootEvent event) {
                if (event == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (this.beforeCalled++ == 0) {
                    MavenMergingUpdateQueue.this.suspend();
                }
            }

            public void rootsChanged(@NotNull ModuleRootEvent event) {
                if (event == null) {
                    3.$$$reportNull$$$0(1);
                }
                if (this.beforeCalled == 0) {
                    return;
                }
                if (--this.beforeCalled == 0) {
                    MavenMergingUpdateQueue.this.resume();
                    MavenMergingUpdateQueue.this.restartTimer();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "org/jetbrains/idea/maven/utils/MavenMergingUpdateQueue$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "beforeRootsChange";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "rootsChanged";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public void makeModalAware(Project project) {
        MavenUtil.invokeLater(project, () -> {
            ModalityStateListener listener2 = new ModalityStateListener(){

                public void beforeModalityStateChanged(boolean entering, @NotNull Object modalEntity) {
                    if (modalEntity == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    if (entering) {
                        MavenMergingUpdateQueue.this.suspend();
                    } else {
                        MavenMergingUpdateQueue.this.resume();
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modalEntity", "org/jetbrains/idea/maven/utils/MavenMergingUpdateQueue$4", "beforeModalityStateChanged"));
                }
            };
            LaterInvocator.addModalityStateListener((ModalityStateListener)listener2, (Disposable)this);
            if (MavenUtil.isInModalContext()) {
                this.suspend();
            }
        });
    }

    public void suspend() {
        if (this.mySuspendCounter.incrementAndGet() == 1) {
            super.suspend();
        }
    }

    public void resume() {
        int c = this.mySuspendCounter.decrementAndGet();
        if (c <= 0) {
            if (c < 0) {
                this.mySuspendCounter.set(0);
                if (!ApplicationManager.getApplication().isUnitTestMode()) {
                    LOG.warn("Invalid suspend counter state", (Throwable)new Exception());
                }
            }
            super.resume();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coroutineScope";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "update";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/maven/utils/MavenMergingUpdateQueue";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "queue";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

