/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.startup.importSettings.chooser.ui;

import com.intellij.ide.startup.importSettings.chooser.ui.RoundedPanel;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.geom.Area;
import java.awt.geom.RoundRectangle2D;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0016\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0004\b\b\u0010\tJ:\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0003H\u0016J8\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0012\u0010\u001b\u001a\u00020\u001c2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/ide/startup/importSettings/chooser/ui/RoundedBorder;", "Ljavax/swing/border/Border;", "unscaledAreaThickness", "", "unscaledThickness", "color", "Ljava/awt/Color;", "unscaledRadius", "<init>", "(IILjava/awt/Color;I)V", "areaThickness", "thickness", "arcSize", "paintBorder", "", "c", "Ljava/awt/Component;", "g", "Ljava/awt/Graphics;", "x", "y", "width", "height", "createArea", "Ljava/awt/geom/Area;", "th", "", "getBorderInsets", "Ljava/awt/Insets;", "isBorderOpaque", "", "intellij.ide.startup.importSettings"})
public class RoundedBorder
implements Border {
    @NotNull
    private final Color color;
    private final int areaThickness;
    private final int thickness;
    private final int arcSize;

    public RoundedBorder(int unscaledAreaThickness, int unscaledThickness, @NotNull Color color, int unscaledRadius) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        this.color = color;
        this.areaThickness = JBUI.scale((int)unscaledAreaThickness);
        this.thickness = JBUI.scale((int)unscaledThickness);
        this.arcSize = JBUI.scale((int)unscaledRadius);
    }

    @Override
    public void paintBorder(@NotNull Component c, @Nullable Graphics g, int x, int y, int width, int height) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Intrinsics.checkNotNull((Object)g, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
        Graphics2D cfr_ignored_0 = (Graphics2D)g;
        GraphicsConfig config = GraphicsUtil.setupAAPainting((Graphics)g);
        ((Graphics2D)g).setColor(c.getBackground());
        ((Graphics2D)g).fillRect(x, y, width, height);
        double gap = Math.max(this.areaThickness - this.thickness, 0);
        Area area = this.createArea(x, y, width, height, this.arcSize, gap);
        if (c instanceof RoundedPanel) {
            ((Graphics2D)g).setColor(((RoundedPanel)c).getContentPanel().getBackground());
            ((Graphics2D)g).fill(area);
        }
        Area innerArea = this.createArea(x, y, width, height, this.arcSize, this.areaThickness);
        ((Graphics2D)g).setColor(this.color);
        area.subtract(innerArea);
        ((Graphics2D)g).fill(area);
        config.restore();
    }

    private final Area createArea(int x, int y, int width, int height, int arcSize, double th) {
        int innerArc = (int)Math.max((double)arcSize - th, 0.0);
        return new Area(new RoundRectangle2D.Double((double)x + th, (double)y + th, (double)width - (double)2 * th, (double)height - (double)2 * th, innerArc, innerArc));
    }

    @Override
    @NotNull
    public Insets getBorderInsets(@Nullable Component c) {
        JBInsets jBInsets = JBUI.insets((int)this.areaThickness);
        Intrinsics.checkNotNullExpressionValue((Object)jBInsets, (String)"insets(...)");
        return (Insets)jBInsets;
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }
}

