/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.scripting.compiler.plugin.repl.reader;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.repl.ReplUtilKt;
import org.jetbrains.kotlin.scripting.compiler.plugin.repl.reader.ReplSystemInWrapperKt;
import org.jetbrains.kotlin.scripting.compiler.plugin.repl.writer.ReplWriter;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0016\u001a\u00020\u000eH\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0002J\b\u0010\u0019\u001a\u00020\u001aH\u0002R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0012\"\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/scripting/compiler/plugin/repl/reader/ReplSystemInWrapper;", "Ljava/io/InputStream;", "stdin", "replWriter", "Lorg/jetbrains/kotlin/scripting/compiler/plugin/repl/writer/ReplWriter;", "<init>", "(Ljava/io/InputStream;Lorg/jetbrains/kotlin/scripting/compiler/plugin/repl/writer/ReplWriter;)V", "isXmlIncomplete", "", "isLastByteProcessed", "isReadLineStartSent", "byteBuilder", "Ljava/io/ByteArrayOutputStream;", "curBytePos", "", "inputByteArray", "", "isAtBufferEnd", "()Z", "isReplScriptExecuting", "setReplScriptExecuting", "(Z)V", "read", "parseInput", "", "resetBufferIfNeeded", "", "kotlin-scripting-compiler"})
public final class ReplSystemInWrapper
extends InputStream {
    @NotNull
    private final InputStream stdin;
    @NotNull
    private final ReplWriter replWriter;
    private boolean isXmlIncomplete;
    private boolean isLastByteProcessed;
    private boolean isReadLineStartSent;
    @NotNull
    private ByteArrayOutputStream byteBuilder;
    private int curBytePos;
    @NotNull
    private byte[] inputByteArray;
    private volatile boolean isReplScriptExecuting;

    public ReplSystemInWrapper(@NotNull InputStream stdin, @NotNull ReplWriter replWriter) {
        Intrinsics.checkNotNullParameter((Object)stdin, (String)"stdin");
        Intrinsics.checkNotNullParameter((Object)replWriter, (String)"replWriter");
        this.stdin = stdin;
        this.replWriter = replWriter;
        this.isXmlIncomplete = true;
        this.byteBuilder = new ByteArrayOutputStream();
        this.inputByteArray = new byte[0];
    }

    private final boolean isAtBufferEnd() {
        return this.curBytePos == this.inputByteArray.length;
    }

    public final boolean isReplScriptExecuting() {
        return this.isReplScriptExecuting;
    }

    public final void setReplScriptExecuting(boolean bl) {
        this.isReplScriptExecuting = bl;
    }

    @Override
    public int read() {
        if (this.isLastByteProcessed) {
            if (this.isReplScriptExecuting) {
                this.isReadLineStartSent = false;
                this.replWriter.notifyReadLineEnd();
            }
            this.isLastByteProcessed = false;
            return -1;
        }
        while (this.isXmlIncomplete) {
            if (!this.isReadLineStartSent && this.isReplScriptExecuting) {
                this.replWriter.notifyReadLineStart();
                this.isReadLineStartSent = true;
            }
            this.byteBuilder.write(this.stdin.read());
            String string = this.byteBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            if (!StringsKt.endsWith$default((CharSequence)string, (char)'\n', (boolean)false, (int)2, null)) continue;
            this.isXmlIncomplete = false;
            this.isLastByteProcessed = false;
            String string2 = this.parseInput();
            Intrinsics.checkNotNullExpressionValue((Object)string2.getBytes(Charsets.UTF_8), (String)"getBytes(...)");
            this.inputByteArray = this.inputByteArray;
        }
        int n = this.curBytePos;
        this.curBytePos = n + 1;
        byte nextByte = this.inputByteArray[n];
        this.resetBufferIfNeeded();
        return nextByte;
    }

    private final String parseInput() {
        String string = this.byteBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String xmlInput = string;
        String unescapedXml = ReplSystemInWrapperKt.access$parseXml(xmlInput);
        return this.isReplScriptExecuting ? ReplUtilKt.replUnescapeLineBreaks((String)unescapedXml) : unescapedXml;
    }

    private final void resetBufferIfNeeded() {
        if (this.isAtBufferEnd()) {
            this.isXmlIncomplete = true;
            this.byteBuilder = new ByteArrayOutputStream();
            this.curBytePos = 0;
            this.isLastByteProcessed = true;
        }
    }
}

