/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.packagesearch.packageversionutils.normalization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import kotlinx.datetime.Clock;
import kotlinx.datetime.Instant;
import kotlinx.datetime.LocalDateTime;
import kotlinx.datetime.TimeZone;
import kotlinx.datetime.TimeZoneKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.packagesearch.packageversionutils.normalization.DateTimeFormatter;
import org.jetbrains.packagesearch.packageversionutils.normalization.DateTimeFormatterKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u001d\u001a\u00020\u0006R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\bR\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\bR\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\bR!\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00128FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0018\u001a\u00020\u00198BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/packagesearch/packageversionutils/normalization/VeryLenientDateTimeExtractor;", "", "<init>", "()V", "basePatterns", "Lkotlin/sequences/Sequence;", "", "getBasePatterns", "()Lkotlin/sequences/Sequence;", "dateDividers", "getDateDividers", "timeDividers", "getTimeDividers", "dateTimeSeparators", "getDateTimeSeparators", "datePatterns", "getDatePatterns", "formatters", "", "Lorg/jetbrains/packagesearch/packageversionutils/normalization/DateTimeFormatter;", "getFormatters", "()Ljava/util/List;", "formatters$delegate", "Lkotlin/Lazy;", "currentYear", "", "getCurrentYear", "()I", "extractTimestampLookingPrefixOrNull", "versionName", "version-utils"})
@SourceDebugExtension(value={"SMAP\nVeryLenientDateTimeExtractor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VeryLenientDateTimeExtractor.kt\norg/jetbrains/packagesearch/packageversionutils/normalization/VeryLenientDateTimeExtractor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,78:1\n1611#2,9:79\n1863#2:88\n1864#2:90\n1620#2:91\n774#2:92\n865#2,2:93\n1557#2:95\n1628#2,3:96\n1#3:89\n*S KotlinDebug\n*F\n+ 1 VeryLenientDateTimeExtractor.kt\norg/jetbrains/packagesearch/packageversionutils/normalization/VeryLenientDateTimeExtractor\n*L\n73#1:79,9\n73#1:88\n73#1:90\n73#1:91\n74#1:92\n74#1:93,2\n75#1:95\n75#1:96,3\n73#1:89\n*E\n"})
public final class VeryLenientDateTimeExtractor {
    @NotNull
    public static final VeryLenientDateTimeExtractor INSTANCE = new VeryLenientDateTimeExtractor();
    @NotNull
    private static final Sequence<String> basePatterns;
    @NotNull
    private static final Sequence<String> dateDividers;
    @NotNull
    private static final Sequence<String> timeDividers;
    @NotNull
    private static final Sequence<String> dateTimeSeparators;
    @NotNull
    private static final Sequence<String> datePatterns;
    @NotNull
    private static final Lazy formatters$delegate;

    private VeryLenientDateTimeExtractor() {
    }

    @NotNull
    public final Sequence<String> getBasePatterns() {
        return basePatterns;
    }

    @NotNull
    public final Sequence<String> getDateDividers() {
        return dateDividers;
    }

    @NotNull
    public final Sequence<String> getTimeDividers() {
        return timeDividers;
    }

    @NotNull
    public final Sequence<String> getDateTimeSeparators() {
        return dateTimeSeparators;
    }

    @NotNull
    public final Sequence<String> getDatePatterns() {
        return datePatterns;
    }

    @NotNull
    public final List<DateTimeFormatter> getFormatters() {
        Lazy lazy = formatters$delegate;
        return (List)lazy.getValue();
    }

    private final int getCurrentYear() {
        return TimeZoneKt.toLocalDateTime((Instant)Clock.System.INSTANCE.now(), (TimeZone)TimeZone.Companion.currentSystemDefault()).getYear();
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final String extractTimestampLookingPrefixOrNull(@NotNull String versionName) {
        void $this$mapTo$iv$iv;
        LocalDateTime it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)versionName, (String)"versionName");
        Iterable $this$mapNotNull$iv = this.getFormatters();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            LocalDateTime it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            DateTimeFormatter it2 = (DateTimeFormatter)element$iv$iv;
            boolean bl2 = false;
            if (it2.parseOrNull(versionName) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapNotNullTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (LocalDateTime)element$iv$iv;
            boolean bl = false;
            if (!(it.getYear() > INSTANCE.getCurrentYear() + 1)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (LocalDateTime)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(StringsKt.substring((String)versionName, (IntRange)RangesKt.until((int)0, (int)it.toString().length())));
        }
        return (String)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
    }

    private static final String datePatterns$lambda$3$lambda$2$lambda$1$lambda$0(String $basePattern, String $dateDivider, String $timeDivider, String dateTimeSeparator) {
        Intrinsics.checkNotNullParameter((Object)$basePattern, (String)"$basePattern");
        Intrinsics.checkNotNullParameter((Object)$dateDivider, (String)"$dateDivider");
        Intrinsics.checkNotNullParameter((Object)$timeDivider, (String)"$timeDivider");
        Intrinsics.checkNotNullParameter((Object)dateTimeSeparator, (String)"dateTimeSeparator");
        return StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)$basePattern, (String)"/", (String)$dateDivider, (boolean)false, (int)4, null), (String)"_", (String)dateTimeSeparator, (boolean)false, (int)4, null), (String)":", (String)$timeDivider, (boolean)false, (int)4, null);
    }

    private static final Sequence datePatterns$lambda$3$lambda$2$lambda$1(String $basePattern, String $dateDivider, String timeDivider) {
        Intrinsics.checkNotNullParameter((Object)$basePattern, (String)"$basePattern");
        Intrinsics.checkNotNullParameter((Object)$dateDivider, (String)"$dateDivider");
        Intrinsics.checkNotNullParameter((Object)timeDivider, (String)"timeDivider");
        return SequencesKt.map(dateTimeSeparators, arg_0 -> VeryLenientDateTimeExtractor.datePatterns$lambda$3$lambda$2$lambda$1$lambda$0($basePattern, $dateDivider, timeDivider, arg_0));
    }

    private static final Sequence datePatterns$lambda$3$lambda$2(String $basePattern, String dateDivider) {
        Intrinsics.checkNotNullParameter((Object)$basePattern, (String)"$basePattern");
        Intrinsics.checkNotNullParameter((Object)dateDivider, (String)"dateDivider");
        return SequencesKt.flatMap(timeDividers, arg_0 -> VeryLenientDateTimeExtractor.datePatterns$lambda$3$lambda$2$lambda$1($basePattern, dateDivider, arg_0));
    }

    private static final Sequence datePatterns$lambda$3(String basePattern) {
        Intrinsics.checkNotNullParameter((Object)basePattern, (String)"basePattern");
        return SequencesKt.flatMap(dateDividers, arg_0 -> VeryLenientDateTimeExtractor.datePatterns$lambda$3$lambda$2(basePattern, arg_0));
    }

    private static final DateTimeFormatter formatters_delegate$lambda$5$lambda$4(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return DateTimeFormatterKt.DateTimeFormatter(it);
    }

    private static final List formatters_delegate$lambda$5() {
        return SequencesKt.toList((Sequence)SequencesKt.map(datePatterns, VeryLenientDateTimeExtractor::formatters_delegate$lambda$5$lambda$4));
    }

    static {
        Object[] objectArray = new String[]{"yyyy/MM/dd_HH:mm:ss", "yyyy/MM/dd_HH:mm", "yyyy/MM_HH:mm:ss", "yyyy/MM_HH:mm", "yyyy/MM/dd", "yyyy/MM"};
        basePatterns = SequencesKt.sequenceOf((Object[])objectArray);
        objectArray = new String[]{".", "-", ""};
        dateDividers = SequencesKt.sequenceOf((Object[])objectArray);
        objectArray = new String[]{".", "-", ""};
        timeDividers = SequencesKt.sequenceOf((Object[])objectArray);
        objectArray = new String[]{".", "-", "'T'", ""};
        dateTimeSeparators = SequencesKt.sequenceOf((Object[])objectArray);
        datePatterns = SequencesKt.flatMap(basePatterns, VeryLenientDateTimeExtractor::datePatterns$lambda$3);
        formatters$delegate = LazyKt.lazy(VeryLenientDateTimeExtractor::formatters_delegate$lambda$5);
    }
}

