/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.jvm.checkers.expression;

import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory3;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.diagnostics.rendering.RenderingUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.diagnostics.jvm.FirJvmErrors;
import org.jetbrains.kotlin.fir.expressions.ExplicitTypeArgumentIfMadeFlexibleSyntheticallyTypeAttribute;
import org.jetbrains.kotlin.fir.expressions.ExplicitTypeArgumentIfMadeFlexibleSyntheticallyTypeAttributeKt;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.java.enhancement.EnhancedForWarningConeSubstitutor;
import org.jetbrains.kotlin.fir.java.enhancement.EnhancedTypeForWarningAttributeKt;
import org.jetbrains.kotlin.fir.types.ConeErrorType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a)\u0010\u0000\u001a\u00020\u0001*\u00020\u0006H\u0002R\u00020\u0002R\u00020\u0004j\u0006\u0010\u0003\u001a\u00020\u0002j\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0007\u001aM\u0010\b\u001a\u00020\u0001*\u00020\u00062\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0018\u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\r0\fH\u0000R\u00020\u0004R\u00020\u0002j\u0006\u0010\u0005\u001a\u00020\u0004j\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u000e\u001a\f\u0010\u000f\u001a\u00020\u0010*\u00020\nH\u0002\u001a;\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\n2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0002R\u00020\u0002j\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0014\u00a8\u0006\u0015"}, d2={"checkConditionForEnhancedTypeMismatch", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/expressions/FirExpression;)V", "checkExpressionForEnhancedTypeMismatch", "expectedType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "factory", "Lorg/jetbrains/kotlin/diagnostics/KtDiagnosticFactory3;", "", "(Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/expressions/FirExpression;Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;Lorg/jetbrains/kotlin/diagnostics/KtDiagnosticFactory3;)V", "isExplicitTypeArgumentMadeFlexibleSynthetically", "", "getEnhancedTypesForComparison", "Lkotlin/Pair;", "actualType", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;)Lkotlin/Pair;", "checkers.jvm"})
public final class FirExpressionJavaNullabilityWarningCheckersKt {
    private static final void checkConditionForEnhancedTypeMismatch(CheckerContext context2, DiagnosticReporter reporter, FirExpression $this$checkConditionForEnhancedTypeMismatch) {
        FirExpressionJavaNullabilityWarningCheckersKt.checkExpressionForEnhancedTypeMismatch(reporter, context2, $this$checkConditionForEnhancedTypeMismatch, context2.getSession().getBuiltinTypes().getBooleanType().getConeType(), FirJvmErrors.INSTANCE.getNULLABILITY_MISMATCH_BASED_ON_JAVA_ANNOTATIONS());
    }

    public static final void checkExpressionForEnhancedTypeMismatch(@NotNull DiagnosticReporter reporter, @NotNull CheckerContext context2, @NotNull FirExpression $this$checkExpressionForEnhancedTypeMismatch, @Nullable ConeKotlinType expectedType, @NotNull KtDiagnosticFactory3<ConeKotlinType, ConeKotlinType, String> factory) {
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter($this$checkExpressionForEnhancedTypeMismatch, "<this>");
        Intrinsics.checkNotNullParameter(factory, "factory");
        if (expectedType == null) {
            return;
        }
        ConeKotlinType actualType = FirTypeUtilsKt.getResolvedType($this$checkExpressionForEnhancedTypeMismatch);
        Pair<ConeKotlinType, ConeKotlinType> pair = FirExpressionJavaNullabilityWarningCheckersKt.getEnhancedTypesForComparison(context2, actualType, expectedType);
        if (pair == null) {
            return;
        }
        Pair<ConeKotlinType, ConeKotlinType> pair2 = pair;
        ConeKotlinType actualTypeForComparison = pair2.component1();
        ConeKotlinType expectedTypeForComparison = pair2.component2();
        if (!TypeUtilsKt.isSubtypeOf(actualTypeForComparison, TypeComponentsKt.getTypeContext(context2.getSession()), expectedTypeForComparison) && TypeUtilsKt.isSubtypeOf(actualType, TypeComponentsKt.getTypeContext(context2.getSession()), expectedType)) {
            StringBuilder stringBuilder;
            KtDiagnosticFactory3<ConeKotlinType, ConeKotlinType, String> resultingFactory = null;
            resultingFactory = factory;
            StringBuilder $this$checkExpressionForEnhancedTypeMismatch_u24lambda_u240 = stringBuilder = new StringBuilder();
            boolean bl = false;
            if (EnhancedTypeForWarningAttributeKt.isEnhancedTypeForWarningDeprecation(actualType) || EnhancedTypeForWarningAttributeKt.isEnhancedTypeForWarningDeprecation(expectedType)) {
                RenderingUtilsKt.appendDeprecationWarningSuffix($this$checkExpressionForEnhancedTypeMismatch_u24lambda_u240, LanguageFeature.SupportJavaErrorEnhancementOfArgumentsOfWarningLevelEnhanced);
            } else if (FirExpressionJavaNullabilityWarningCheckersKt.isExplicitTypeArgumentMadeFlexibleSynthetically(actualType) || FirExpressionJavaNullabilityWarningCheckersKt.isExplicitTypeArgumentMadeFlexibleSynthetically(expectedType)) {
                RenderingUtilsKt.appendDeprecationWarningSuffix($this$checkExpressionForEnhancedTypeMismatch_u24lambda_u240, LanguageFeature.DontMakeExplicitJavaTypeArgumentsFlexible);
                resultingFactory = FirJvmErrors.INSTANCE.getNULLABILITY_MISMATCH_BASED_ON_EXPLICIT_TYPE_ARGUMENTS_FOR_JAVA();
            }
            String suffix = stringBuilder.toString();
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)$this$checkExpressionForEnhancedTypeMismatch.getSource(), resultingFactory, (Object)actualTypeForComparison, (Object)expectedTypeForComparison, (Object)suffix, null, 64, null);
        }
    }

    private static final boolean isExplicitTypeArgumentMadeFlexibleSynthetically(ConeKotlinType $this$isExplicitTypeArgumentMadeFlexibleSynthetically) {
        ExplicitTypeArgumentIfMadeFlexibleSyntheticallyTypeAttribute explicitTypeArgumentIfMadeFlexibleSyntheticallyTypeAttribute = ExplicitTypeArgumentIfMadeFlexibleSyntheticallyTypeAttributeKt.getExplicitTypeArgumentIfMadeFlexibleSynthetically($this$isExplicitTypeArgumentMadeFlexibleSynthetically.getAttributes());
        return (explicitTypeArgumentIfMadeFlexibleSyntheticallyTypeAttribute != null ? explicitTypeArgumentIfMadeFlexibleSyntheticallyTypeAttribute.getRelevantFeature() : null) == LanguageFeature.DontMakeExplicitJavaTypeArgumentsFlexible;
    }

    private static final Pair<ConeKotlinType, ConeKotlinType> getEnhancedTypesForComparison(CheckerContext context2, ConeKotlinType actualType, ConeKotlinType expectedType) {
        ConeKotlinType coneKotlinType;
        ConeKotlinType actualTypeForComparison;
        if (actualType == null || expectedType == null) {
            return null;
        }
        if (actualType instanceof ConeErrorType || expectedType instanceof ConeErrorType) {
            return null;
        }
        EnhancedForWarningConeSubstitutor substitutor2 = new EnhancedForWarningConeSubstitutor(TypeComponentsKt.getTypeContext(context2.getSession()), LanguageFeature.DontMakeExplicitJavaTypeArgumentsFlexible);
        ConeKotlinType enhancedActualType = substitutor2.substituteOrNull(actualType);
        ConeKotlinType enhancedExpectedType = substitutor2.substituteOrNull(expectedType);
        if (enhancedActualType == null && enhancedExpectedType == null) {
            return null;
        }
        ConeKotlinType coneKotlinType2 = enhancedActualType;
        if (coneKotlinType2 == null) {
            coneKotlinType2 = actualTypeForComparison = actualType;
        }
        if ((coneKotlinType = enhancedExpectedType) == null) {
            coneKotlinType = expectedType;
        }
        ConeKotlinType expectedTypeForComparison = coneKotlinType;
        return TuplesKt.to(actualTypeForComparison, expectedTypeForComparison);
    }

    public static final /* synthetic */ void access$checkConditionForEnhancedTypeMismatch(CheckerContext context2, DiagnosticReporter reporter, FirExpression $receiver) {
        FirExpressionJavaNullabilityWarningCheckersKt.checkConditionForEnhancedTypeMismatch(context2, reporter, $receiver);
    }
}

