/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.js.checkers.declaration;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.js.FirJsErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.JsStandardClassIds;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\rJ7\u0010\u000e\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00022\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\u0011J7\u0010\u0012\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00022\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\u0011J\f\u0010\u0013\u001a\u00020\u0014*\u00020\u0015H\u0002J\u0018\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0014H\u0002J7\u0010\u0019\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00022\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\u0011J\u0010\u0010\u001a\u001a\u00020\u001b*\u0006\u0012\u0002\b\u00030\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\u001b*\u0006\u0012\u0002\b\u00030\u001cH\u0002J\u001e\u0010\u001e\u001a\u0004\u0018\u00010\u001f*\u00020\u00022\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0002\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/js/checkers/declaration/FirJsStaticChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "declaration", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;)V", "checkAnnotated", "targetSource", "Lorg/jetbrains/kotlin/KtSourceElement;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;Lorg/jetbrains/kotlin/KtSourceElement;)V", "checkVisibility", "getMinimumVisibility", "Lorg/jetbrains/kotlin/descriptors/Visibility;", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "chooseMostSpecific", "a", "b", "checkStaticOnConst", "containerIsInterface", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "isCompanion", "findAnnotation", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotation;", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "checkers.js"})
@SourceDebugExtension(value={"SMAP\nFirJsStaticChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirJsStaticChecker.kt\norg/jetbrains/kotlin/fir/analysis/js/checkers/declaration/FirJsStaticChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 4 ClassKind.kt\norg/jetbrains/kotlin/descriptors/ClassKindKt\n+ 5 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n+ 6 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,146:1\n1#2:147\n23#3:148\n23#3:149\n23#3:150\n23#3:151\n56#3:152\n34#4:153\n65#5:154\n295#6,2:155\n*S KotlinDebug\n*F\n+ 1 FirJsStaticChecker.kt\norg/jetbrains/kotlin/fir/analysis/js/checkers/declaration/FirJsStaticChecker\n*L\n94#1:148\n103#1:149\n106#1:150\n110#1:151\n131#1:152\n135#1:153\n138#1:154\n141#1:155,2\n*E\n"})
public final class FirJsStaticChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirJsStaticChecker INSTANCE = new FirJsStaticChecker();

    private FirJsStaticChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirDeclaration declaration) {
        block5: {
            FirPropertyAccessor it;
            Intrinsics.checkNotNullParameter(context2, "context");
            Intrinsics.checkNotNullParameter(reporter, "reporter");
            Intrinsics.checkNotNullParameter(declaration, "declaration");
            if (declaration instanceof FirConstructor) {
                return;
            }
            if (declaration instanceof FirPropertyAccessor) {
                return;
            }
            FirAnnotation declarationAnnotation = this.findAnnotation(declaration, JsStandardClassIds.Annotations.JsStatic, context2.getSession());
            if (declarationAnnotation != null) {
                this.checkAnnotated(context2, reporter, declaration, declaration.getSource());
            }
            if (!(declaration instanceof FirProperty)) break block5;
            FirPropertyAccessor firPropertyAccessor = ((FirProperty)declaration).getGetter();
            if (firPropertyAccessor != null) {
                it = firPropertyAccessor;
                boolean bl = false;
                FirJsStaticChecker.check$checkIfAnnotated(context2, declaration, reporter, it);
            }
            FirPropertyAccessor firPropertyAccessor2 = ((FirProperty)declaration).getSetter();
            if (firPropertyAccessor2 != null) {
                it = firPropertyAccessor2;
                boolean bl = false;
                FirJsStaticChecker.check$checkIfAnnotated(context2, declaration, reporter, it);
            }
        }
    }

    private final void checkAnnotated(CheckerContext context2, DiagnosticReporter reporter, FirDeclaration declaration, KtSourceElement targetSource) {
        if (!(declaration instanceof FirMemberDeclaration)) {
            return;
        }
        FirClassLikeSymbol<?> firClassLikeSymbol = FirHelpersKt.getContainingClassSymbol(declaration);
        if (firClassLikeSymbol == null) {
            return;
        }
        FirClassLikeSymbol<?> container = firClassLikeSymbol;
        if (!this.isCompanion(container) || this.containerIsInterface(container)) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)targetSource, FirJsErrors.INSTANCE.getJS_STATIC_NOT_IN_CLASS_COMPANION(), null, 8, null);
        }
        this.checkStaticOnConst(context2, reporter, declaration, targetSource);
        this.checkVisibility(context2, reporter, declaration, targetSource);
    }

    private final void checkVisibility(CheckerContext context2, DiagnosticReporter reporter, FirDeclaration declaration, KtSourceElement targetSource) {
        Visibility visibility;
        Visibility visibility2;
        if (!(declaration instanceof FirCallableDeclaration)) {
            return;
        }
        if (declaration instanceof FirProperty) {
            visibility2 = this.getMinimumVisibility((FirProperty)declaration);
        } else {
            FirMemberDeclaration $this$visibility$iv = (FirMemberDeclaration)declaration;
            boolean $i$f$getVisibility = false;
            visibility2 = visibility = $this$visibility$iv.getStatus().getVisibility();
        }
        if (!Intrinsics.areEqual(visibility, Visibilities.Public.INSTANCE)) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)targetSource, FirJsErrors.INSTANCE.getJS_STATIC_ON_NON_PUBLIC_MEMBER(), null, 8, null);
        }
    }

    private final Visibility getMinimumVisibility(FirProperty $this$getMinimumVisibility) {
        Visibility minVisibility;
        block1: {
            boolean $i$f$getVisibility;
            FirMemberDeclaration $this$visibility$iv;
            FirPropertyAccessor it;
            minVisibility = null;
            FirMemberDeclaration $this$visibility$iv2 = $this$getMinimumVisibility;
            boolean $i$f$getVisibility2 = false;
            minVisibility = $this$visibility$iv2.getStatus().getVisibility();
            FirPropertyAccessor firPropertyAccessor = $this$getMinimumVisibility.getGetter();
            if (firPropertyAccessor != null) {
                it = firPropertyAccessor;
                boolean bl = false;
                $this$visibility$iv = it;
                $i$f$getVisibility = false;
                minVisibility = INSTANCE.chooseMostSpecific(minVisibility, $this$visibility$iv.getStatus().getVisibility());
            }
            FirPropertyAccessor firPropertyAccessor2 = $this$getMinimumVisibility.getSetter();
            if (firPropertyAccessor2 == null) break block1;
            it = firPropertyAccessor2;
            boolean bl = false;
            $this$visibility$iv = it;
            $i$f$getVisibility = false;
            minVisibility = INSTANCE.chooseMostSpecific(minVisibility, $this$visibility$iv.getStatus().getVisibility());
        }
        return minVisibility;
    }

    private final Visibility chooseMostSpecific(Visibility a2, Visibility b2) {
        Integer n2 = a2.compareTo(b2);
        if (n2 == null) {
            return a2;
        }
        int difference2 = n2;
        return difference2 > 0 ? b2 : a2;
    }

    private final void checkStaticOnConst(CheckerContext context2, DiagnosticReporter reporter, FirDeclaration declaration, KtSourceElement targetSource) {
        if (!(declaration instanceof FirProperty)) {
            return;
        }
        FirMemberDeclaration $this$isConst$iv = (FirMemberDeclaration)declaration;
        boolean $i$f$isConst = false;
        if ($this$isConst$iv.getStatus().isConst()) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)targetSource, FirJsErrors.INSTANCE.getJS_STATIC_ON_CONST(), null, 8, null);
        }
    }

    private final boolean containerIsInterface(FirClassLikeSymbol<?> $this$containerIsInterface) {
        boolean bl;
        Object object = FirHelpersKt.getContainingClassSymbol((FirBasedSymbol)$this$containerIsInterface);
        if (object != null && (object = FirHelpersKt.getClassKind(object)) != null) {
            Object $this$isInterface$iv = object;
            boolean $i$f$isInterface = false;
            bl = $this$isInterface$iv == ClassKind.INTERFACE;
        } else {
            bl = false;
        }
        return bl;
    }

    private final boolean isCompanion(FirClassLikeSymbol<?> $this$isCompanion) {
        boolean bl;
        FirRegularClassSymbol firRegularClassSymbol = $this$isCompanion instanceof FirRegularClassSymbol ? (FirRegularClassSymbol)$this$isCompanion : null;
        if (firRegularClassSymbol != null) {
            FirClassLikeSymbol $this$isCompanion$iv = firRegularClassSymbol;
            boolean $i$f$isCompanion = false;
            bl = $this$isCompanion$iv.getRawStatus().isCompanion();
        } else {
            bl = false;
        }
        return bl;
    }

    private final FirAnnotation findAnnotation(FirDeclaration $this$findAnnotation, ClassId classId, FirSession session) {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = $this$findAnnotation.getAnnotations();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                FirAnnotation it = (FirAnnotation)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual(FirHelpersKt.fullyExpandedClassId(FirTypeUtilsKt.getConeType(it.getAnnotationTypeRef()), session), classId)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private static final void check$checkIfAnnotated(CheckerContext $context, FirDeclaration $declaration, DiagnosticReporter $reporter, FirDeclaration it) {
        if (!FirAnnotationUtilsKt.hasAnnotation(it, JsStandardClassIds.Annotations.JsStatic, $context.getSession())) {
            return;
        }
        KtSourceElement ktSourceElement = it.getSource();
        if (ktSourceElement == null) {
            ktSourceElement = $declaration.getSource();
        }
        KtSourceElement targetSource = ktSourceElement;
        INSTANCE.checkAnnotated($context, $reporter, it, targetSource);
    }
}

