/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.pipeline.jvm;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtSourceFile;
import org.jetbrains.kotlin.backend.common.extensions.IrGenerationExtension;
import org.jetbrains.kotlin.backend.jvm.JvmIrDeserializerImpl;
import org.jetbrains.kotlin.cli.jvm.compiler.FirFindMainClassKt;
import org.jetbrains.kotlin.cli.jvm.compiler.VfsBasedProjectEnvironment;
import org.jetbrains.kotlin.cli.jvm.compiler.legacy.pipeline.JvmCompilerPipelineKt;
import org.jetbrains.kotlin.cli.pipeline.CheckCompilationErrors;
import org.jetbrains.kotlin.cli.pipeline.PerformanceNotifications;
import org.jetbrains.kotlin.cli.pipeline.PipelinePhase;
import org.jetbrains.kotlin.cli.pipeline.jvm.JvmFir2IrPipelineArtifact;
import org.jetbrains.kotlin.cli.pipeline.jvm.JvmFrontendPipelineArtifact;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.JVMConfigurationKeys;
import org.jetbrains.kotlin.diagnostics.impl.BaseDiagnosticsCollector;
import org.jetbrains.kotlin.fir.backend.jvm.JvmFir2IrExtensions;
import org.jetbrains.kotlin.fir.pipeline.Fir2IrActualizedResult;
import org.jetbrains.kotlin.fir.pipeline.FirResult;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\u001e\u0010\u0006\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0007\u001a\u00020\u00022\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/cli/pipeline/jvm/JvmFir2IrPipelinePhase;", "Lorg/jetbrains/kotlin/cli/pipeline/PipelinePhase;", "Lorg/jetbrains/kotlin/cli/pipeline/jvm/JvmFrontendPipelineArtifact;", "Lorg/jetbrains/kotlin/cli/pipeline/jvm/JvmFir2IrPipelineArtifact;", "<init>", "()V", "executePhase", "input", "irGenerationExtensions", "", "Lorg/jetbrains/kotlin/backend/common/extensions/IrGenerationExtension;", "cli"})
@SourceDebugExtension(value={"SMAP\nJvmFir2IrPipelinePhase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmFir2IrPipelinePhase.kt\norg/jetbrains/kotlin/cli/pipeline/jvm/JvmFir2IrPipelinePhase\n+ 2 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n*L\n1#1,51:1\n233#2:52\n*S KotlinDebug\n*F\n+ 1 JvmFir2IrPipelinePhase.kt\norg/jetbrains/kotlin/cli/pipeline/jvm/JvmFir2IrPipelinePhase\n*L\n37#1:52\n*E\n"})
public final class JvmFir2IrPipelinePhase
extends PipelinePhase<JvmFrontendPipelineArtifact, JvmFir2IrPipelineArtifact> {
    @NotNull
    public static final JvmFir2IrPipelinePhase INSTANCE = new JvmFir2IrPipelinePhase();

    private JvmFir2IrPipelinePhase() {
        Function3[] function3Array = new Function3[]{PerformanceNotifications.TranslationToIrFinished.INSTANCE, CheckCompilationErrors.CheckDiagnosticCollector.INSTANCE};
        super("JvmFir2IrPipelinePhase", SetsKt.setOf(PerformanceNotifications.TranslationToIrStarted.INSTANCE), SetsKt.setOf(function3Array));
    }

    @Override
    @Nullable
    public JvmFir2IrPipelineArtifact executePhase(@NotNull JvmFrontendPipelineArtifact input) {
        Intrinsics.checkNotNullParameter(input, "input");
        return this.executePhase(input, IrGenerationExtension.Companion.getInstances(input.getEnvironment().getProject()));
    }

    @Nullable
    public final JvmFir2IrPipelineArtifact executePhase(@NotNull JvmFrontendPipelineArtifact input, @NotNull List<? extends IrGenerationExtension> irGenerationExtensions) {
        FqName fqName;
        Intrinsics.checkNotNullParameter(input, "input");
        Intrinsics.checkNotNullParameter(irGenerationExtensions, "irGenerationExtensions");
        FirResult firResult = input.component1();
        CompilerConfiguration configuration2 = input.component2();
        VfsBasedProjectEnvironment environment = input.component3();
        BaseDiagnosticsCollector diagnosticCollector = input.component4();
        List<KtSourceFile> sourceFiles = input.component5();
        JvmFir2IrExtensions fir2IrExtensions = new JvmFir2IrExtensions(configuration2, new JvmIrDeserializerImpl());
        Fir2IrActualizedResult fir2IrAndIrActualizerResult = JvmCompilerPipelineKt.convertToIrAndActualizeForJvm(firResult, fir2IrExtensions, configuration2, diagnosticCollector, (Collection<? extends IrGenerationExtension>)irGenerationExtensions);
        boolean condition$iv = configuration2.get(JVMConfigurationKeys.OUTPUT_JAR) != null;
        boolean $i$f$runIf = false;
        if (condition$iv) {
            boolean bl = false;
            fqName = FirFindMainClassKt.findMainClass(CollectionsKt.last(firResult.getOutputs()).getFir());
        } else {
            fqName = null;
        }
        FqName mainClassFqName = fqName;
        return new JvmFir2IrPipelineArtifact(fir2IrAndIrActualizerResult, configuration2, environment, diagnosticCollector, sourceFiles, mainClassFqName);
    }
}

