/*
 * Decompiled with CFR 0.152.
 */
package io.vavr.collection;

import io.vavr.collection.List;
import io.vavr.collection.Stream;
import io.vavr.collection.Tree;
import java.util.LinkedList;

interface TreeModule {
    public static <T> Stream<Tree.Node<T>> traversePreOrder(Tree.Node<T> node) {
        return node.getChildren().foldLeft(Stream.of(node), (acc, child) -> acc.appendAll((Iterable)TreeModule.traversePreOrder(child)));
    }

    public static <T> Stream<Tree.Node<T>> traverseInOrder(Tree.Node<T> node) {
        if (node.isLeaf()) {
            return Stream.of(node);
        }
        List<Tree.Node<T>> children = node.getChildren();
        return children.tail().foldLeft(Stream.empty(), (acc, child) -> acc.appendAll((Iterable)TreeModule.traverseInOrder(child))).prepend(node).prependAll(TreeModule.traverseInOrder((Tree.Node)children.head()));
    }

    public static <T> Stream<Tree.Node<T>> traversePostOrder(Tree.Node<T> node) {
        return node.getChildren().foldLeft(Stream.empty(), (acc, child) -> acc.appendAll((Iterable)TreeModule.traversePostOrder(child))).append(node);
    }

    public static <T> Stream<Tree.Node<T>> traverseLevelOrder(Tree.Node<T> node) {
        Stream<Tree.Node> result2 = Stream.empty();
        LinkedList<Tree.Node<T>> queue = new LinkedList<Tree.Node<T>>();
        queue.add(node);
        while (!queue.isEmpty()) {
            Tree.Node next = (Tree.Node)queue.remove();
            result2 = result2.prepend(next);
            queue.addAll(next.getChildren().toJavaList());
        }
        return result2.reverse();
    }
}

